/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.StreamLoader;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.CertificateGeneratorImpl;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.JCEManager;
import com.pingidentity.pingcommons.util.Closer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.CoreConfig;

public class CertificateServiceImpl
extends CertificateGeneratorImpl
implements CertificateService,
AutoReloadable {
    protected static final String FIPS_KEY = "pf.hsm.mode";
    protected static final String NCIPHER_MODE = "ncipher";
    public static final String PF_SSL_CLIENT_TRUST_CAS_FILENAME = "ping-ssl-client-trust-cas.jks";
    private static final String PUBLIC_CERT_STORE_INTEGRITY_CHECK_ONLY = "PublicCertStoreIntegrityCheckOnly";
    private final JCEManager jceManager;
    private final CoreConfig coreConfig;
    private final SysDirInfo sysDirInfo;
    private final StreamLoader streamLoader;
    protected KeyStore dsigKeystore = null;
    protected KeyStore dsigHSMKeystore = null;
    protected KeyStore sslKeystore = null;
    protected KeyStore sslHSMKeystore = null;
    protected KeyStore generalKeystore = null;
    protected KeyStore generalHSMKeystore = null;
    protected KeyStore trustKeystore;
    protected KeyStore trustHSMKeystore;
    protected KeyStore sslServerKeystore;
    protected KeyStore sslServerHSMKeystore;

    public CertificateServiceImpl(JCEManager jceManager, CoreConfig coreConfig, SysDirInfo sysDirInfo, StreamLoader streamLoader) {
        this.jceManager = jceManager;
        this.coreConfig = coreConfig;
        this.sysDirInfo = sysDirInfo;
        this.streamLoader = streamLoader;
        this.setupSslClientTrustStore();
    }

    @Override
    public void init() {
    }

    @Override
    protected List<String> getPreferredSignatureAlgorithms(String keyAlgorithm) {
        ArrayList<String> result = new ArrayList<String>(super.getPreferredSignatureAlgorithms(keyAlgorithm));
        ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
        Map keyAlgoToDefaultSigAlgoMap = configStore.getMapValue("KeyAlgoToSigAlgos", new HashMap());
        String defaultSigAlgo = (String)keyAlgoToDefaultSigAlgoMap.get(keyAlgorithm);
        if (defaultSigAlgo != null) {
            result.add(0, defaultSigAlgo);
        }
        return result;
    }

    @Override
    public KeyStore getDsigKeystore() throws ConfigurationException {
        if (this.dsigKeystore == null) {
            this.dsigKeystore = this.getKeystore(this.coreConfig.getDsigKeystoreName(), this.coreConfig.getDsigKeystorePassword());
        }
        return this.dsigKeystore;
    }

    @Override
    public KeyStore getDsigHSMKeystore() throws ConfigurationException {
        if (this.dsigHSMKeystore == null) {
            this.dsigHSMKeystore = this.getKeystore(this.coreConfig.getDsigHSMKeystoreName(), this.coreConfig.getDsigHSMKeystorePassword());
        }
        return this.dsigHSMKeystore;
    }

    @Override
    public KeyStore getGeneralKeystore() {
        if (this.generalKeystore == null) {
            this.generalKeystore = this.getKeystore(this.coreConfig.getGeneralKeystoreName(), this.coreConfig.getGeneralKeystorePassword());
        }
        return this.generalKeystore;
    }

    @Override
    public KeyStore getSslKeystore() {
        if (this.sslKeystore == null) {
            this.sslKeystore = this.getKeystore(this.coreConfig.getSslKeystoreName(), this.coreConfig.getSslKeystorePassword());
        }
        return this.sslKeystore;
    }

    @Override
    public KeyStore getSslServerKeystore() {
        if (this.sslServerKeystore == null) {
            this.sslServerKeystore = this.getKeystore(this.coreConfig.getSslServerKeystoreName(), this.coreConfig.getSslServerKeystorePassword());
        }
        return this.sslServerKeystore;
    }

    @Override
    public KeyStore getSslServerHSMKeystore() {
        if (this.sslServerHSMKeystore == null) {
            this.sslServerHSMKeystore = this.getKeystore(this.coreConfig.getSslServerHSMKeystoreName(), this.coreConfig.getSslServerHSMKeystorePassword());
        }
        return this.sslServerHSMKeystore;
    }

    @Override
    public KeyStore getTrustKeystore() {
        if (this.trustKeystore == null) {
            this.trustKeystore = this.getKeystore(this.coreConfig.getTrustKeystoreName(), this.coreConfig.getTrustKeystorePassword());
        }
        return this.trustKeystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore getKeystore(String name, String pass) {
        InputStream storeStream = null;
        KeyStore keystore = null;
        BufferedInputStream keystoreBufferedInputStream = null;
        boolean retry = false;
        do {
            try {
                storeStream = this.getKeystoreInputStream(name);
                keystoreBufferedInputStream = storeStream != null ? new BufferedInputStream(storeStream) : null;
                String storePassword = this.getKeystorePassword(name);
                pass = StringUtils.isNotBlank((CharSequence)storePassword) ? storePassword : pass;
                String keystoreType = this.coreConfig.getKeyStoreType(name);
                if ("default".equals(keystoreType)) {
                    String ext;
                    keystoreType = this.jceManager.getKeystoreType(name);
                    keystoreBufferedInputStream = this.convertKeystoreFromPkcs12ToJksIfNecessary(keystoreBufferedInputStream, name, pass);
                    if (PropertyInfo.isHSMHybrid() && "jks".equals(ext = FilenameUtils.getExtension((String)name))) {
                        keystoreType = KeyStore.getDefaultType();
                    }
                } else {
                    String trustStoreName = this.coreConfig.getTrustKeystoreName();
                    if (!name.equals(trustStoreName)) {
                        String defaultType = this.jceManager.getKeystoreType(name);
                        String string = defaultType = StringUtils.equalsIgnoreCase((CharSequence)"pkcs12", (CharSequence)defaultType) ? "jks" : defaultType;
                        if (!defaultType.equalsIgnoreCase(keystoreType)) {
                            throw new ConfigurationException("The keystore type of " + name + " must be either default or " + defaultType);
                        }
                    }
                }
                this.log.debug((Object)("keystore type of " + name + ": " + keystoreType));
                keystore = KeyStore.getInstance(keystoreType);
                keystore.load(keystoreBufferedInputStream, pass.toCharArray());
                retry = false;
            }
            catch (Exception e) {
                try {
                    if (!NCIPHER_MODE.equalsIgnoreCase(System.getProperty(FIPS_KEY)) || retry) {
                        throw new ConfigurationException("Unable to load system keystore: " + name, e);
                    }
                    this.log.warn((Object)("Error occured while getting keystore.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                    retry = true;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(keystoreBufferedInputStream);
                    IOUtils.closeQuietly((InputStream)storeStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)keystoreBufferedInputStream);
                IOUtils.closeQuietly((InputStream)storeStream);
            }
            IOUtils.closeQuietly((InputStream)keystoreBufferedInputStream);
            IOUtils.closeQuietly((InputStream)storeStream);
        } while (retry);
        return keystore;
    }

    @Override
    public void writeDsigKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongDsigKeystorePassword(), this.coreConfig.getDsigKeystoreName());
    }

    @Override
    public void writeDsigHSMKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongDsigHSMKeystorePassword(), this.coreConfig.getDsigHSMKeystoreName());
    }

    @Override
    public void writeGeneralKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongGeneralKeystorePassword(), this.coreConfig.getGeneralKeystoreName());
    }

    @Override
    public void writeSslKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongSslKeystorePassword(), this.coreConfig.getSslKeystoreName());
    }

    @Override
    public void writeSslServerKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongSslServerKeystorePassword(), this.coreConfig.getSslServerKeystoreName());
    }

    @Override
    public void writeSslServerHSMKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongSslServerHSMKeystorePassword(), this.coreConfig.getSslServerHSMKeystoreName());
    }

    @Override
    public void writeTrustKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongTrustKeystorePassword(), this.coreConfig.getTrustKeystoreName());
    }

    protected void clearCachedKeystores() {
        this.dsigKeystore = null;
        this.dsigHSMKeystore = null;
        this.sslKeystore = null;
        this.sslHSMKeystore = null;
        this.generalKeystore = null;
        this.generalHSMKeystore = null;
        this.trustKeystore = null;
        this.trustHSMKeystore = null;
        this.sslServerKeystore = null;
        this.sslServerHSMKeystore = null;
    }

    protected synchronized void writeKeystore(KeyStore ks, String password, String name) {
        this.log.debug((Object)("saving keystore " + name));
        this.clearCachedKeystores();
        OutputStream keystoreStream = this.streamLoader.getOutputStream(this.sysDirInfo.getDataDirectory(), name);
        if (keystoreStream != null) {
            try {
                ks.store(keystoreStream, password.toCharArray());
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to write keystore: " + name, e);
            }
            finally {
                Closer.close((Closeable)keystoreStream);
            }
        }
    }

    @Override
    public InputStream getKeystoreInputStream(String keystoreName) throws FileNotFoundException {
        File keystoreFile = new File(this.sysDirInfo.getDataDirectory(), keystoreName);
        if (keystoreFile.exists() && keystoreFile.canRead()) {
            return this.streamLoader.getInputStream(keystoreFile);
        }
        return null;
    }

    @Override
    public String getKeystorePassword(String keystoreName) {
        return null;
    }

    @Override
    public String getKeystoreType() {
        return this.jceManager.getKeystoreType();
    }

    @Override
    public String getKeystoreType(String keystoreFilename) {
        return this.jceManager.getKeystoreType(keystoreFilename);
    }

    @Override
    public void reload() {
        this.clearCachedKeystores();
        this.setupSslClientTrustStore();
    }

    @Override
    public synchronized void setupSslClientTrustStore() {
        try {
            KeyStore comboTrustCAs = this.loadCaCertsKeyStore();
            HashSet<X509Certificate> trustedCASet = new HashSet<X509Certificate>();
            if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
                this.getX509CertsFromKeystore(comboTrustCAs, trustedCASet, this.getTrustKeystore());
            }
            if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
                this.getX509CertsFromKeystore(comboTrustCAs, trustedCASet, this.getTrustHSMKeystore());
            }
            trustedCASet.addAll(this.getJavaTrustedCaCerts());
            File pfCaFile = new File(this.sysDirInfo.getDataDirectory(), PF_SSL_CLIENT_TRUST_CAS_FILENAME);
            String pfCaFilename = pfCaFile.getAbsolutePath();
            this.log.debug((Object)("Creating " + pfCaFilename));
            this.writeKeystore(comboTrustCAs, PUBLIC_CERT_STORE_INTEGRITY_CHECK_ONLY, PF_SSL_CLIENT_TRUST_CAS_FILENAME);
            System.setProperty("javax.net.ssl.trustStore", pfCaFilename);
            System.setProperty("javax.net.ssl.trustStorePassword", PUBLIC_CERT_STORE_INTEGRITY_CHECK_ONLY);
            PingSslClientTrustManager pingLdapSslClientTrustManager = PingSslClientTrustManager.getInstance();
            pingLdapSslClientTrustManager.setTrustedCAs(trustedCASet);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in setupSslClientTrustStore()", (Throwable)e);
        }
    }

    private void getX509CertsFromKeystore(KeyStore comboTrustCAs, Set<X509Certificate> trustedCASet, KeyStore customTrustStore) throws KeyStoreException {
        Enumeration<String> customAliasList = customTrustStore.aliases();
        while (customAliasList.hasMoreElements()) {
            String alias = customAliasList.nextElement();
            Certificate cert = customTrustStore.getCertificate(alias);
            comboTrustCAs.setCertificateEntry(alias, cert);
            trustedCASet.add((X509Certificate)cert);
        }
    }

    @Override
    public KeyStore getSslHSMKeystore() {
        if (this.sslHSMKeystore == null) {
            this.sslHSMKeystore = this.getKeystore(this.coreConfig.getSslHSMKeystoreName(), this.coreConfig.getSslHSMKeystorePassword());
        }
        return this.sslHSMKeystore;
    }

    @Override
    public void writeSslHSMKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongSslHSMKeystorePassword(), this.coreConfig.getSslHSMKeystoreName());
    }

    @Override
    public KeyStore getGeneralHSMKeystore() {
        if (this.generalHSMKeystore == null) {
            this.generalHSMKeystore = this.getKeystore(this.coreConfig.getGeneralHSMKeystoreName(), this.coreConfig.getGeneralHSMKeystorePassword());
        }
        return this.generalHSMKeystore;
    }

    @Override
    public void writeGeneralHSMKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongGeneralHSMKeystorePassword(), this.coreConfig.getGeneralHSMKeystoreName());
    }

    @Override
    public KeyStore getTrustHSMKeystore() {
        if (this.trustHSMKeystore == null) {
            this.trustHSMKeystore = this.getKeystore(this.coreConfig.getTrustHSMKeystoreName(), this.coreConfig.getTrustHSMKeystorePassword());
        }
        return this.trustHSMKeystore;
    }

    @Override
    public void writeTrustHSMKeystore(KeyStore keystore) {
        this.writeKeystore(keystore, this.coreConfig.getOrCreateStrongTrustHSMKeystorePassword(), this.coreConfig.getTrustHSMKeystoreName());
    }

    private BufferedInputStream convertKeystoreFromPkcs12ToJksIfNecessary(BufferedInputStream storeStream, String name, String password) throws ConfigurationException {
        if (storeStream != null && !name.endsWith("hsmks") && (PropertyInfo.HSM_MODE.OFF.equals((Object)PropertyInfo.getHSMMode()) || PropertyInfo.isBCFIPSMode())) {
            storeStream.mark(10);
            int head = 0;
            try {
                head = storeStream.read();
                if (head == 48 && PropertyInfo.isBCFIPSMode()) {
                    throw new ConfigurationException("Found PKCS12 keystore but already in BCFIPS mode. Turn off BCFIPS mode and restart PF. Once keystores converted please put PingFederate back in BCFIPS mode.");
                }
                if (head == 48) {
                    this.log.info((Object)String.format("Converting keystore '%s' from PKCS12 to JKS", name));
                    storeStream.reset();
                    KeyStore pkcs12 = KeyStore.getInstance("pkcs12");
                    pkcs12.load(storeStream, password.toCharArray());
                    KeyStore jks = KeyStore.getInstance("jks");
                    jks.load(null, null);
                    Enumeration<String> aliases = pkcs12.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        KeyStore.PasswordProtection passwordProtection = this.coreConfig.getPasswordForAlias(name, alias);
                        KeyStore.Entry entry = pkcs12.getEntry(alias, passwordProtection);
                        jks.setEntry(alias, entry, passwordProtection);
                    }
                    IOUtils.closeQuietly((InputStream)storeStream);
                    this.writeKeystore(jks, password, name);
                    storeStream = new BufferedInputStream(this.getKeystoreInputStream(name));
                } else {
                    storeStream.reset();
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
                this.log.error((Object)e);
            }
        }
        return storeStream;
    }

    @Override
    protected boolean enforceFIPSKeySizes() {
        return this.jceManager != null && this.jceManager.isEnforceFIPSKeySizes();
    }

    @Override
    public PrivateKey findPrivateKeyById(String id) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new NotImplementedException("Method is not supported for JCE provider");
    }

    @Override
    public boolean doPrivateKeyAndCertificateMatch(PrivateKey privateKey, X509Certificate x509Certificate) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        byte[] bytesToSign = IDGenerator.generateBytes(128);
        Signature signature = this.getDefaultSignatureInstanceByKeyType(privateKey, this.getHSMProviderName());
        signature.initSign(privateKey);
        signature.update(bytesToSign);
        byte[] sign = signature.sign();
        Signature verifySignature = this.getDefaultSignatureInstanceByKeyType(privateKey, null);
        verifySignature.initVerify(x509Certificate);
        verifySignature.update(bytesToSign);
        return verifySignature.verify(sign);
    }

    private Signature getDefaultSignatureInstanceByKeyType(PrivateKey privateKey, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        String algorithm;
        String privateKeyAlgorithm;
        switch (privateKeyAlgorithm = privateKey.getAlgorithm()) {
            case "RSA": {
                algorithm = "SHA1withRSA";
                break;
            }
            case "DSA": {
                algorithm = "SHA1withDSA";
                break;
            }
            case "EC": {
                algorithm = "SHA256withECDSA";
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("private key uses an unknown algorithm: " + privateKeyAlgorithm);
            }
        }
        if (StringUtils.isBlank((CharSequence)providerName)) {
            return Signature.getInstance(algorithm);
        }
        return Signature.getInstance(algorithm, providerName);
    }
}

