/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.DSignRotationTask;
import com.pingidentity.crypto.PkCert;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public class DSignRotationService {
    private static final Log log = LogFactory.getLog(DSignRotationService.class);
    private static long MILLI_SECONDS_IN_DAY = 86400000L;
    private ConfigStore configStore = ConfigStoreFarm.getConfig(DSignRotationService.class);
    private static String CONFIG_STORE_DELAY_FIELD_NAME = "ScheduleCertRotationDelayInMins";
    private static DSignRotationSettingsManager dSignRotationSettingsMgr = MgmtFactory.getDSignRotationSettingsManager();
    private Timer timer;
    private volatile boolean cancelled = false;
    private String taskName;
    private PkCertManager pkCertManager;
    private TimerTask timerTask;
    private DSignRotationTask rotationTask;

    public DSignRotationService(String taskName, PkCertManager manager, DSignRotationTask rotationTask, Timer timer) {
        this.taskName = taskName;
        this.pkCertManager = manager;
        this.timer = timer;
        this.rotationTask = rotationTask;
    }

    public void start() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (DSignRotationService.this.cancelled) {
                    return;
                }
                Mediator mediator = MgmtFactory.getMediator();
                if (mediator.isConsole()) {
                    log.debug((Object)DSignRotationService.this.makeLogMessage("started"));
                    DSignRotationService.this.checkCertRotation();
                }
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCertRotation() {
        if (this.cancelled) {
            return;
        }
        if (!MgmtFactory.getAdminNodeConfigManager().isEnabledAndPassiveNode()) {
            try {
                Set<PkCert> signingCerts = this.pkCertManager.getPkCerts();
                HashSet<PkCert> newsigninCerts = new HashSet<PkCert>(signingCerts);
                DSignRotationService dSignRotationService = this;
                synchronized (dSignRotationService) {
                    for (PkCert signingCert : newsigninCerts) {
                        String certAlias = signingCert.getAlias();
                        DSignRotationSetting pkCertRotationSetting = dSignRotationSettingsMgr.getRotationSetting(certAlias);
                        if (pkCertRotationSetting == null || !pkCertRotationSetting.isEnableCertRotation()) continue;
                        this.checkRotatePkCert(signingCert, pkCertRotationSetting);
                        this.checkActivatePendingPkCert(signingCert, pkCertRotationSetting);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)this.makeLogMessage("Unexpected error during Signing  rotation."), t);
            }
        }
        this.scheduleNextCheck();
    }

    protected void scheduleNextCheck() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                DSignRotationService.this.checkCertRotation();
            }
        };
        long delay = MILLI_SECONDS_IN_DAY;
        try {
            long delayValue = this.configStore.getLongValue(CONFIG_STORE_DELAY_FIELD_NAME);
            delay = delayValue * 60L * 1000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timer.schedule(this.timerTask, delay);
    }

    protected void checkRotatePkCert(PkCert currentCert, DSignRotationSetting pkCertRotationSetting) {
        log.trace((Object)this.makeLogMessage("Checking whether certificate rotation should be initiated."));
        if (currentCert != null) {
            long expires = currentCert.getX509Certificate().getNotAfter().getTime();
            if (pkCertRotationSetting != null && (StringUtils.isEmpty((String)pkCertRotationSetting.getPendingCertAlias()) || !this.isValidCertAlias(pkCertRotationSetting.getPendingCertAlias()))) {
                int rotationBufferMin = pkCertRotationSetting.getRotationBufferMins();
                long remainingMillis = pkCertRotationSetting.getRemainingMillis(expires, rotationBufferMin);
                if (remainingMillis <= 0L) {
                    log.debug((Object)this.makeLogMessage("Creating new Digital Signing Certificate."));
                    this.rotationTask.createNewPkCert(currentCert, pkCertRotationSetting);
                } else {
                    log.debug((Object)this.makeLogMessage("Pending cert will be created for " + currentCert.getAlias() + " in " + String.format("%.2f", (double)remainingMillis / 60000.0) + " mins"));
                }
            }
        }
    }

    protected void checkActivatePendingPkCert(PkCert currentCert, DSignRotationSetting rotationSetting) {
        PkCert pendingCert;
        String certAlias = currentCert.getAlias();
        if (rotationSetting != null && (pendingCert = this.getPendingPkCert(certAlias)) != null) {
            String pendingCertAlias = pendingCert.getAlias();
            int activationBuffer = rotationSetting.getActivationBufferMins();
            long expires = currentCert.getX509Certificate().getNotAfter().getTime();
            long remainingMillis = rotationSetting.getRemainingMillis(expires, activationBuffer);
            if (remainingMillis <= 0L) {
                log.debug((Object)this.makeLogMessage("Started pushing pending Signing Certificate (alias " + pendingCertAlias + ") to connections"));
                try {
                    this.rotationTask.activatePendingPkCert(certAlias, pendingCert);
                }
                catch (Exception e) {
                    log.error((Object)this.makeLogMessage("Error occurred while pushing pending PkCert into connections. "), (Throwable)e);
                }
            } else {
                log.debug((Object)this.makeLogMessage("Pending cert " + pendingCertAlias + " will be activated in " + String.format("%.2f", (double)remainingMillis / 60000.0) + " mins"));
            }
        }
    }

    private PkCert getPendingPkCert(String certAlias) {
        PkCert pendingCert = null;
        DSignRotationSetting pkCertRotationSetting = dSignRotationSettingsMgr.getRotationSetting(certAlias);
        if (pkCertRotationSetting != null) {
            String pendingCertAlias = pkCertRotationSetting.getPendingCertAlias();
            pendingCert = this.pkCertManager.getPkCert(pendingCertAlias);
        }
        return pendingCert;
    }

    protected String makeLogMessage(String message) {
        return this.taskName + ": " + message;
    }

    public void cancel() {
        log.debug((Object)this.makeLogMessage("cancelling task"));
        this.cancelled = true;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (DSignRotationService.this.timerTask != null) {
                    DSignRotationService.this.timerTask.cancel();
                    DSignRotationService.this.timerTask = null;
                }
            }
        }, 0L);
    }

    private boolean isValidCertAlias(String certAlias) {
        boolean isValid = false;
        if (certAlias != null) {
            PkCert cert = this.pkCertManager.getPkCert(certAlias);
            isValid = cert != null;
        }
        return isValid;
    }
}

