/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SignatureAlgorithm;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.pingcommons.crypto.X509CertificateValueHelper;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;

public class DSignRotationTask {
    private static final Log log = LogFactory.getLog(DSignRotationTask.class);
    private DSignRotationSettingsManager pkCertRotationManager;
    private ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    private static final String SUBJECT_DN = "SUBJECT_DN";
    private static final String EX_DATE = "EX_DATE";
    private static final String PENDING_CERT_SERIAL_NUM = "PENDING_SERIAL_NUMBER";
    private static final String ACTIVATION_DATE = "ACTIVATION_DATE";
    private static final String PENDING_EX_DATE = "PENDING_EX_DATE";
    private static final String ACTIVE_CONNECTIONS = "ACTIVE_CONNECTIONS";
    private static final String CERT_ROTATION_TEMPLATE = "message-template-cert-rotation.html";
    private static final String CERT_DEACTIVATE_TEMPLATE = "message-template-cert-deactivation.html";

    public DSignRotationTask(DSignRotationSettingsManager pkCertRotationManager) {
        this.pkCertRotationManager = pkCertRotationManager;
    }

    public void activatePendingPkCert(String originalCertAlias, PkCert pendingPkCert) throws IOException {
        if (pendingPkCert != null) {
            DSignRotationSetting settings;
            Collection<ConnectionBase> connections = this.connectionManager.getFilteredConnections();
            boolean connectionsUpdate = false;
            String subjectDN = null;
            StringBuilder affectedConnections = new StringBuilder();
            for (ConnectionBase connection : connections) {
                if (!connection.isActive()) continue;
                PkCert signingCert = connection.getSigningPkCert();
                String pendingCertAlias = pendingPkCert.getAlias();
                boolean signingCertRotated = false;
                subjectDN = pendingPkCert.getX509Certificate().getSubjectDN().toString();
                if (signingCert != null && !StringUtils.isEmpty((String)originalCertAlias) && originalCertAlias.equals(signingCert.getAlias())) {
                    connection.setSigningKeyAlias(pendingCertAlias);
                    boolean isKeyAlgoMatch = false;
                    String connectionSigningAlgoUri = connection.getSigningAlgorithm();
                    String connSigningAlgo = SignatureAlgorithms.getInstance().algUriToName(connectionSigningAlgoUri);
                    String pendingCertKeyAlgo = pendingPkCert.getPublicKeyAlgorithm();
                    isKeyAlgoMatch = connSigningAlgo.startsWith(pendingCertKeyAlgo);
                    if (!isKeyAlgoMatch) {
                        SignatureAlgorithm defaultSigningAlgo = SignatureAlgorithms.getInstance().getDefaultSignatureAlgorithmOfType(pendingCertKeyAlgo);
                        connection.setSigningAlgorithm(defaultSigningAlgo.getUri());
                    }
                    signingCertRotated = true;
                    log.debug((Object)(" The Signing certificate " + subjectDN + " in the connection " + connection.getEntityId() + " has been rotated."));
                }
                boolean decryptCertRotated = this.removeOriginalCertRefInConn(originalCertAlias, connection, subjectDN, pendingCertAlias);
                if (!signingCertRotated && !decryptCertRotated) continue;
                String logMessage = "Certificate rotation COMPLETED for " + subjectDN + " in " + connection.getRoleType().toString() + " connection - " + connection.getEntityId();
                this.updateConnection(connection, logMessage);
                connectionsUpdate = true;
                String connEntityId = this.getConnNameEntityIdForEmail(connection.getName(), connection.getEntityId());
                affectedConnections.append(connEntityId);
            }
            if (connectionsUpdate) {
                PkCert originalPkCert = MgmtFactory.getDsigPkCertManager().getPkCert(originalCertAlias);
                String pendingCertSerNo = pendingPkCert.getSerialNumberForDisplay();
                if (originalPkCert != null) {
                    log.debug((Object)("Sending email notification for activation of pending cert with: Subject DN - " + subjectDN + " Serial#- " + pendingCertSerNo));
                    this.sendNotification(CERT_DEACTIVATE_TEMPLATE, originalPkCert, pendingPkCert, affectedConnections.toString(), NotificationEventType.CERTIFICATE_EVENT_ACTIVATED);
                }
            }
            if ((settings = this.pkCertRotationManager.getRotationSetting(originalCertAlias)) != null) {
                settings.setEnableCertRotation(false);
                this.pkCertRotationManager.addRotationSetting(settings);
            }
        }
    }

    private String getConnNameEntityIdForEmail(String name, String entityId) {
        return "\t" + name + " (" + entityId + ")\n";
    }

    private String addPendingDecryptionKeyToConn(String originalCertAlias, PkCert pendingPkCert, String signingConnectionNames) {
        Object decryptionConnNames = "";
        if (pendingPkCert != null && !StringUtils.isEmpty((String)originalCertAlias)) {
            Collection<ConnectionBase> connections = this.connectionManager.getFilteredConnections();
            for (ConnectionBase connection : connections) {
                if (!connection.isActive()) continue;
                String subjectDN = pendingPkCert.getX509Certificate().getSubjectDN().toString();
                EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
                PkCert primaryDecryptCert = encryptionSettings.getDecryptionPkCert();
                String pendingCertAlias = pendingPkCert.getAlias();
                boolean certRotated = false;
                if (primaryDecryptCert != null && originalCertAlias.equals(primaryDecryptCert.getAlias())) {
                    if (pendingPkCert.getPrivateKey().getAlgorithm().equals("EC")) {
                        log.info((Object)("EC certificates not supported as Decryption Key. " + connection.getRoleType() + " connection " + connection.getEntityId() + " not updated with pending certificate."));
                    } else {
                        encryptionSettings.setDecryptionKeyAlias(pendingCertAlias);
                        encryptionSettings.setDecryptionPkCert(pendingPkCert);
                        encryptionSettings.setSecondaryDecryptionKeyAlias(originalCertAlias);
                        encryptionSettings.setSecondaryDecryptionPkCert(primaryDecryptCert);
                        connection.setEncryptionSettings(encryptionSettings);
                        certRotated = true;
                        String decryptionName = this.getConnNameEntityIdForEmail(connection.getName(), connection.getEntityId());
                        if (signingConnectionNames == null || !signingConnectionNames.contains(decryptionName)) {
                            decryptionConnNames = (String)decryptionConnNames + decryptionName;
                        }
                    }
                }
                if (!certRotated) continue;
                String logMessage = "Certificate rotation STARTED for " + subjectDN + " in " + connection.getRoleType().toString() + " connection - " + connection.getEntityId();
                this.updateConnection(connection, logMessage);
                log.debug((Object)(" The Decryption key " + subjectDN + " in the connection " + connection.getEntityId() + " has started rotation."));
            }
        }
        return decryptionConnNames;
    }

    private boolean removeOriginalCertRefInConn(String originalCertAlias, ConnectionBase connection, String subjectDN, String pendingCertAlias) {
        String secondaryDecryptCertAlias;
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        PkCert primaryDecryptCert = encryptionSettings.getDecryptionPkCert();
        PkCert secondaryDecryptCert = encryptionSettings.getSecondaryDecryptionPkCert();
        boolean certRotated = false;
        if (secondaryDecryptCert != null && !StringUtils.isEmpty((String)pendingCertAlias) && !StringUtils.isEmpty((String)(secondaryDecryptCertAlias = secondaryDecryptCert.getAlias())) && originalCertAlias.equals(secondaryDecryptCertAlias) && primaryDecryptCert.getAlias().equals(pendingCertAlias)) {
            encryptionSettings.setSecondaryDecryptionKeyAlias(null);
            encryptionSettings.setSecondaryDecryptionPkCert(null);
            connection.setEncryptionSettings(encryptionSettings);
            certRotated = true;
            log.debug((Object)(" The Decryption key " + subjectDN + " in the connection " + connection.getEntityId() + " has been rotated."));
        }
        return certRotated;
    }

    private void updateConnection(ConnectionBase connection, String updateMessage) {
        if (connection instanceof IdpConnection) {
            this.connectionManager.saveIdpConnection((IdpConnection)connection, AdminAuditLogger.Event.UPDATE, updateMessage);
        } else if (connection instanceof SpConnection) {
            this.connectionManager.saveSpConnection((SpConnection)connection, AdminAuditLogger.Event.UPDATE, updateMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PkCert createNewPkCert(PkCert originalPkCert, DSignRotationSetting rotationSettings) {
        PkCert pendingCert;
        block10: {
            pendingCert = null;
            try {
                AdminAuditLogger.initEventDetail();
                if (rotationSettings == null || !rotationSettings.isEnableCertRotation()) break block10;
                X509CertificateValueHelper certValueHelper = new X509CertificateValueHelper(originalPkCert.getX509Certificate());
                Date validFrom = new Date();
                DSignRotationTask dSignRotationTask = this;
                synchronized (dSignRotationTask) {
                    pendingCert = new PkCert.Builder().cn(certValueHelper.getCommonName()).ou(certValueHelper.getOrgUnit()).o(certValueHelper.getOrg()).l(certValueHelper.getCity()).st(certValueHelper.getState()).c(certValueHelper.getCountry()).validDays(rotationSettings.getValidityPeriodDays()).keyAlgo(rotationSettings.getKeyAlgorithm()).keySize(rotationSettings.getKeySize()).sigAlgorithm(rotationSettings.getSignatureAlgorithm()).certificateType(CertificateGenerator.CertificateType.dsigSigningCert).validFrom(validFrom).build();
                    MgmtFactory.getDsigPkCertManager().savePkCert(pendingCert);
                    String pendingCertAlias = pendingCert.getAlias();
                    rotationSettings.setPendingCertAlias(pendingCertAlias);
                    this.pkCertRotationManager.updateRotationSettings(rotationSettings);
                    DSignRotationSetting pendingCertRotationSettings = new DSignRotationSetting(rotationSettings, pendingCertAlias);
                    this.pkCertRotationManager.addRotationSetting(pendingCertRotationSettings);
                    String subjectDN = pendingCert.getX509Certificate().getSubjectDN().toString();
                    AdminAuditLogger.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.CREATE, "dsigSigningCert - " + subjectDN);
                    log.debug((Object)("A new pending certificate has been created to rotate the Digital Signing Certificate or Decryption Key with Subject DN: " + subjectDN));
                    String signingConnNames = this.saveConnectionsUsingSigningCert(originalPkCert.getAlias());
                    String decryptionConnNames = this.addPendingDecryptionKeyToConn(originalPkCert.getAlias(), pendingCert, signingConnNames);
                    log.debug((Object)("Sending email notification for creation of cert with: Subject DN - " + subjectDN + " Serial# - " + pendingCert.getSerialNumberForDisplay()));
                    this.sendNotification(CERT_ROTATION_TEMPLATE, originalPkCert, pendingCert, signingConnNames + decryptionConnNames, NotificationEventType.CERTIFICATE_EVENT_CREATED);
                }
            }
            catch (IOException e) {
                log.error((Object)("Unable to obtain subject from the certificate" + e));
            }
            catch (GeneralSecurityException e) {
                log.error((Object)("Unable to create a new certificate. " + e));
                e.printStackTrace();
            }
            finally {
                AdminAuditLogger.cleanupEventDetail();
            }
        }
        return pendingCert;
    }

    private Map<String, Object> getEmailParams(Cert originalCert, Cert pendingCert, String connections) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (originalCert != null && pendingCert != null) {
            Date originalCertExpiry = originalCert.getX509Certificate().getNotAfter();
            params.put(SERIAL_NUMBER, originalCert.getSerialNumberForDisplay());
            params.put(SUBJECT_DN, originalCert.getX509Certificate().getSubjectDN().toString());
            params.put(EX_DATE, originalCertExpiry.toString());
            params.put(PENDING_CERT_SERIAL_NUM, pendingCert.getSerialNumberForDisplay());
            params.put(PENDING_EX_DATE, pendingCert.getX509Certificate().getNotAfter().toString());
            params.put(ACTIVE_CONNECTIONS, connections);
            params.put(ACTIVATION_DATE, pendingCert.getX509Certificate().getNotBefore().toString());
        }
        return params;
    }

    private void sendNotification(String templateFileName, Cert originalCert, Cert pendingCert, String affectedConnNameEntityId, NotificationEventType eventType) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings existingSettings = notificationMgr.getNotificationSettings();
        if (existingSettings != null) {
            boolean isNotificationEnabled = existingSettings.isEnableCertificateExpirationNotification();
            String certEmailTo = existingSettings.getCertificateExpirationTo();
            if (isNotificationEnabled) {
                NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                String notificationPublisher = existingSettings.getNotificationPublisherCertificates();
                Map<String, Object> params = this.getEmailParams(originalCert, pendingCert, affectedConnNameEntityId);
                notificationSupportHelper.publishNotification(notificationPublisher, templateFileName, certEmailTo, params, eventType.toString());
            }
        }
    }

    private String saveConnectionsUsingSigningCert(String certAlias) {
        if (certAlias == null) {
            return null;
        }
        StringBuilder connNameEntityId = new StringBuilder();
        for (ConnectionBase connection : this.connectionManager.getFilteredConnections()) {
            PkCert signingCert;
            if (!connection.isActive() || (signingCert = connection.getSigningPkCert()) == null || !certAlias.equals(signingCert.getAlias())) continue;
            if (connection instanceof IdpConnection) {
                this.connectionManager.saveIdpConnection((IdpConnection)connection);
            } else if (connection instanceof SpConnection) {
                this.connectionManager.saveSpConnection((SpConnection)connection);
            }
            String connEntityId = this.getConnNameEntityIdForEmail(connection.getName(), connection.getEntityId());
            connNameEntityId.append(connEntityId);
        }
        return connNameEntityId.toString();
    }
}

