/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.MacAlgorithm;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.ByteUtil;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;

public class HMAC {
    private Mac returnOfTheMac;

    public HMAC(String password) {
        this(password, 0, null);
    }

    public HMAC(String password, int iterationCount) {
        this(password, iterationCount, null);
    }

    public HMAC(String password, int iterationCount, MacAlgorithm macAlgo) {
        if (StringUtils.isBlank((String)password)) {
            throw new IllegalArgumentException("password cannot be null and must be at least one character");
        }
        if (macAlgo == null) {
            macAlgo = MacAlgorithm.HMACSHA1;
        }
        String algo = macAlgo.toString();
        try {
            this.returnOfTheMac = Mac.getInstance(algo);
            byte[] pwdBytes = password.getBytes("UTF-8");
            for (int i = 0; i < iterationCount; ++i) {
                pwdBytes = HashUtil.hashToBytes((byte[])pwdBytes, (HashAlgorithm)HashAlgorithm.SHA256);
            }
            SecretKeySpec key = new SecretKeySpec(pwdBytes, algo);
            this.returnOfTheMac.init(key);
        }
        catch (UnsupportedEncodingException e) {
            throw this.runtime("UTF-8", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.runtime(algo, e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public String calculateMac(String message) {
        byte[] bytes = this.calculateMacToBytes(message);
        return HexBin.bytesToString((byte[])bytes);
    }

    public byte[] calculateMacToBytes(String message) {
        try {
            byte[] msgBytes = message.getBytes("UTF-8");
            return this.returnOfTheMac.doFinal(msgBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw this.runtime("UTF-8", e);
        }
    }

    public boolean verifyMac(String message, String mac) {
        try {
            byte[] fakeMac = HexBin.encode((byte[])this.calculateMacToBytes(message));
            byte[] realMac = mac.getBytes("UTF-8");
            return ByteUtil.secureEquals(fakeMac, realMac);
        }
        catch (UnsupportedEncodingException e) {
            throw this.runtime("UTF-8", e);
        }
    }

    private RuntimeException runtime(String thing, Exception e) {
        return new RuntimeException("How is " + thing + " not supported?", e);
    }
}

