/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.JCEManagerBase;
import com.pingidentity.crypto.luna.type.LunaManagerType;
import com.pingidentity.crypto.luna.type.impl.LunaManager;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.config.CoreConfig;
import org.sourceid.config.GlobalRegistry;

public class LunaJCEManager
extends JCEManagerBase {
    public static final String LUNA_KEYSTORE_TYPE = "Luna";
    private static final CoreConfig coreConfig = GlobalRegistry.getService(CoreConfig.class);
    private static final Set<String> CERT_STORES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(coreConfig.getTrustKeystoreName(), coreConfig.getTrustHSMKeystoreName(), coreConfig.getDsigKeystoreName(), coreConfig.getSslServerKeystoreName(), coreConfig.getGeneralKeystoreName(), coreConfig.getSslKeystoreName())));

    @Override
    public String getKeystoreType(String keystoreFilename) {
        if (CERT_STORES.contains(keystoreFilename)) {
            return KeyStore.getDefaultType();
        }
        return LUNA_KEYSTORE_TYPE;
    }

    @Override
    public String getKeystoreType() {
        return LUNA_KEYSTORE_TYPE;
    }

    @Override
    protected String getConfigName() {
        return "com.pingidentity.crypto.LunaJCEManager";
    }

    @Override
    public boolean isEnforceFIPSKeySizes() {
        LunaManagerType lunaManager = LunaManager.getInstance();
        if (lunaManager != null) {
            return lunaManager.isFIPSEnabled();
        }
        return false;
    }

    @Override
    public boolean allowLinkAndStoreKeys() {
        return false;
    }
}

