/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.OCSPResponseEntry;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.impl.util.HexBin;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.sourceid.config.ConfigStore;

public class OCSPResponseCache {
    private Log log = LogFactory.getLog(this.getClass());
    private static int NUM_OF_CACHES = 2;
    private ConfigStore config = null;
    private Map[] cache = new HashMap[NUM_OF_CACHES];
    private int curCacheIdx = 0;
    private Date nextRotationTime;

    public OCSPResponseCache(ConfigStore config) {
        this.config = config;
        this.log.info((Object)"Initializing OCSP response cache");
        for (int i = 0; i < NUM_OF_CACHES; ++i) {
            this.cache[i] = new HashMap();
        }
        this.curCacheIdx = 1;
        this.rotateCache();
    }

    private void rotateCache() {
        long cacheLifeTimeMs = 172800000L;
        int configuredCacheHours = this.config.getIntValue("OCSP-response-cache-period", 0);
        if (configuredCacheHours > 0 && configuredCacheHours < 48) {
            cacheLifeTimeMs = configuredCacheHours * 3600 * 1000;
        }
        this.nextRotationTime = new Date(new Date().getTime() + cacheLifeTimeMs);
        this.curCacheIdx = (this.curCacheIdx + 1) % NUM_OF_CACHES;
        this.cache[this.curCacheIdx] = new HashMap();
    }

    public SingleResp get(X509Certificate cert) {
        for (int i = 0; i < NUM_OF_CACHES; ++i) {
            String key = this.getSHAFingerprint(cert);
            OCSPResponseEntry entry = (OCSPResponseEntry)this.cache[i].get(key);
            if (entry == null) continue;
            Date now = new Date();
            if (now.after(entry.getValidUntil())) {
                this.cache[i].remove(key);
                continue;
            }
            return entry.getOcspResponse();
        }
        return null;
    }

    public synchronized void put(X509Certificate cert, SingleResp singleResp) {
        Date now = new Date();
        if (this.nextRotationTime.before(now)) {
            this.rotateCache();
        }
        if (cert != null && singleResp != null) {
            int configuredCacheHours = this.config.getIntValue("OCSP-response-cache-period", 0);
            Date cacheUntil = singleResp.getNextUpdate();
            if (configuredCacheHours != 0) {
                Date timeBasedOnConf = new Date(new Date().getTime() + 3600000L * (long)configuredCacheHours);
                if (cacheUntil == null || timeBasedOnConf.before(cacheUntil)) {
                    cacheUntil = timeBasedOnConf;
                }
            } else if (cacheUntil == null) {
                cacheUntil = new Date(new Date().getTime() + 3600000L);
            }
            OCSPResponseEntry entry = new OCSPResponseEntry(cacheUntil, singleResp);
            String key = this.getSHAFingerprint(cert);
            this.cache[this.curCacheIdx].put(key, entry);
        }
    }

    private String getSHAFingerprint(X509Certificate cert) {
        String fingerprint = null;
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA1");
            byte[] digest = digester.digest(cert.getEncoded());
            fingerprint = HexBin.bytesToString((byte[])digest);
        }
        catch (GeneralSecurityException e) {
            this.log.error((Object)e.getMessage());
            fingerprint = new Date().toString();
        }
        return fingerprint;
    }
}

