/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.PFRevocationChecker;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathChecker;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXParameters;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class PKIXCertPathBuilderWrapper
extends CertPathBuilderSpi {
    private final CertPathBuilder delegate;

    public PKIXCertPathBuilderWrapper() {
        try {
            this.delegate = CertPathBuilder.getInstance("PKIX", SecurityProviderUtil.getSunProviderOrEquivalent());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProcessRuntimeException("Could not retrieve PKIX CertPathBuilder", e);
        }
    }

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        if (params instanceof PKIXParameters) {
            params = PFRevocationChecker.addCheckerToParams((PKIXParameters)params);
        }
        return this.delegate.build(params);
    }

    @Override
    public CertPathChecker engineGetRevocationChecker() {
        return new PFRevocationChecker();
    }
}

