/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.PFRevocationChecker;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathChecker;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.PKIXParameters;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class PKIXCertPathValidatorWrapper
extends CertPathValidatorSpi {
    private final CertPathValidator delegate;

    public PKIXCertPathValidatorWrapper() {
        try {
            this.delegate = CertPathValidator.getInstance("PKIX", SecurityProviderUtil.getSunProviderOrEquivalent());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProcessRuntimeException("Could not retrieve PKIX CertPathValidator", e);
        }
    }

    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (params instanceof PKIXParameters) {
            params = PFRevocationChecker.addCheckerToParams((PKIXParameters)params);
        }
        return this.delegate.validate(certPath, params);
    }

    @Override
    public CertPathChecker engineGetRevocationChecker() {
        return new PFRevocationChecker();
    }
}

