/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.PasswordType;

public class Password {
    private static final Log log = LogFactory.getLog(Password.class);
    public static final String PREFIX_OBF = "OBF";
    public static final String PREFIX_JWE = "JWE";
    public static final String PREFIX_SHA1 = "SHA1";
    public static final String DELIMITER = ":";
    public static final String ENCODING_PREFIX = "OBF:JWE:";
    private String strValue = null;

    public Password(String pwd) {
        this(pwd, PasswordType.CLEARTEXT);
    }

    public Password(String pwd, PasswordType pwdType) {
        if (!this.parseEncodedPassword(pwd)) {
            if (pwdType == PasswordType.CLEARTEXT) {
                this.strValue = pwd;
            } else if (pwdType == PasswordType.OBFUSCATED) {
                this.strValue = Obfuscator.deobfuscate(pwd);
            } else if (pwdType == PasswordType.SHA1) {
                this.strValue = null;
            }
        }
    }

    public String getStrValue() {
        return this.strValue;
    }

    private boolean parseEncodedPassword(String pwd) {
        boolean isEncodedFormat = false;
        if (!StringUtils.isEmpty((String)pwd)) {
            if (SecretReferenceUtil.isSecretReference((String)pwd)) {
                return false;
            }
            String[] tokens = pwd.split(DELIMITER);
            String recalculatedHash = null;
            switch (tokens.length) {
                case 4: {
                    String alg = tokens[1];
                    String prefix = tokens[0] + DELIMITER + tokens[1] + DELIMITER;
                    recalculatedHash = HashUtil.hashToHexString((String)(prefix + tokens[2]), (HashAlgorithm)HashAlgorithm.SHA1);
                    if (!recalculatedHash.equalsIgnoreCase(tokens[3])) break;
                    if (PREFIX_OBF.equals(tokens[0])) {
                        this.strValue = Obfuscator.deobfuscate(tokens[2], alg);
                        isEncodedFormat = true;
                        break;
                    }
                    isEncodedFormat = false;
                    break;
                }
                case 3: {
                    if (PREFIX_OBF.equals(tokens[0])) {
                        if (PREFIX_JWE.equals(tokens[1])) {
                            this.strValue = Obfuscator.deobfuscate(tokens[2]);
                            isEncodedFormat = true;
                            break;
                        }
                        recalculatedHash = HashUtil.hashToHexString((String)(tokens[0] + DELIMITER + tokens[1]), (HashAlgorithm)HashAlgorithm.SHA1);
                        if (!recalculatedHash.equalsIgnoreCase(tokens[2])) break;
                        this.strValue = Obfuscator.deobfuscate(tokens[1]);
                        isEncodedFormat = true;
                        break;
                    }
                    if (!PREFIX_SHA1.equals(tokens[0])) break;
                    this.strValue = null;
                    isEncodedFormat = true;
                    break;
                }
            }
        }
        return isEncodedFormat;
    }

    public static String obfuscateAndEncode(String pwd) {
        return ENCODING_PREFIX + Obfuscator.obfuscate(pwd);
    }

    public static String decodeAndDeobfuscate(String pwd) {
        if (pwd == null || !pwd.startsWith(ENCODING_PREFIX)) {
            return null;
        }
        try {
            return Obfuscator.deobfuscate(pwd.substring(ENCODING_PREFIX.length()));
        }
        catch (Exception e) {
            log.debug((Object)("Error deobfuscating string: " + e));
            return null;
        }
    }

    public static String legacyObfuscateAndEncode(String pwd) {
        String prefix = "OBF:AES:";
        String encryptedValue = Obfuscator.obfuscate(pwd, "AES");
        String verificationCode = HashUtil.hashToHexString((String)(prefix + encryptedValue), (HashAlgorithm)HashAlgorithm.SHA1);
        return prefix + encryptedValue + DELIMITER + verificationCode;
    }

    public static String hashAndEncode(String pwd) {
        String hashed = HashUtil.hashToHexString((String)pwd, (HashAlgorithm)HashAlgorithm.SHA1);
        String verificationCode = HashUtil.hashToHexString((String)("SHA1:" + hashed), (HashAlgorithm)HashAlgorithm.SHA1);
        return "SHA1:" + hashed + DELIMITER + verificationCode;
    }
}

