/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.ConsoleUtils;
import com.pingidentity.crypto.Password;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;

public class PasswordEncoder {
    public static void main(String[] args) throws Exception {
        try {
            ConsoleUtils.doConsoleUtilityInitialization();
        }
        catch (IOException e) {
            System.out.println("Failed to load run.properties: " + e.getMessage());
        }
        String obfuscatedPassword = args.length == 2 ? Password.legacyObfuscateAndEncode(args[1]) : (args.length == 1 && StringUtils.isNotBlank((String)args[0]) ? Password.obfuscateAndEncode(args[0]) : PasswordEncoder.promptAndObfuscate());
        System.out.println("");
        System.out.println(obfuscatedPassword);
        System.out.println();
    }

    private static String promptAndObfuscate() throws IOException {
        InputReader reader = PasswordEncoder.getInputReader();
        String plaintext = "";
        while (StringUtils.isBlank((String)plaintext)) {
            plaintext = reader.readSecret("Enter password to be obfuscated: ");
        }
        return Password.obfuscateAndEncode(plaintext);
    }

    private static InputReader getInputReader() {
        Console console = System.console();
        if (console == null) {
            return prompt -> {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
                System.out.println("\n!WARNING! Secure input is not available. Input will not be hidden.\n");
                System.out.print(prompt);
                return reader.readLine();
            };
        }
        return prompt -> {
            char[] input = console.readPassword(prompt, new Object[0]);
            return new String(input);
        };
    }

    @FunctionalInterface
    private static interface InputReader {
        public String readSecret(String var1) throws IOException;
    }
}

