/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.KeyPairFileFormat;
import com.pingidentity.pingcommons.bcfips.ImportExportException;
import com.pingidentity.pingcommons.bcfips.KeyPair;
import com.pingidentity.pingcommons.bcfips.PemExportUtil;
import com.pingidentity.pingcommons.bcfips.PemImportUtil;
import com.pingidentity.pingcommons.crypto.CertificateUtil;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import com.pingidentity.pingcommons.util.Closer;
import com.pingidentity.sdk.internal.interfaces.PkCertWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PkCert
extends Cert
implements PkCertWrapper {
    public static final int MIN_BCFIPS_PWD_LENGTH = 14;
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ALIAS = "ping";
    private static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    private static final String KEYSTORE_TYPE_BCFKS = "BCFKS";
    private static final String PWD_TOO_SHORT_MSG = "In BCFIPS mode, the password must be at least 14 characters.";
    private final PrivateKey privateKey;
    private transient int hashCode;
    private boolean newlySigned;
    private static final BouncyCastleFipsProvider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();

    public PkCert(PkCert copy) {
        super(copy);
        this.privateKey = copy.getPrivateKey();
    }

    protected PkCert(X509Certificate x509, PrivateKey privateKey) {
        super(x509);
        this.privateKey = privateKey;
    }

    protected PkCert(X509Certificate[] certificates, PrivateKey privateKey) {
        super(certificates);
        this.privateKey = privateKey;
    }

    public PkCert(String id, X509Certificate x509Certificate, PrivateKey privateKey) {
        super(id, x509Certificate);
        this.privateKey = privateKey;
    }

    public PkCert(String id, X509Certificate[] certificates, PrivateKey privateKey) {
        super(id, certificates);
        this.privateKey = privateKey;
    }

    public PkCert(String id, X509Certificate[] certificates, PrivateKey privateKey, boolean newlySigned) {
        super(id, certificates);
        this.privateKey = privateKey;
        this.newlySigned = newlySigned;
    }

    @Deprecated
    public static PkCert create(String cn, String ou, String o, String l, String st, String c, int validDays, String keyAlgo, int keySize) throws GeneralSecurityException, IOException {
        return new Builder().cn(cn).ou(ou).o(o).l(l).st(st).c(c).validDays(validDays).keyAlgo(keyAlgo).keySize(keySize).build();
    }

    public static PkCert importKeyPair(InputStream inputStream, String password) throws GeneralSecurityException, IOException {
        return PkCert.importKeyPair(inputStream, password, true);
    }

    public static PkCert importKeyPair(InputStream inputStream, String password, boolean checkValidity) throws ImportExportException, IOException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        return PkCert.importKeyPair(inputStream, null, password, checkValidity);
    }

    public static PkCert importKeyPair(InputStream inputStream, KeyPairFileFormat keyPairFileFormat, String password, boolean checkValidity) throws IOException, ImportExportException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        PkCert pkCert = PkCert.importPEMKeyPair(bytes, keyPairFileFormat, password, checkValidity);
        if (pkCert != null) {
            return pkCert;
        }
        if (PkCert.isBCFIPSMode()) {
            throw new ImportExportException("Only PEM formatted key pair is supported in BCFIPS mode.");
        }
        return PkCert.importPKCS12(new ByteArrayInputStream(bytes), password, checkValidity);
    }

    private static PkCert importPEMKeyPair(byte[] fileData, KeyPairFileFormat format, String password, boolean checkValidity) throws ImportExportException, CertificateException {
        if (!PkCert.checkPEMFormat(fileData, format)) {
            return null;
        }
        if (PkCert.isBCFIPSMode() && password.length() < 14) {
            throw new ImportExportException(PWD_TOO_SHORT_MSG);
        }
        try {
            KeyPair keyPair = PemImportUtil.getKeyPair((String)password, (byte[])fileData);
            X509Certificate[] certChain = keyPair.getCertificates().toArray(new X509Certificate[0]);
            X509Certificate[] validatedCertChain = PkCert.validateCertificateChain(certChain, checkValidity);
            PrivateKey privateKey = keyPair.getPrivateKey();
            PkCert.validateLeafCertAgainstPrivateKey(privateKey, validatedCertChain, password);
            return new PkCert(validatedCertChain, privateKey);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new ImportExportException("Error occurred importing PEM-encoded key: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static void validateLeafCertAgainstPrivateKey(PrivateKey privateKey, X509Certificate[] certChain, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, ImportExportException {
        char[] passwordCharArray = null;
        if (!StringUtils.isBlank((String)password)) {
            passwordCharArray = password.toCharArray();
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE_BCFKS, (Provider)bouncyCastleFipsProvider);
            keyStore.load(null, passwordCharArray);
            keyStore.setKeyEntry("alias", privateKey, passwordCharArray, certChain);
        }
        catch (CertificateException ex) {
            throw new ImportExportException("Error occurred importing PEM-encoded key: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static X509Certificate[] validateCertificateChain(X509Certificate[] x509Certificates, boolean checkValidity) throws ImportExportException, CertificateNotYetValidException, CertificateExpiredException {
        X509Certificate[] orderedCertChain;
        block6: {
            if (checkValidity) {
                for (X509Certificate cert : x509Certificates) {
                    cert.checkValidity();
                }
            }
            orderedCertChain = CertificateUtil.orderCertChain((X509Certificate[])x509Certificates);
            int trustAnchorIndex = orderedCertChain.length - 1;
            X509Certificate trustAnchorCert = orderedCertChain[trustAnchorIndex];
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>(Arrays.asList(orderedCertChain));
            if (!CertificateHelper.isSelfSigned(trustAnchorCert)) {
                certChain.remove(trustAnchorIndex);
            }
            if (certChain.size() > 0) {
                try {
                    CertificateUtil.validateCertPath(certChain, Collections.singletonList(trustAnchorCert));
                }
                catch (CertPathValidatorException e) {
                    if (e.getCause() != null && e.getCause() instanceof CertificateExpiredException || e.getCause() instanceof CertificateNotYetValidException) break block6;
                    throw new ImportExportException("Error occurred importing PEM-encoded key: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return orderedCertChain;
    }

    private static boolean isBCFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }

    private static boolean checkPEMFormat(byte[] fileData, KeyPairFileFormat format) throws ImportExportException {
        String formatNotMatchErrorMsg = "The format of the key pair does not match the requested format";
        if (!PemImportUtil.isPemFileType((byte[])fileData)) {
            if (KeyPairFileFormat.PEM == format) {
                throw new ImportExportException(formatNotMatchErrorMsg);
            }
            return false;
        }
        if (KeyPairFileFormat.PKCS12 == format) {
            throw new ImportExportException(formatNotMatchErrorMsg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PkCert importPKCS12(InputStream inputStream, String password, boolean checkValidity) throws KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException {
        try {
            PkCert pkCert = null;
            char[] passwordCharArray = null;
            KeyStore pkcs12Store = KeyStore.getInstance(KEYSTORE_TYPE_PKCS12);
            if (!StringUtils.isBlank((String)password)) {
                passwordCharArray = password.toCharArray();
            }
            inputStream.mark(0);
            pkcs12Store.load(inputStream, passwordCharArray);
            Enumeration<String> aliases = pkcs12Store.aliases();
            if (aliases.hasMoreElements()) {
                String tmpAlias = aliases.nextElement();
                PrivateKey tmpPrivateKey = (PrivateKey)pkcs12Store.getKey(tmpAlias, passwordCharArray);
                if (tmpPrivateKey == null) {
                    throw new CertificateException("Invalid PKCS12 file format. Missing private key.");
                }
                Certificate[] tmpCerts = pkcs12Store.getCertificateChain(tmpAlias);
                if (tmpCerts == null) {
                    throw new CertificateException("Invalid PKCS12 file format. Missing certificate(s).");
                }
                X509Certificate[] tmpCertChain = new X509Certificate[tmpCerts.length];
                for (int i = 0; i < tmpCerts.length; ++i) {
                    tmpCertChain[i] = (X509Certificate)tmpCerts[i];
                    if (!checkValidity) continue;
                    tmpCertChain[i].checkValidity();
                }
                pkCert = new PkCert(tmpCertChain, tmpPrivateKey);
            }
            PkCert pkCert2 = pkCert;
            return pkCert2;
        }
        finally {
            Closer.close((Closeable)inputStream);
        }
    }

    public static List<String> getSupportedSubjectAlternativeNameTypes() {
        return MgmtFactory.getCertificateService().getSupportedSubjectAlternativeNameTypes();
    }

    public static boolean isValidSubjectAlternativeNameTypeValuePair(String nameTypeString, String nameValueString) {
        return MgmtFactory.getCertificateService().isValidSubjectAlternativeNameTypeValuePair(nameTypeString, nameValueString);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] exportPKCS12(String password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        KeyStore outKeyStore = KeyStore.getInstance(KEYSTORE_TYPE_PKCS12);
        char[] pwdChars = password.toCharArray();
        outKeyStore.load(null, pwdChars);
        outKeyStore.setKeyEntry(DEFAULT_ALIAS, this.privateKey, pwdChars, this.x509Certificates);
        outKeyStore.store(byteArrayStream, pwdChars);
        return byteArrayStream.toByteArray();
    }

    public byte[] exportPEM(String password) throws ImportExportException {
        return PemExportUtil.getExportablePEM((String)password, (PrivateKey)this.privateKey, Arrays.asList(this.x509Certificates));
    }

    public String exportCSR() throws GeneralSecurityException, IOException {
        CertificateService certGenerator = MgmtFactory.getCertificateService();
        return certGenerator.encodeCSR(this.privateKey, this.getX509Certificate(), this.isStoredOnHSM()).replace("\r\n", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PkCert importCSRReply(InputStream inputStream, Collection<X509Certificate> additionalTrustedCas) throws GeneralSecurityException, IOException {
        CertificateService certGenerator = MgmtFactory.getCertificateService();
        try {
            byte[] origDigest;
            ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>(certGenerator.getJavaTrustedCaCerts());
            if (additionalTrustedCas != null) {
                trustedCerts.addAll(additionalTrustedCas);
            }
            X509Certificate[] decodedReplyCerts = certGenerator.decodeCSRReply(inputStream, trustedCerts);
            X509Certificate signedCert = decodedReplyCerts[0];
            byte[] csrReplyKeyBytes = signedCert.getPublicKey().getEncoded();
            byte[] origKeyBytes = this.getX509Certificate().getPublicKey().getEncoded();
            byte[] csrDigest = HashUtil.hashToBytes((byte[])csrReplyKeyBytes, (HashAlgorithm)HashAlgorithm.SHA1);
            if (!MessageDigest.isEqual(csrDigest, origDigest = HashUtil.hashToBytes((byte[])origKeyBytes, (HashAlgorithm)HashAlgorithm.SHA1))) {
                Object msg = "Public key of CSR reply does not match the public key of this certificate: ";
                msg = (String)msg + new String(Hex.encodeHex((byte[])csrDigest)) + " != " + new String(Hex.encodeHex((byte[])origDigest));
                throw new GeneralSecurityException((String)msg);
            }
            PkCert pkCert = new PkCert(this.id, decodedReplyCerts, this.privateKey, true);
            return pkCert;
        }
        finally {
            Closer.close((Closeable)inputStream);
        }
    }

    public boolean isNewlySigned() {
        return this.newlySigned;
    }

    public void setNewlySigned(boolean signed) {
        this.newlySigned = signed;
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result != 0) {
            return result;
        }
        result = super.hashCode();
        this.hashCode = result = 31 * result + this.privateKey.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PkCert)) {
            return false;
        }
        boolean superEq = super.equals(obj);
        return superEq && this.getPrivateKey().equals(((PkCert)obj).getPrivateKey());
    }

    public static class Builder {
        private String id = null;
        private String cn = null;
        private String ou = null;
        private String o = null;
        private String l = null;
        private String st = null;
        private String c = null;
        private String keyAlgo = null;
        private String sigAlgorithm = null;
        private int keySize = 0;
        private int validDays = 0;
        private Date validFrom = null;
        private Boolean isHSMProvider = null;
        private Map<String, String> subjectAlternativeNameMap = Collections.emptyMap();
        private CertificateGenerator.CertificateType certificateType = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder cn(String cn) {
            this.cn = cn;
            return this;
        }

        public Builder ou(String ou) {
            this.ou = ou;
            return this;
        }

        public Builder o(String o) {
            this.o = o;
            return this;
        }

        public Builder l(String l) {
            this.l = l;
            return this;
        }

        public Builder st(String st) {
            this.st = st;
            return this;
        }

        public Builder c(String c) {
            this.c = c;
            return this;
        }

        public Builder keyAlgo(String keyAlgo) {
            this.keyAlgo = keyAlgo;
            return this;
        }

        public Builder sigAlgorithm(String sigAlgorithm) {
            this.sigAlgorithm = sigAlgorithm;
            return this;
        }

        public Builder keySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public Builder validDays(int validDays) {
            this.validDays = validDays;
            return this;
        }

        public Builder validFrom(Date validFrom) {
            this.validFrom = new Date(validFrom.getTime());
            return this;
        }

        public Builder isHSMProvider(Boolean isHSMProvider) {
            this.isHSMProvider = isHSMProvider;
            return this;
        }

        public Builder subjectAlternativeNameMap(Map<String, String> subjectAlternativeNameMap) {
            this.subjectAlternativeNameMap = subjectAlternativeNameMap;
            return this;
        }

        public Builder certificateType(CertificateGenerator.CertificateType certificateType) {
            this.certificateType = certificateType;
            return this;
        }

        public PkCert build() throws GeneralSecurityException, IOException {
            CertificateService certGenerator = MgmtFactory.getCertificateService();
            X500PrivateCredential x500pc = certGenerator.createSelfSignedCertAndPrivateKey(this.id, this.cn, this.ou, this.o, this.l, this.st, this.c, this.validDays, this.keyAlgo, this.keySize, this.sigAlgorithm, this.validFrom, this.isHSMProvider, this.subjectAlternativeNameMap, this.certificateType);
            PkCert cert = new PkCert(x500pc.getCertificate(), x500pc.getPrivateKey());
            if (PropertyInfo.getHSMMode() == PropertyInfo.HSM_MODE.AWSCLOUDHSM && x500pc.getAlias() != null) {
                cert.setAlias(x500pc.getAlias());
            }
            if (this.isHSMProvider != null) {
                cert.setStoredOnHSM(this.isHSMProvider);
            }
            return cert;
        }
    }
}

