/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.PkCert;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SecurityProviderUtil {
    private static final String BCFIPS_PROVIDER = "BCFIPS";
    private static final String BCJSSE_PROVIDER = "BCJSSE";
    private static final String SUN_X509 = "SunX509";
    private static final String CFG_TRUST_MANAGER_FACTORY_ALGORITHM = "TrustManagerFactoryAlgorithm";
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.crypto.SecurityProviderUtil");

    public static String getSunProviderOrEquivalent() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return BCFIPS_PROVIDER;
        }
        return "SUN";
    }

    public static String getSunRsaSignProviderOrEquivalent() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return BCFIPS_PROVIDER;
        }
        return "SunRsaSign";
    }

    public static String getSunECProviderOrEquivalent() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return BCFIPS_PROVIDER;
        }
        return "SunEC";
    }

    public static String getSunJCEProviderOrEquivalent() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return BCFIPS_PROVIDER;
        }
        return "SunJCE";
    }

    public static String getSunJSSEProviderOrEquivalent() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return BCJSSE_PROVIDER;
        }
        return "SunJSSE";
    }

    public static String getJceksOrEquivalent() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return "BCFKS";
        }
        return "JCEKS";
    }

    public static String getTrustManagerFactoryAlgorithm() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return "PKIX";
        }
        return configStore.getStringValue(CFG_TRUST_MANAGER_FACTORY_ALGORITHM, SUN_X509);
    }

    public static String getKeyManagerFactoryAlgorithm() {
        if (SecurityProviderUtil.isBCFIPSMode()) {
            return "PKIX";
        }
        return SUN_X509;
    }

    public static boolean doLegacyRevocationCheck() {
        return !PropertyInfo.isInstallRevocationCheckerGlobally() || SUN_X509.equals(SecurityProviderUtil.getTrustManagerFactoryAlgorithm());
    }

    public static SecureRandom getSecureRandom() {
        return new SecureRandom();
    }

    public static String getHSMProviderName(Boolean keyStoredOnHSM) {
        if (!PropertyInfo.isHardwareHSM()) {
            return null;
        }
        if (keyStoredOnHSM != null && !keyStoredOnHSM.booleanValue()) {
            return null;
        }
        return MgmtFactory.getCertificateService().getHSMProviderName();
    }

    public static String getHSMProviderName(PrivateKey privateKey) {
        if (!PropertyInfo.isHardwareHSM()) {
            return null;
        }
        PkCert pkCert = SecurityProviderUtil.findPkCertByPrivateKeyReference(privateKey);
        if (pkCert == null) {
            return null;
        }
        return SecurityProviderUtil.getHSMProviderName(pkCert.isStoredOnHSM());
    }

    public static Provider getHSMProvider(PrivateKey privateKey) {
        String hsmProviderName = SecurityProviderUtil.getHSMProviderName(privateKey);
        if (hsmProviderName == null) {
            return null;
        }
        return Security.getProvider(hsmProviderName);
    }

    private static PkCert findPkCertByPrivateKeyReference(PrivateKey privateKey) {
        for (PkCert pkCert : MgmtFactory.getDsigPkCertManager().getPkCerts()) {
            if (pkCert.getPrivateKey() != privateKey) continue;
            return pkCert;
        }
        return null;
    }

    private static boolean isBCFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }
}

