/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import java.util.LinkedHashMap;
import java.util.Map;

public class WsfedJwtSigningAlgorithms {
    private static Map<String, String> alg2Name = new LinkedHashMap<String, String>();
    private static Map<String, String> RSAalg2Name = new LinkedHashMap<String, String>();
    private static Map<String, String> ECalg2Name = new LinkedHashMap<String, String>();

    private WsfedJwtSigningAlgorithms() {
    }

    public static Map<String, String> getAlg2NameMap() {
        return alg2Name;
    }

    public static Map<String, String> getRSAalg2NameMap() {
        return RSAalg2Name;
    }

    public static Map<String, String> getECalg2NameMap() {
        return ECalg2Name;
    }

    public static String algToName(String signingAlgorithm) {
        return alg2Name.get(signingAlgorithm);
    }

    public static String nameToAlg(String algorithm) {
        for (Map.Entry<String, String> entry : alg2Name.entrySet()) {
            if (!entry.getValue().equals(algorithm)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        RSAalg2Name.put("RS256", "RSA SHA256");
        RSAalg2Name.put("RS384", "RSA SHA384");
        RSAalg2Name.put("RS512", "RSA SHA512");
        RSAalg2Name.put("PS256", "RSASSA-PSS SHA256");
        RSAalg2Name.put("PS384", "RSASSA-PSS SHA384");
        RSAalg2Name.put("PS512", "RSASSA-PSS SHA512");
        ECalg2Name.put("ES256", "ECDSA SHA256");
        ECalg2Name.put("ES384", "ECDSA SHA384");
        ECalg2Name.put("ES512", "ECDSA SHA512");
        alg2Name.putAll(RSAalg2Name);
        alg2Name.putAll(ECalg2Name);
    }
}

