/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.X509ClientCertExtractor;
import com.pingidentity.crypto.impl.ApacheModSslX509ClientCertExtractor;
import com.pingidentity.crypto.impl.NginxX509ClientCertExtractor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.LocalSettings;

public final class X509ClientCertExtractorFactory {
    private static final Log log = LogFactory.getLog(X509ClientCertExtractorFactory.class);

    private X509ClientCertExtractorFactory() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated");
    }

    public static X509ClientCertExtractor newInstance(String clientCertEncodingFormat, String clientCertHeaderName, String clientCertChainHeaderName) {
        LocalSettings.ClientCertEncodingFormat encodingFormat = LocalSettings.ClientCertEncodingFormat.valueOf(clientCertEncodingFormat);
        return X509ClientCertExtractorFactory.newInstance(encodingFormat, clientCertHeaderName, clientCertChainHeaderName);
    }

    public static X509ClientCertExtractor newInstance(LocalSettings.ClientCertEncodingFormat clientCertEncodingFormat, String clientCertHeaderName, String clientCertChainHeaderName) {
        switch (clientCertEncodingFormat) {
            case APACHE_MOD_SSL: {
                return X509ClientCertExtractorFactory.createApacheModSslX509ClientCertExtractor(clientCertHeaderName, clientCertChainHeaderName);
            }
            case NGINX: {
                return X509ClientCertExtractorFactory.createNginxX509ClientCertExtractor(clientCertHeaderName);
            }
        }
        throw new IllegalArgumentException("Unsupported client cert encoding format: " + clientCertEncodingFormat);
    }

    public static X509ClientCertExtractor createNginxX509ClientCertExtractor(String clientCertHeaderName) {
        if (StringUtils.isBlank((String)clientCertHeaderName)) {
            log.warn((Object)"clientCertHeaderName is blank, this will cause the NginxX509ClientCertExtractor to not extract the client cert");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating NginxX509ClientCertExtractor with clientCertHeaderName: " + clientCertHeaderName));
        }
        return new NginxX509ClientCertExtractor(clientCertHeaderName);
    }

    public static X509ClientCertExtractor createApacheModSslX509ClientCertExtractor(String clientCertHeaderName, String clientCertChainHeaderName) {
        if (StringUtils.isBlank((String)clientCertHeaderName) && StringUtils.isBlank((String)clientCertChainHeaderName)) {
            log.warn((Object)"clientCertHeaderName and createX509ClientCertExtractor are both blank, this will cause the ModSslX509ClientCertExtractor to not extract the client cert");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating ModSslX509ClientCertExtractor with clientCertHeaderName: " + clientCertHeaderName + " and clientCertChainHeaderName: " + clientCertChainHeaderName));
        }
        return new ApacheModSslX509ClientCertExtractor(clientCertHeaderName, clientCertChainHeaderName);
    }
}

