/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.impl;

import com.pingidentity.crypto.X509CertificateUtils;
import com.pingidentity.crypto.X509ClientCertExtractor;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NginxX509ClientCertExtractor
implements X509ClientCertExtractor {
    private static final Log log = LogFactory.getLog(NginxX509ClientCertExtractor.class);
    private final String clientCertHeaderName;

    public NginxX509ClientCertExtractor(String clientCertHeaderName) {
        this.clientCertHeaderName = clientCertHeaderName;
    }

    @Override
    public X509Certificate[] extractClientCert(HttpServletRequest request) {
        String clientCertHeaderValue = request.getHeader(this.clientCertHeaderName);
        if (StringUtils.isBlank((String)clientCertHeaderValue)) {
            log.warn((Object)("Client cert header value not found for header: " + this.clientCertHeaderName));
            return null;
        }
        String decodedClientCertHeaderValue = URLDecoder.decode(clientCertHeaderValue, StandardCharsets.UTF_8);
        try {
            X509Certificate certificate = X509CertificateUtils.toCertificate(decodedClientCertHeaderValue);
            return new X509Certificate[]{certificate};
        }
        catch (CertificateException e) {
            log.warn((Object)("There is an error when parsing the client cert for request header: " + clientCertHeaderValue), (Throwable)e);
            return null;
        }
    }
}

