/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwkKeyPairBuilder;
import com.pingidentity.crypto.jwk.JwksContent;
import com.pingidentity.crypto.jwk.KeyMaker;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.LinkedList;
import org.jose4j.keys.EllipticCurves;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.domain.JWKSEndpointDynamicKeysSetting;
import org.sourceid.oauth20.domain.JWKSEndpointManager;

class DynamicKeyMaker
implements KeyMaker {
    private static final Logger log = LoggerFactory.getLogger(DynamicKeyMaker.class);
    private final JWKSEndpointManager jwksEndpointManager;
    private final CertificateService certService;
    private final int rsaKeySize;
    private final int certValidityInDays;
    private final int cnSuffixLength;

    DynamicKeyMaker(JWKSEndpointManager jwksEndpointManager, CertificateService certService, int rsaKeySize, int certValidityInDays, int cnSuffixLength) {
        this.jwksEndpointManager = jwksEndpointManager;
        this.rsaKeySize = rsaKeySize;
        this.certService = certService;
        this.certValidityInDays = certValidityInDays;
        this.cnSuffixLength = cnSuffixLength;
    }

    @Override
    public JwksContent makeKeys() {
        LinkedList<JwkKeyPair> keys = new LinkedList<JwkKeyPair>();
        LinkedList<JwkKeyPair> encryptionKeys = new LinkedList<JwkKeyPair>();
        JWKSEndpointDynamicKeysSetting dynamicKeysSetting = this.jwksEndpointManager.getSetting().getDynamicKeys();
        boolean generateCertificate = dynamicKeysSetting != null && dynamicKeysSetting.isPublishCertificates();
        try {
            KeyPair keyPair = this.certService.generateLocalRsaKeyPair(this.rsaKeySize);
            JwkKeyPairBuilder jwkKeyPairBuilder = new JwkKeyPairBuilder(keyPair.getPublic(), keyPair.getPrivate());
            if (generateCertificate) {
                String cn = String.format("%s-%s-%s", "RSA", "sig", IDGenerator.rndAlphaNumeric(this.cnSuffixLength)).toLowerCase();
                X509Certificate selfSignedCert = this.generateCertificate(dynamicKeysSetting, keyPair, cn);
                jwkKeyPairBuilder.setX509Certificates(new X509Certificate[]{selfSignedCert});
            }
            keys.add(jwkKeyPairBuilder.build());
            KeyPair encryptionKeyPair = this.certService.generateLocalRsaKeyPair(this.rsaKeySize);
            JwkKeyPairBuilder jwkEncryptionKeyPairBuilder = new JwkKeyPairBuilder(encryptionKeyPair.getPublic(), encryptionKeyPair.getPrivate());
            if (generateCertificate) {
                String cn = String.format("%s-%s-%s", "RSA", "enc", IDGenerator.rndAlphaNumeric(this.cnSuffixLength)).toLowerCase();
                X509Certificate selfSignedCert = this.generateCertificate(dynamicKeysSetting, keyPair, cn);
                jwkEncryptionKeyPairBuilder.setX509Certificates(new X509Certificate[]{selfSignedCert});
            }
            encryptionKeys.add(jwkEncryptionKeyPairBuilder.build());
        }
        catch (Exception e) {
            log.error("Unable to create new {} bit RSA key pair (for JWK).", (Object)this.rsaKeySize, (Object)e);
        }
        if (this.certService.isLocalEcKeyPairGenerationAvailable()) {
            ECParameterSpec[] ecs;
            for (ECParameterSpec spec : ecs = new ECParameterSpec[]{EllipticCurves.P256, EllipticCurves.P384, EllipticCurves.P521}) {
                try {
                    KeyPair keyPair = this.certService.generateLocalEcKeyPair(spec);
                    JwkKeyPairBuilder jwkKeyPairBuilder = new JwkKeyPairBuilder(keyPair.getPublic(), keyPair.getPrivate());
                    if (generateCertificate) {
                        String ecName = EllipticCurves.getName((EllipticCurve)spec.getCurve());
                        String cn = String.format("EC-%s-%s-%s", ecName, "sig", IDGenerator.rndAlphaNumeric(this.cnSuffixLength)).toLowerCase();
                        X509Certificate selfSignedCert = this.generateCertificate(dynamicKeysSetting, keyPair, cn);
                        jwkKeyPairBuilder.setX509Certificates(new X509Certificate[]{selfSignedCert});
                    }
                    keys.add(jwkKeyPairBuilder.build());
                    KeyPair encryptionKeyPair = this.certService.generateLocalEcKeyPair(spec);
                    JwkKeyPairBuilder jwkEncryptionKeyPairBuilder = new JwkKeyPairBuilder(encryptionKeyPair.getPublic(), encryptionKeyPair.getPrivate());
                    if (generateCertificate) {
                        String ecName = EllipticCurves.getName((EllipticCurve)spec.getCurve());
                        String cn = String.format("EC-%s-%s-%s", ecName, "enc", IDGenerator.rndAlphaNumeric(this.cnSuffixLength)).toLowerCase();
                        X509Certificate selfSignedCert = this.generateCertificate(dynamicKeysSetting, keyPair, cn);
                        jwkEncryptionKeyPairBuilder.setX509Certificates(new X509Certificate[]{selfSignedCert});
                    }
                    encryptionKeys.add(jwkEncryptionKeyPairBuilder.build());
                }
                catch (Exception e) {
                    log.error("Unable to create new key pair (for JWK) with ECParameterSpec: {}", (Object)spec, (Object)e);
                }
            }
        } else {
            log.warn("Elliptic Curve Key support unavailable from the Java runtime. Not generating EC keys for the JWKS endpoint.");
        }
        return new JwksContent(keys, encryptionKeys, false);
    }

    private X509Certificate generateCertificate(JWKSEndpointDynamicKeysSetting dynamicKeysSetting, KeyPair keyPair, String cn) throws GeneralSecurityException, IOException {
        return this.certService.createSelfSignedCert(cn, dynamicKeysSetting.getCertOrgUnitName(), dynamicKeysSetting.getCertOrgName(), dynamicKeysSetting.getCertCity(), dynamicKeysSetting.getCertState(), dynamicKeysSetting.getCertCountry(), this.certValidityInDays, keyPair);
    }
}

