/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.JwkKeyRep;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class JwkKeyPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient PrivateKey privateKey;
    private transient PublicKey publicKey;
    private JwkLifecycleState state;
    private X509Certificate[] x509Certificates;
    private String pkCertID;
    private String keyId;
    private String alg;

    JwkKeyPair(PublicKey publicKey, PrivateKey privateKey, JwkLifecycleState state, X509Certificate[] x509Certificates, String pkCertID, String keyId, String alg) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        JwkLifecycleState jwkLifecycleState = this.state = state == null ? JwkLifecycleState.CREATED : state;
        if (x509Certificates != null) {
            this.x509Certificates = Arrays.copyOf(x509Certificates, x509Certificates.length);
        }
        this.pkCertID = pkCertID;
        this.keyId = keyId;
        this.alg = alg;
    }

    public X509Certificate[] getX509Certificates() {
        if (this.x509Certificates != null) {
            return Arrays.copyOf(this.x509Certificates, this.x509Certificates.length);
        }
        return null;
    }

    public String getPkCertID() {
        return this.pkCertID;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public JwkLifecycleState getState() {
        return this.state;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAlg() {
        return this.alg;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        JwkKeyRep privateKeyRep = new JwkKeyRep(KeyRep.Type.PRIVATE, this.privateKey);
        stream.writeObject(privateKeyRep);
        JwkKeyRep publicKeyRep = new JwkKeyRep(KeyRep.Type.PUBLIC, this.publicKey);
        stream.writeObject(publicKeyRep);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.privateKey = (PrivateKey)stream.readObject();
        this.publicKey = (PublicKey)stream.readObject();
    }
}

