/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class JwkKeyPairBuilder {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private JwkLifecycleState state = JwkLifecycleState.CREATED;
    private X509Certificate[] x509Certificates;
    private String pkCertID;
    private String keyId;
    private String alg;

    public JwkKeyPairBuilder(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public JwkKeyPairBuilder setState(JwkLifecycleState state) {
        this.state = state;
        return this;
    }

    public JwkKeyPairBuilder setX509Certificates(X509Certificate[] x509Certificates) {
        if (x509Certificates != null) {
            this.x509Certificates = Arrays.copyOf(x509Certificates, x509Certificates.length);
        }
        return this;
    }

    public JwkKeyPairBuilder setPkCertID(String pkCertID) {
        this.pkCertID = pkCertID;
        return this;
    }

    public JwkKeyPairBuilder setKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public JwkKeyPairBuilder setAlg(String alg) {
        this.alg = alg;
        return this;
    }

    public JwkKeyPair build() {
        return new JwkKeyPair(this.publicKey, this.privateKey, this.state, this.x509Certificates, this.pkCertID, this.keyId, this.alg);
    }
}

