/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwkWrapper;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public final class JwkUtils {
    private static final Logger log = LoggerFactory.getLogger(JwkUtils.class);
    private static final ConfigStore CONFIG = ConfigStoreFarm.getConfig("jwks-endpoint-configuration");
    private static final boolean PUBLISH_X5T = CONFIG.getBooleanValue("publish-x5t", true);

    private JwkUtils() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static String getThumbprint(JsonWebKey jwk) {
        if (!(jwk.getKey() instanceof PublicKey)) {
            throw new RuntimeException("JWK does not contain public key");
        }
        PublicKey publicKey = (PublicKey)jwk.getKey();
        byte[] bytes = publicKey.getEncoded();
        if (bytes == null) {
            throw new RuntimeException("JWK public key does not support getEncoded()");
        }
        return jwk.calculateBase64urlEncodedThumbprint("SHA1");
    }

    public static JsonWebKey createJsonWebKey(PublicKey publicKey, X509Certificate[] x509Certificates, String use, String keyId) throws JoseException {
        JsonWebKey jwk = JsonWebKey.Factory.newJwk((Key)publicKey);
        if (jwk instanceof PublicJsonWebKey && x509Certificates != null) {
            PublicJsonWebKey pJwk = (PublicJsonWebKey)jwk;
            pJwk.setCertificateChain(x509Certificates);
            if (PUBLISH_X5T) {
                pJwk.setX509CertificateSha1Thumbprint(pJwk.getX509CertificateSha1Thumbprint(true));
            }
        }
        jwk.setUse(use);
        String id = keyId;
        if (StringUtils.isBlank((String)id)) {
            id = JwkUtils.getThumbprint(jwk);
        } else if (id.endsWith("RS256")) {
            jwk.setAlgorithm("RS256");
        }
        if ("sig".equals(use) && "EC".equals(jwk.getKeyType()) && jwk instanceof EllipticCurveJsonWebKey) {
            EllipticCurveJsonWebKey ecJwk = (EllipticCurveJsonWebKey)jwk;
            String signatureAlgName = SignatureAlgorithms.getInstance().getEcSignatureAlgorithmName(ecJwk.getCurveName());
            jwk.setAlgorithm(signatureAlgName);
        }
        jwk.setKeyId(id);
        return jwk;
    }

    private static JsonWebKey createJsonWebKey(PublicKey publicKey, X509Certificate[] x509Certificates, String use, String keyId, String alg) throws JoseException {
        JsonWebKey jwk = JwkUtils.createJsonWebKey(publicKey, x509Certificates, use, keyId);
        if (StringUtils.isNotEmpty((String)alg)) {
            jwk.setAlgorithm(alg);
        }
        return jwk;
    }

    public static Optional<JwkWrapper> createJwkWrapper(JwkKeyPair keyPair, String use) {
        try {
            JsonWebKey jwk = JwkUtils.createJsonWebKey(keyPair.getPublic(), keyPair.getX509Certificates(), use, keyPair.getKeyId(), keyPair.getAlg());
            JwkWrapper jwkWrapper = JwkUtils.createJwkWrapper(jwk, keyPair);
            return Optional.of(jwkWrapper);
        }
        catch (JoseException e) {
            log.error("Unable to create JSON Web Key for {}", (Object)keyPair.getPublic(), (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<JwkWrapper> createJwkWrapperForRS256SignatureAlgParam(JwkKeyPair keyPair, String use) {
        if ("sig".equals(use) && "RSA".equals(keyPair.getPrivate().getAlgorithm()) && keyPair.getAlg() == null) {
            try {
                JsonWebKey jwkForRS256 = JwkUtils.createJsonWebKey(keyPair.getPublic(), keyPair.getX509Certificates(), use, keyPair.getKeyId(), keyPair.getAlg());
                jwkForRS256.setKeyId(jwkForRS256.getKeyId() + "_RS256");
                jwkForRS256.setAlgorithm("RS256");
                JwkWrapper keyForRS256 = JwkUtils.createJwkWrapper(jwkForRS256, keyPair);
                log.info("Created new JSON Web Key with key id: {}", (Object)jwkForRS256.getKeyId());
                return Optional.of(keyForRS256);
            }
            catch (JoseException e) {
                log.error("Unable to create JSON Web Key for {}", (Object)keyPair.getPublic(), (Object)e);
            }
        }
        return Optional.empty();
    }

    private static JwkWrapper createJwkWrapper(JsonWebKey jwk, JwkKeyPair keyPair) {
        JwkWrapper jwkWrapper = new JwkWrapper(jwk, keyPair.getPrivate(), keyPair.getPkCertID());
        jwkWrapper.setLifecycleState(keyPair.getState());
        return jwkWrapper;
    }
}

