/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.pingidentity.crypto.jwk.JwkKeyRep;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import com.pingidentity.crypto.jwk.JwkUtils;
import com.pingidentity.sdk.internal.interfaces.SdkJwkWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;

public class JwkWrapper
implements Serializable,
Comparable<JwkWrapper>,
SdkJwkWrapper {
    private static final long serialVersionUID = 1L;
    private transient JsonWebKey jwk;
    private transient PrivateKey privateKey;
    private String pkCertID;
    private JwkLifecycleState lifecycleState = JwkLifecycleState.CREATED;

    public JwkWrapper(JsonWebKey jwk, PrivateKey privateKey, String pkCertID) {
        this.jwk = jwk;
        this.privateKey = privateKey;
        this.pkCertID = pkCertID;
    }

    public String getKeyId() {
        return this.jwk.getKeyId();
    }

    public String getUse() {
        return this.jwk.getUse();
    }

    public JsonWebKey getJwk() {
        return this.jwk;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public JwkLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getPkCertID() {
        return this.pkCertID;
    }

    public void setLifecycleState(JwkLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public int compareTo(JwkWrapper w) {
        return ComparisonChain.start().compare((Comparable)((Object)this.lifecycleState), (Comparable)((Object)w.getLifecycleState())).compare((Object)this.getKeyId(), (Object)w.getKeyId(), (Comparator)Ordering.natural().nullsFirst()).result();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        PublicJsonWebKey publicJwk;
        stream.defaultWriteObject();
        JwkKeyRep privateKeyRep = new JwkKeyRep(KeyRep.Type.PRIVATE, this.privateKey);
        stream.writeObject(privateKeyRep);
        JwkKeyRep jwkPublicKeyRep = new JwkKeyRep(KeyRep.Type.PUBLIC, this.jwk.getKey());
        stream.writeObject(jwkPublicKeyRep);
        X509Certificate[] x509Certificates = null;
        if (this.jwk instanceof PublicJsonWebKey && (publicJwk = (PublicJsonWebKey)this.jwk).getCertificateChain() != null) {
            List x509CertificatesList = publicJwk.getCertificateChain();
            x509Certificates = x509CertificatesList.toArray(new X509Certificate[0]);
        }
        stream.writeObject(x509Certificates);
        stream.writeObject(this.jwk.getUse());
        stream.writeObject(this.jwk.getKeyId());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.privateKey = (PrivateKey)stream.readObject();
        PublicKey jwkPublicKey = (PublicKey)stream.readObject();
        X509Certificate[] x509Certificates = (X509Certificate[])stream.readObject();
        String use = (String)stream.readObject();
        String keyId = (String)stream.readObject();
        try {
            this.jwk = JwkUtils.createJsonWebKey(jwkPublicKey, x509Certificates, use, keyId);
        }
        catch (JoseException e) {
            throw new IOException(e);
        }
    }
}

