/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.IssuerSigningKeys;
import java.util.Map;
import java.util.Optional;

public class JwksAdditionalKeysContent {
    private final Map<String, String> issuerToKeySetIds;
    private final Map<String, IssuerSigningKeys> keySetIdsToSigningKeys;

    public JwksAdditionalKeysContent(Map<String, String> issuerToKeySetIds, Map<String, IssuerSigningKeys> keySetIdsToSigningKeys) {
        this.issuerToKeySetIds = issuerToKeySetIds;
        this.keySetIdsToSigningKeys = keySetIdsToSigningKeys;
    }

    public Map<String, String> getIssuerToKeySetIds() {
        return this.issuerToKeySetIds;
    }

    public Map<String, IssuerSigningKeys> getKeySetIdsToSigningKeys() {
        return this.keySetIdsToSigningKeys;
    }

    public Optional<IssuerSigningKeys> getKeySetByIssuer(String issuer) {
        Optional<IssuerSigningKeys> jwksForIssuer = Optional.empty();
        if (this.issuerToKeySetIds.get(issuer) != null) {
            String keySetId = this.issuerToKeySetIds.get(issuer);
            jwksForIssuer = Optional.of(this.keySetIdsToSigningKeys.get(keySetId));
        }
        return jwksForIssuer;
    }
}

