/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwksAdditionalKeysContent;
import com.pingidentity.crypto.jwk.JwksContent;
import com.pingidentity.crypto.jwk.KeyMaker;
import java.util.List;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.services.JWKSService;

class StaticKeyMaker
implements KeyMaker {
    private final JWKSEndpointManager jwksEndpointMgr;
    private final JWKSService jwksService;

    StaticKeyMaker(JWKSEndpointManager jwksEndpointMgr, JWKSService jwksService) {
        this.jwksEndpointMgr = jwksEndpointMgr;
        this.jwksService = jwksService;
    }

    @Override
    public JwksContent makeKeys() {
        JWKSEndpointSetting setting = this.jwksEndpointMgr.getSetting();
        List<JwkKeyPair> keys = this.jwksService.getStaticSigningKeys();
        List<JwkKeyPair> encryptionKeys = this.jwksService.getStaticDecryptionKeys();
        JwksAdditionalKeysContent additionalKeysContent = this.jwksService.getStaticAdditionalKeysContent().orElse(null);
        return new JwksContent(keys, encryptionKeys, true, additionalKeysContent, setting);
    }
}

