/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jws;

import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.crypto.jwk.JwkWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jca.ProviderContext;
import org.jose4j.jws.JsonWebSignature;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class JwsSignatureUtil {
    private static final Log log = LogFactory.getLog(JwsSignatureUtil.class);

    public static void applyProviderOverrideContextIfNeeded(JsonWebSignature jws, JwkWrapper wrapper) {
        String currentPkCertID = wrapper.getPkCertID();
        if (currentPkCertID == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No PK cert is associated with the JWS being created, skipping override checks, this is the expected behavior for in-memory keys");
            }
            return;
        }
        PkCert signingPkCert = MgmtFactory.getDsigPkCertManager().getPkCert(wrapper.getPkCertID());
        JwsSignatureUtil.applyProviderOverrideContextIfNeeded(jws, signingPkCert);
    }

    public static void applyProviderOverrideContextIfNeeded(JsonWebSignature jws, PkCert pkCert) {
        String jwsAlgo;
        if (pkCert == null) {
            return;
        }
        ProviderContext providerContext = new ProviderContext();
        String hsmProviderName = SecurityProviderUtil.getHSMProviderName(pkCert.isStoredOnHSM());
        if (hsmProviderName != null) {
            providerContext.getSuppliedKeyProviderContext().setSignatureProvider(hsmProviderName);
        }
        if ((jwsAlgo = jws.getAlgorithmHeaderValue()) != null && JwsSignatureUtil.isRSAProbabilisticSignatureScheme(jwsAlgo) && MgmtFactory.getJCEManager().isUseLegacyRsaSsaPssAlgorithmNames(pkCert)) {
            String legacyName = JwsSignatureUtil.getLegacyNameForRSAPSSAlgoIdentifier(jwsAlgo);
            ProviderContext.SignatureAlgorithmOverride sao = new ProviderContext.SignatureAlgorithmOverride(legacyName, null);
            providerContext.getSuppliedKeyProviderContext().setSignatureAlgorithmOverride(sao);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Overriding default " + jwsAlgo + " name for signature, using " + legacyName));
            }
        }
        jws.setProviderContext(providerContext);
    }

    private static boolean isRSAProbabilisticSignatureScheme(String jwsAlgo) {
        return "PS256".equals(jwsAlgo) || "PS384".equals(jwsAlgo) || "PS512".equals(jwsAlgo);
    }

    private static String getLegacyNameForRSAPSSAlgoIdentifier(String identifier) {
        switch (identifier) {
            case "PS256": {
                return "SHA256withRSAandMGF1";
            }
            case "PS384": {
                return "SHA384withRSAandMGF1";
            }
            case "PS512": {
                return "SHA512withRSAandMGF1";
            }
        }
        log.debug((Object)("No legacy name for identifier: " + identifier));
        return identifier;
    }
}

