/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.x2006.x01.dependencyErrors.DependencyErrorType;
import com.pingidentity.x2006.x01.dependencyErrors.DependencyErrors;
import com.pingidentity.x2006.x01.dependencyErrors.DependencyErrorsDocument;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;

public class DependencyErrorManagerImpl
extends ConfigManagerBase
implements DependencyErrorManager,
AutoReloadable {
    private static final Log log = LogFactory.getLog(DependencyErrorManagerImpl.class);
    private static final String DEPENDENCY_ERROR_XML_FILE_NAME = "pingfederate-dependency-errors.xml";
    private Collection<DependencyError> dependencyErrors = this.loadErrors();

    private DependencyErrorsDocument getDoc() {
        String dataDir = this.sysDirInfo.getDataDirectory();
        return (DependencyErrorsDocument)this.xmlLoader.load(dataDir, DEPENDENCY_ERROR_XML_FILE_NAME);
    }

    private synchronized Collection<DependencyError> loadErrors() {
        DependencyErrorType[] errors;
        if (!this.configFileExists()) {
            return Collections.emptyList();
        }
        LinkedList<DependencyError> dependencyErrors = new LinkedList<DependencyError>();
        DependencyErrorsDocument doc = this.getDoc();
        for (DependencyErrorType error : errors = doc.getDependencyErrors().getDependencyErrorTypeArray()) {
            DependencyType dependencyType = DependencyType.valueOf(error.getCausedByType());
            DependencyError dependencyError = new DependencyError(error.getAffectedInstanceId(), dependencyType, error.getCausedByInstanceId(), this.getAffectedItemType(error.getAffectedInstanceType()));
            dependencyErrors.add(dependencyError);
        }
        return dependencyErrors;
    }

    private boolean configFileExists() {
        File configFile = new File(this.sysDirInfo.getDataDirectory(), DEPENDENCY_ERROR_XML_FILE_NAME);
        return configFile.exists();
    }

    @Override
    public synchronized Collection<DependencyError> getErrors() {
        return Collections.unmodifiableCollection(this.dependencyErrors);
    }

    @Override
    public synchronized DependencyError getErrorByAffectedItem(String affectedInstanceID, AffectedItemType affectedItemType) {
        for (DependencyError error : this.dependencyErrors) {
            if (!error.getAffectedInstanceId().equals(affectedInstanceID) || !affectedItemType.equals((Object)error.getAffectedInstanceType())) continue;
            return error;
        }
        return null;
    }

    @Override
    public synchronized List<DependencyError> getErrorsByAffectedItem(String affectedInstanceID, AffectedItemType affectedItemType) {
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        for (DependencyError error : this.dependencyErrors) {
            if (!error.getAffectedInstanceId().equals(affectedInstanceID) || !affectedItemType.equals((Object)error.getAffectedInstanceType())) continue;
            errors.add(error);
        }
        return errors;
    }

    @Override
    public synchronized void setErrors(Collection<DependencyError> errors) {
        this.dependencyErrors.clear();
        this.dependencyErrors.addAll(errors);
        this.writeErrors();
    }

    @Override
    public synchronized void saveError(DependencyError dependencyError) {
        if (!this.dependencyErrors.contains(dependencyError)) {
            this.dependencyErrors.add(dependencyError);
            this.writeErrors();
        }
    }

    private synchronized void writeErrors() {
        DependencyErrorsDocument doc = DependencyErrorsDocument.Factory.newInstance();
        DependencyErrors depError = doc.addNewDependencyErrors();
        for (DependencyError dependencyError : this.dependencyErrors) {
            DependencyErrorType error = depError.addNewDependencyErrorType();
            error.setCausedByType(dependencyError.getCausedByType().toString());
            error.setAffectedInstanceId(dependencyError.getAffectedInstanceId());
            error.setCausedByInstanceId(dependencyError.getCausedByInstanceId());
            error.setAffectedInstanceType(dependencyError.getAffectedInstanceType().name());
        }
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), DEPENDENCY_ERROR_XML_FILE_NAME, (XmlObject)doc);
    }

    @Override
    public synchronized boolean errorsExist() {
        return !this.dependencyErrors.isEmpty();
    }

    @Override
    public synchronized void remove(String affectedItemId, AffectedItemType affectedItemType) {
        this.dependencyErrors.removeIf(error -> error.getAffectedInstanceId().equals(affectedItemId) && error.getAffectedInstanceType().equals((Object)affectedItemType));
        this.writeErrors();
    }

    @Override
    public synchronized void deleteError(DependencyType dependencyType, String causedByInstanceId, String affectedInstanceId) {
        this.dependencyErrors.removeIf(error -> error.getCausedByInstanceId().equals(causedByInstanceId) && error.getAffectedInstanceId().equals(affectedInstanceId) && error.getCausedByType().equals((Object)dependencyType));
        this.writeErrors();
    }

    private AffectedItemType getAffectedItemType(String affectedItemStr) {
        try {
            return AffectedItemType.valueOf(affectedItemStr);
        }
        catch (IllegalArgumentException e) {
            for (AffectedItemType itemType : AffectedItemType.values()) {
                if (!itemType.getFriendlyName().equals(affectedItemStr)) continue;
                return itemType;
            }
            throw e;
        }
    }
}

