/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.email;

import com.pingidentity.email.SmtpNotificationPluginHelper;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.notification.NotificationPublisherPlugin;
import com.pingidentity.sdk.notification.NotificationSenderPluginDescriptor;
import com.pingidentity.sdk.notification.PublishResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class SmtpNotificationPlugin
implements NotificationPublisherPlugin {
    public static final String TYPE = "SMTP Notification Publisher";
    private static final Log LOG = LogFactory.getLog(SmtpNotificationPlugin.class);
    private final NotificationSenderPluginDescriptor pluginDescriptor;
    private Configuration configuration;

    public SmtpNotificationPlugin() {
        GuiConfigDescriptor guiConfig = SmtpNotificationPluginHelper.createGuiConfigDescriptor();
        this.pluginDescriptor = new NotificationSenderPluginDescriptor(TYPE, (Plugin)this, guiConfig, VersionUtil.getVersion());
        this.pluginDescriptor.setSupportsExtendedContract(false);
        this.pluginDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        this.pluginDescriptor.setSupportsObjectData(true);
    }

    public PublishResult publishNotification(String eventType, Map<String, String> data, Map<String, String> configuration) {
        HashMap<String, Object> stringData = new HashMap<String, Object>();
        for (Map.Entry<String, String> param : data.entrySet()) {
            stringData.put(param.getKey(), param.getValue());
        }
        return this.publishNotificationWithObjectData(eventType, stringData, configuration);
    }

    public PublishResult publishNotificationWithObjectData(String eventType, Map<String, Object> data, Map<String, String> configuration) {
        String template = configuration.get("com.pingidentity.notification.config.template.name");
        String to = configuration.get("com.pingidentity.notification.config.destination.address");
        String locale = configuration.get("com.pingidentity.notification.config.locale");
        if (StringUtils.isBlank((String)template)) {
            throw new ProcessRuntimeException("Template Name is required.");
        }
        if (StringUtils.isBlank((String)to)) {
            throw new ProcessRuntimeException("Destination Address is required.");
        }
        PublishResult sendResult = new PublishResult();
        if (SmtpNotificationPluginHelper.sendEmail(template, data, this.configuration, locale, to)) {
            LOG.debug((Object)"SMTP notification sent successfully");
            sendResult.setNotificationStatus(PublishResult.NOTIFICATION_STATUS.SUCCESS);
        } else {
            LOG.error((Object)"Failed to send SMTP notification");
            sendResult.setNotificationStatus(PublishResult.NOTIFICATION_STATUS.FAILURE);
        }
        return sendResult;
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public boolean acceptsUserAttributes() {
        return true;
    }
}

