/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.email;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.email.EmailUtilSystemSettingsImpl;
import com.pingidentity.pf.email.EmailServerSettings;
import com.pingidentity.pf.email.util.EmailUtil;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.EmailValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.HostnameValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.StringLengthValidator;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class SmtpNotificationPluginHelper {
    public static final String EMAIL_CUSTOMER_COMPANY_LOGO = "company-logo.png";
    private static final String DESCRIPTION = "Configure the server to communicate with your organization's SMTP mail server.";
    private static final String FROM_TEXT_FIELD_NAME = "From Address";
    private static final String FROM_TEXT_FIELD_DESC = "The email address that appears in the 'From' header line in email messages generated by PingFederate. The address must be in valid format but need not be set up on your system.";
    private static final String SENDER_NAME_FIELD_NAME = "Sender Name";
    private static final String SENDER_NAME_FIELD_DESC = "The sender name that will be displayed in email messages generated by PingFederate.";
    private static final String EMAIL_SERVER_TEXT_FIELD_NAME = "Email Server";
    private static final String EMAIL_SERVER_TEXT_FIELD_DESC = "The IP address or hostname of your email server.";
    private static final String SMTP_PORT_TEXT_FIELD_NAME = "SMTP Port";
    private static final String SMTP_PORT_TEXT_FIELD_DESC = "The SMTP port on your email server. The default value is 25.";
    private static final String SMTP_PORT_TEXT_FIELD_DEFAULT_VALUE = "25";
    private static final String ENCRYPTION_METHOD_SELECT_FIELD_NAME = "Encryption Method";
    private static final String ENCRYPTION_METHOD_SELECT_FIELD_DESC = "Select 'None' (the default) to establish an unencrypted connection to the email server at the SMTP port.\nSelect 'SSL/TLS' to establish a secure connection to the email server at the SMTPS port.\nSelect 'STARTTLS' to establish an unencrypted connection to the email server at the SMTP port and initiate a secure channel afterward.";
    private static final String ENCRYPTION_METHOD_SELECT_FIELD_DEFAULT_VALUE = "NONE";
    private static final String SMTPS_PORT_TEXT_FIELD_NAME = "SMTPS Port";
    private static final String SMTPS_PORT_TEXT_FIELD_DESC = "The secure SMTP port on your email server. This field is not active unless SSL/TLS is the chosen encryption method. The default value is 465.";
    private static final String SMTPS_PORT_TEXT_FIELD_DEFAULT_VALUE = "465";
    private static final String VERIFY_HOST_NAME_CHECKBOX_FIELD_NAME = "Verify Hostname";
    private static final String VERIFY_HOST_NAME_CHECKBOX_FIELD_DESC = "Indicates whether to verify the hostname of the email server matches the Subject (CN) or one of the Subject Alternative Names from the certificate. Applies when either 'SSL/TLS' or 'STARTTLS' is the chosen encryption method.";
    private static final String EMAIL_SERVER_SUPPORT_UTF8_HEADER_FIELD_NAME = "UTF-8 Message Header Support";
    private static final String EMAIL_SERVER_SUPPORT_UTF8_HEADER_FIELD_DESC = "Indicates whether the email server supports UTF-8 in message headers (E.g. recipient email address). Only enable this if your email server supports this feature.";
    private static final String USERNAME_TEXT_FIELD_NAME = "Username";
    private static final String USERNAME_TEXT_FIELD_DESC = "Authorized email account.";
    private static final String PASSWORD_TEXT_FIELD_NAME = "Password";
    private static final String PASSWORD_TEXT_FIELD_DESC = "Password for the authorized email account.";
    private static final String TEST_ADDRESS_TEXT_FIELD_NAME = "Test Address";
    private static final String TEST_ADDRESS_TEXT_FIELD_DESC = "Enter an email address the PingFederate should use to verify connectivity with the configured email server.";
    private static final String CONNECTION_TIMEOUT_TEXT_FIELD_NAME = "Connection Timeout";
    private static final String CONNECTION_TIMEOUT_TEXT_FIELD_DESC = "The amount of time in seconds that PingFederate waits before it times out connecting to the SMTP server. The default value is 30.";
    private static final String CONNECTION_TIMEOUT_TEXT_FIELD_DEFAULT_VALUE = "30";
    private static final String RETRY_ATTEMPT_TEXT_FIELD_NAME = "Retry Attempt";
    private static final String RETRY_ATTEMPT_TEXT_FIELD_DESC = "Deprecated field, no longer used. The number of times the PingFederate tries again after encountering an error.";
    private static final String RETRY_DELAY_TEXT_FIELD_NAME = "Retry Delay";
    private static final String RETRY_DELAY_TEXT_FIELD_DESC = "Deprecated field, no longer used. The amount of time in minutes that PingFederate waits before trying to send an email notification again.";
    private static final String ENABLE_SMTP_DEBUGGING_CHECKBOX_FIELD_NAME = "Enable SMTP Debugging Messages";
    private static final String ENABLE_SMTP_DEBUGGING_CHECKBOX_FIELD_DESC = "Turns on detailed error messages for the PingFederate server log to help troubleshoot SMTP issues.\n\nWARNING: This setting is disabled by default. When enabled, PingFederate logs email messages, which may contain sensitive information, to the server log. ";
    private static final String TEST_EMAIL_ACTION_NAME = "Test";
    private static final String TEST_EMAIL_ACTION_DESC = "Test Email Connectivity";
    private static final String EMAIL_TEST_ERROR_MESSAGE = "There was an error sending the test email message. Please ensure that the email server settings are correct.";
    private static final String EMAIL_TEST_SUCCESS_MESSAGE = "Email test succeeded.";
    private static final int SENDER_NAME_MAX_LENGTH = 256;

    private SmtpNotificationPluginHelper() {
    }

    public static GuiConfigDescriptor createGuiConfigDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor(DESCRIPTION);
        TextFieldDescriptor fromAddress = new TextFieldDescriptor(FROM_TEXT_FIELD_NAME, FROM_TEXT_FIELD_DESC);
        fromAddress.addValidator((FieldValidator)new RequiredFieldValidator());
        fromAddress.addValidator((FieldValidator)new EmailValidator());
        guiConfigDescriptor.addField((FieldDescriptor)fromAddress);
        TextFieldDescriptor senderName = new TextFieldDescriptor(SENDER_NAME_FIELD_NAME, SENDER_NAME_FIELD_DESC);
        senderName.addValidator((FieldValidator)new StringLengthValidator(256));
        guiConfigDescriptor.addField((FieldDescriptor)senderName);
        TextFieldDescriptor mailServer = new TextFieldDescriptor(EMAIL_SERVER_TEXT_FIELD_NAME, EMAIL_SERVER_TEXT_FIELD_DESC);
        mailServer.addValidator((FieldValidator)new RequiredFieldValidator());
        mailServer.addValidator((FieldValidator)new HostnameValidator());
        guiConfigDescriptor.addField((FieldDescriptor)mailServer);
        TextFieldDescriptor smtpPort = new TextFieldDescriptor(SMTP_PORT_TEXT_FIELD_NAME, SMTP_PORT_TEXT_FIELD_DESC);
        smtpPort.addValidator((FieldValidator)new RequiredFieldValidator());
        smtpPort.addValidator((FieldValidator)new IntegerValidator(0, 65535));
        smtpPort.setDefaultValue(SMTP_PORT_TEXT_FIELD_DEFAULT_VALUE);
        guiConfigDescriptor.addField((FieldDescriptor)smtpPort);
        List<AbstractSelectionFieldDescriptor.OptionValue> encryptionMethodOptions = Arrays.asList(new AbstractSelectionFieldDescriptor.OptionValue("None", ENCRYPTION_METHOD_SELECT_FIELD_DEFAULT_VALUE), new AbstractSelectionFieldDescriptor.OptionValue("SSL/TLS", "SSL"), new AbstractSelectionFieldDescriptor.OptionValue("STARTTLS", "TLS"));
        SelectFieldDescriptor encryptionMethod = new SelectFieldDescriptor(ENCRYPTION_METHOD_SELECT_FIELD_NAME, ENCRYPTION_METHOD_SELECT_FIELD_DESC, encryptionMethodOptions);
        encryptionMethod.setDefaultValue(ENCRYPTION_METHOD_SELECT_FIELD_DEFAULT_VALUE);
        guiConfigDescriptor.addField((FieldDescriptor)encryptionMethod);
        TextFieldDescriptor smtpsPort = new TextFieldDescriptor(SMTPS_PORT_TEXT_FIELD_NAME, SMTPS_PORT_TEXT_FIELD_DESC);
        smtpsPort.addValidator((FieldValidator)new RequiredFieldValidator());
        smtpsPort.addValidator((FieldValidator)new IntegerValidator(0, 65535));
        smtpsPort.setDefaultValue(SMTPS_PORT_TEXT_FIELD_DEFAULT_VALUE);
        guiConfigDescriptor.addField((FieldDescriptor)smtpsPort);
        CheckBoxFieldDescriptor verifyHostName = new CheckBoxFieldDescriptor(VERIFY_HOST_NAME_CHECKBOX_FIELD_NAME, VERIFY_HOST_NAME_CHECKBOX_FIELD_DESC);
        verifyHostName.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)verifyHostName);
        CheckBoxFieldDescriptor emailServerUtf8Support = new CheckBoxFieldDescriptor(EMAIL_SERVER_SUPPORT_UTF8_HEADER_FIELD_NAME, EMAIL_SERVER_SUPPORT_UTF8_HEADER_FIELD_DESC);
        emailServerUtf8Support.setDefaultValue(false);
        emailServerUtf8Support.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)emailServerUtf8Support);
        TextFieldDescriptor username = new TextFieldDescriptor(USERNAME_TEXT_FIELD_NAME, USERNAME_TEXT_FIELD_DESC);
        guiConfigDescriptor.addField((FieldDescriptor)username);
        TextFieldDescriptor password = new TextFieldDescriptor(PASSWORD_TEXT_FIELD_NAME, PASSWORD_TEXT_FIELD_DESC, true);
        guiConfigDescriptor.addField((FieldDescriptor)password);
        TextFieldDescriptor testAddress = new TextFieldDescriptor(TEST_ADDRESS_TEXT_FIELD_NAME, TEST_ADDRESS_TEXT_FIELD_DESC);
        guiConfigDescriptor.addField((FieldDescriptor)testAddress);
        TextFieldDescriptor connectionTimeout = new TextFieldDescriptor(CONNECTION_TIMEOUT_TEXT_FIELD_NAME, CONNECTION_TIMEOUT_TEXT_FIELD_DESC);
        connectionTimeout.addValidator((FieldValidator)new RequiredFieldValidator());
        connectionTimeout.addValidator((FieldValidator)new IntegerValidator(0, 3600));
        connectionTimeout.setDefaultValue(CONNECTION_TIMEOUT_TEXT_FIELD_DEFAULT_VALUE);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)connectionTimeout);
        TextFieldDescriptor retryAttempt = new TextFieldDescriptor(RETRY_ATTEMPT_TEXT_FIELD_NAME, RETRY_ATTEMPT_TEXT_FIELD_DESC);
        retryAttempt.setHidden(true);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)retryAttempt);
        TextFieldDescriptor retryDelay = new TextFieldDescriptor(RETRY_DELAY_TEXT_FIELD_NAME, RETRY_DELAY_TEXT_FIELD_DESC);
        retryDelay.setHidden(true);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)retryDelay);
        CheckBoxFieldDescriptor smtpDebugging = new CheckBoxFieldDescriptor(ENABLE_SMTP_DEBUGGING_CHECKBOX_FIELD_NAME, ENABLE_SMTP_DEBUGGING_CHECKBOX_FIELD_DESC);
        smtpDebugging.setDefaultValue(false);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)smtpDebugging);
        guiConfigDescriptor.addValidator(configuration -> {
            if (StringUtils.isNotBlank((String)configuration.getFieldValue(USERNAME_TEXT_FIELD_NAME)) ^ StringUtils.isNotBlank((String)configuration.getFieldValue(PASSWORD_TEXT_FIELD_NAME))) {
                throw new ValidationException(String.format("'%s' and '%s' must both be populated or not at all.", USERNAME_TEXT_FIELD_NAME, PASSWORD_TEXT_FIELD_NAME));
            }
        });
        ActionDescriptor.Action & Serializable testSettingsAction = (ActionDescriptor.Action & Serializable)configuration -> {
            String testAddressValue = configuration.getFieldValue(TEST_ADDRESS_TEXT_FIELD_NAME);
            if (StringUtils.isBlank((String)testAddressValue)) {
                return String.format("%s is required to perform %s action.", TEST_ADDRESS_TEXT_FIELD_NAME, TEST_EMAIL_ACTION_DESC);
            }
            Map<String, Object> params = SmtpNotificationPluginHelper.addAdditionalEmailParams(null);
            EmailServerSettings emailServerSettings = SmtpNotificationPluginHelper.toEmailServerSettings(configuration);
            EmailUtil emailUtil = new EmailUtil(EmailUtilSystemSettingsImpl.getInstance());
            if (emailUtil.sendTestEmail(emailServerSettings, testAddressValue, params)) {
                return EMAIL_TEST_SUCCESS_MESSAGE;
            }
            return EMAIL_TEST_ERROR_MESSAGE;
        };
        guiConfigDescriptor.addAction(new ActionDescriptor(TEST_EMAIL_ACTION_NAME, TEST_EMAIL_ACTION_DESC, (ActionDescriptor.Action)testSettingsAction));
        return guiConfigDescriptor;
    }

    public static boolean sendEmail(String templateFile, Map<String, Object> params, Configuration configuration, String languageTag, String sendTo) {
        EmailServerSettings emailServerSettings = SmtpNotificationPluginHelper.toEmailServerSettings(configuration);
        Locale locale = StringUtils.isNotBlank((String)languageTag) ? Locale.forLanguageTag(languageTag) : null;
        Map<String, Object> emailParams = SmtpNotificationPluginHelper.addAdditionalEmailParams(params);
        EmailUtil emailUtil = new EmailUtil(EmailUtilSystemSettingsImpl.getInstance());
        return emailUtil.sendEmail(templateFile, emailParams, emailServerSettings, locale, sendTo);
    }

    public static Configuration translateNotificationSettings(NotificationSettings notificationSettings) {
        LinkedList<Field> fieldsList = new LinkedList<Field>();
        fieldsList.add(new Field(FROM_TEXT_FIELD_NAME, notificationSettings.getFrom()));
        fieldsList.add(new Field(SENDER_NAME_FIELD_NAME, notificationSettings.getSender()));
        fieldsList.add(new Field(EMAIL_SERVER_TEXT_FIELD_NAME, notificationSettings.getSmtpServer()));
        fieldsList.add(new Field(SMTP_PORT_TEXT_FIELD_NAME, notificationSettings.getSmtpPort()));
        String encryptionMethod = notificationSettings.isUseSSL() ? "SSL" : (notificationSettings.isUseTLS() ? "TLS" : ENCRYPTION_METHOD_SELECT_FIELD_DEFAULT_VALUE);
        fieldsList.add(new Field(ENCRYPTION_METHOD_SELECT_FIELD_NAME, encryptionMethod));
        fieldsList.add(new Field(SMTPS_PORT_TEXT_FIELD_NAME, notificationSettings.getSslSmtpPort()));
        fieldsList.add(new Field(VERIFY_HOST_NAME_CHECKBOX_FIELD_NAME, notificationSettings.isVerifyHostname() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        fieldsList.add(new Field(EMAIL_SERVER_SUPPORT_UTF8_HEADER_FIELD_NAME, notificationSettings.isAllowUtf8MsgHeaders() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        fieldsList.add(new Field(USERNAME_TEXT_FIELD_NAME, notificationSettings.getUser()));
        fieldsList.add(new Field(PASSWORD_TEXT_FIELD_NAME, notificationSettings.getPassword()));
        LinkedList<Field> advancedFieldsList = new LinkedList<Field>();
        advancedFieldsList.add(new Field(CONNECTION_TIMEOUT_TEXT_FIELD_NAME, notificationSettings.getTimeout()));
        advancedFieldsList.add(new Field(RETRY_ATTEMPT_TEXT_FIELD_NAME, notificationSettings.getEmailRetryAttempt()));
        advancedFieldsList.add(new Field(RETRY_DELAY_TEXT_FIELD_NAME, notificationSettings.getEmailRetryDelay()));
        advancedFieldsList.add(new Field(ENABLE_SMTP_DEBUGGING_CHECKBOX_FIELD_NAME, notificationSettings.isUseDebugging() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        Configuration configuration = new Configuration(fieldsList, Collections.emptyList(), advancedFieldsList);
        return configuration;
    }

    public static Configuration toConfiguration(EmailServerSettings emailServerSettings) {
        if (emailServerSettings == null) {
            return new Configuration();
        }
        LinkedList<Field> fieldsList = new LinkedList<Field>();
        fieldsList.add(new Field(FROM_TEXT_FIELD_NAME, emailServerSettings.getFrom()));
        fieldsList.add(new Field(SENDER_NAME_FIELD_NAME, emailServerSettings.getSender()));
        fieldsList.add(new Field(EMAIL_SERVER_TEXT_FIELD_NAME, emailServerSettings.getSmtpServer()));
        fieldsList.add(new Field(SMTP_PORT_TEXT_FIELD_NAME, emailServerSettings.getSmtpPort()));
        String encryptionMethod = emailServerSettings.isUseSSL() ? "SSL" : (emailServerSettings.isUseTLS() ? "TLS" : ENCRYPTION_METHOD_SELECT_FIELD_DEFAULT_VALUE);
        fieldsList.add(new Field(ENCRYPTION_METHOD_SELECT_FIELD_NAME, encryptionMethod));
        fieldsList.add(new Field(SMTPS_PORT_TEXT_FIELD_NAME, emailServerSettings.getSslSmtpPort()));
        fieldsList.add(new Field(VERIFY_HOST_NAME_CHECKBOX_FIELD_NAME, emailServerSettings.isVerifyHostname() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        fieldsList.add(new Field(EMAIL_SERVER_SUPPORT_UTF8_HEADER_FIELD_NAME, emailServerSettings.isAllowUtf8MsgHeaders() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        fieldsList.add(new Field(USERNAME_TEXT_FIELD_NAME, emailServerSettings.getUser()));
        fieldsList.add(new Field(PASSWORD_TEXT_FIELD_NAME, emailServerSettings.getPassword()));
        LinkedList<Field> advancedFieldsList = new LinkedList<Field>();
        advancedFieldsList.add(new Field(CONNECTION_TIMEOUT_TEXT_FIELD_NAME, emailServerSettings.getTimeout()));
        advancedFieldsList.add(new Field(RETRY_ATTEMPT_TEXT_FIELD_NAME, emailServerSettings.getEmailRetryAttempt()));
        advancedFieldsList.add(new Field(RETRY_DELAY_TEXT_FIELD_NAME, emailServerSettings.getEmailRetryDelay()));
        advancedFieldsList.add(new Field(ENABLE_SMTP_DEBUGGING_CHECKBOX_FIELD_NAME, emailServerSettings.isUseDebugging() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        Configuration configuration = new Configuration(fieldsList, Collections.emptyList(), advancedFieldsList);
        return configuration;
    }

    public static EmailServerSettings toEmailServerSettings(Configuration configuration) {
        boolean enable = true;
        boolean useSSL = "SSL".equals(configuration.getFieldValue(ENCRYPTION_METHOD_SELECT_FIELD_NAME));
        boolean useTLS = "TLS".equals(configuration.getFieldValue(ENCRYPTION_METHOD_SELECT_FIELD_NAME));
        boolean verifyHostname = configuration.getBooleanFieldValue(VERIFY_HOST_NAME_CHECKBOX_FIELD_NAME);
        boolean enableUtf8MsgHeaders = configuration.getBooleanFieldValue(EMAIL_SERVER_SUPPORT_UTF8_HEADER_FIELD_NAME);
        boolean useDebugging = configuration.getAdvancedFields().getBooleanFieldValue(ENABLE_SMTP_DEBUGGING_CHECKBOX_FIELD_NAME);
        String smtpServer = configuration.getFieldValue(EMAIL_SERVER_TEXT_FIELD_NAME);
        String smtpPort = configuration.getFieldValue(SMTP_PORT_TEXT_FIELD_NAME);
        String sslSmtpPort = configuration.getFieldValue(SMTPS_PORT_TEXT_FIELD_NAME);
        String timeout = configuration.getAdvancedFields().getFieldValue(CONNECTION_TIMEOUT_TEXT_FIELD_NAME);
        String from = configuration.getFieldValue(FROM_TEXT_FIELD_NAME);
        String sender = configuration.getFieldValue(SENDER_NAME_FIELD_NAME);
        String user = configuration.getFieldValue(USERNAME_TEXT_FIELD_NAME);
        String password = configuration.getFieldValue(PASSWORD_TEXT_FIELD_NAME);
        String retryAttempt = configuration.getAdvancedFields().getFieldValue(RETRY_ATTEMPT_TEXT_FIELD_NAME);
        String retryDelay = configuration.getAdvancedFields().getFieldValue(RETRY_DELAY_TEXT_FIELD_NAME);
        return new EmailServerSettings(enable, useSSL, useTLS, verifyHostname, enableUtf8MsgHeaders, useDebugging, smtpServer, smtpPort, sslSmtpPort, timeout, from, sender, user, password, retryAttempt, retryDelay);
    }

    private static Map<String, Object> addAdditionalEmailParams(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (params != null && !params.isEmpty()) {
            result.putAll(params);
        }
        if (!result.containsKey("BASE_URL")) {
            Object baseUrl = BaseUrlAccessor.getCurrentBaseUrl();
            if (StringUtils.isNotBlank((String)baseUrl) && !((String)baseUrl).endsWith("/")) {
                baseUrl = (String)baseUrl + "/";
            }
            result.put("BASE_URL", baseUrl);
        }
        String logoName = EMAIL_CUSTOMER_COMPANY_LOGO;
        String path = MgmtFactory.getSysDirInfo().getImagesDir() + File.separator + logoName;
        File f = new File(path);
        result.put("COMPANY_LOGO_EXISTS", String.valueOf(f.exists()));
        return result;
    }

    public static Field getTestEmailField(Configuration configuration) {
        return configuration.getField(TEST_ADDRESS_TEXT_FIELD_NAME);
    }
}

