/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.email.util;

import com.pingidentity.sdk.notification.NotificationPublisherPlugin;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class NotificationSenderFactory {
    private static final Log log = LogFactory.getLog(NotificationSenderFactory.class);

    public static final NotificationPublisherPlugin getSender(String pluginId) {
        NotificationPublisherPlugin notificationSender = null;
        if (StringUtils.isNotBlank((String)pluginId)) {
            notificationSender = MgmtFactory.getNotificationPublisherPluginManager().getNotificationSenderPlugin(pluginId);
        } else {
            NotificationSenderPluginInstance defaultPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
            if (defaultPluginInstance != null) {
                notificationSender = MgmtFactory.getNotificationPublisherPluginManager().getNotificationSenderPlugin(defaultPluginInstance.getId());
            }
        }
        if (notificationSender != null) {
            return notificationSender;
        }
        log.error(StringUtils.isNotBlank((String)pluginId) ? "Unable to find the instance of the given notification publisher: " + pluginId : "Unable to find the default instance of notification publisher.");
        return null;
    }
}

