/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.email.util;

import com.pingidentity.adapter.htmlform.HtmlFormAdapterConfig;
import com.pingidentity.common.util.HTMLEncoder;
import com.pingidentity.email.mgmt.NotificationDispatcherManager;
import com.pingidentity.localidentity.EmailVerificationConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.util.BaseUrlUtil;

public class NotificationSupportHelper {
    public static final String NOTIFY_OF_ACCOUNT_CHANGES = "Notify administrator of account changes";
    public static final String TIMEOUT = "Connection timeout";
    public static final String USERNAME = "Username";
    public static final String PASSWORD = "Password";
    static final String DEFAULT_ID = "Default";
    private static final Log logger = LogFactory.getLog(NotificationSupportHelper.class);
    private static final NotificationDispatcherManager notificationDispatcher = MgmtFactory.getNotificationDispatcherManager();
    private static final NotificationPublisherPluginManager NOTIFICATION_PUBLISHER_PLUGIN_MGR = MgmtFactory.getNotificationPublisherPluginManager();
    private static final NotificationMgr NOTIFICATION_MGR = MgmtFactory.getNotificationMgr();

    public void sendPasswordChangeEmail(AdministrativeUser userMakingRequest, AdministrativeUser user, NotificationSettings settings) {
        NotificationSettings tempSettings = new NotificationSettings(settings);
        String notificationPublisher = settings.getNotificationPublisherAccountChanges();
        if (!StringUtils.isBlank((String)user.getEmailAddress())) {
            String toAddress = user.getEmailAddress();
            tempSettings.setTo(toAddress);
            HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
            substitutionMap.put("USERNAME", user.getUserName());
            substitutionMap.put("RECEIVER", tempSettings.getTo());
            substitutionMap.put("DEPARTMENT", user.getDepartment());
            substitutionMap.put("DESCRIPTION", user.getDescription());
            substitutionMap.put("PHONE_NUMBER", user.getPhoneNumber());
            if (userMakingRequest != null) {
                substitutionMap.put("CURRENT_USER_MESSAGE", " by " + userMakingRequest.getUserName());
            }
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("com.pingidentity.notification.config.destination.address", tempSettings.getTo());
            config.put("com.pingidentity.notification.config.template.name", "message-template-password.html");
            notificationDispatcher.dispatchNotification(notificationPublisher, NotificationEventType.ADMIN_PASSWORD_CHANGED.toString(), substitutionMap, config);
        }
    }

    public void sendEmailChangeEmail(AdministrativeUser userMakingRequest, AdministrativeUser updatedUser, AdministrativeUser origUser, NotificationSettings settings) {
        String toAddress;
        NotificationSettings tempSettings;
        String notificationPublisher = settings.getNotificationPublisherAccountChanges();
        if (!StringUtils.isBlank((String)origUser.getEmailAddress())) {
            tempSettings = new NotificationSettings(settings);
            toAddress = origUser.getEmailAddress();
            tempSettings.setTo(toAddress);
            HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
            substitutionMap.put("USERNAME", origUser.getUserName());
            substitutionMap.put("RECEIVER", toAddress);
            substitutionMap.put("DEPARTMENT", origUser.getDepartment());
            substitutionMap.put("DESCRIPTION", origUser.getDescription());
            substitutionMap.put("PHONE_NUMBER", origUser.getPhoneNumber());
            if (userMakingRequest != null) {
                substitutionMap.put("CURRENT_USER_MESSAGE", " by " + userMakingRequest.getUserName());
            }
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("com.pingidentity.notification.config.destination.address", tempSettings.getTo());
            config.put("com.pingidentity.notification.config.template.name", "message-template-email.html");
            notificationDispatcher.dispatchNotification(notificationPublisher, NotificationEventType.ADMIN_EMAIL_CHANGED.toString(), substitutionMap, config);
        }
        if (!StringUtils.isBlank((String)updatedUser.getEmailAddress())) {
            tempSettings = new NotificationSettings(settings);
            toAddress = updatedUser.getEmailAddress();
            tempSettings.setTo(toAddress);
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            subMap.put("USERNAME", updatedUser.getUserName());
            subMap.put("RECEIVER", toAddress);
            subMap.put("DEPARTMENT", updatedUser.getDepartment());
            subMap.put("DESCRIPTION", updatedUser.getDescription());
            subMap.put("PHONE_NUMBER", updatedUser.getPhoneNumber());
            if (userMakingRequest != null) {
                subMap.put("CURRENT_USER_MESSAGE", " by " + userMakingRequest.getUserName());
            }
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("com.pingidentity.notification.config.destination.address", tempSettings.getTo());
            config.put("com.pingidentity.notification.config.template.name", "message-template-email.html");
            notificationDispatcher.dispatchNotification(notificationPublisher, NotificationEventType.ADMIN_EMAIL_CHANGED.toString(), subMap, config);
        }
    }

    public boolean isUserEmailChanged(AdministrativeUser origUser, AdministrativeUser updatedUser) {
        String userLatestEmailAddress = updatedUser.getEmailAddress() == null ? "" : updatedUser.getEmailAddress();
        String userOldEmailAddress = origUser.getEmailAddress() == null ? "" : origUser.getEmailAddress();
        return !StringUtils.equalsIgnoreCase((String)userLatestEmailAddress, (String)userOldEmailAddress);
    }

    public boolean isNotificationPublisherChanged(String origPublisher, String updatedPublisher) {
        String normalizedOrigPublisher = StringUtils.isEmpty((String)origPublisher) ? "" : origPublisher;
        String normalizedUpdatedPublisher = StringUtils.isEmpty((String)updatedPublisher) ? "" : updatedPublisher;
        return !normalizedOrigPublisher.equalsIgnoreCase(normalizedUpdatedPublisher);
    }

    public boolean isNotifyFlagSwitchingOff(boolean originalFlag, boolean updatedFlag) {
        return originalFlag && !updatedFlag;
    }

    public void sendNotificationsChangeEmail(NotificationSettings settings, AdministrativeUser userMakingRequest, Map<String, AdministrativeUser> newUsers, Map<String, AdministrativeUser> oldUsers, String notificationSender, NotificationEventType eventType, String ... changedFlags) {
        NotificationSettings tempSettings;
        AdminAuditLogger.log(AdminAuditLogger.Component.NOTIFICATION_SETTINGS, AdminAuditLogger.Event.MODIFY, "'Notify administrator of account changes' flag has been switched off.");
        for (Map.Entry<String, AdministrativeUser> entry : oldUsers.entrySet()) {
            AdministrativeUser origUser = entry.getValue();
            String toAddress = origUser.getEmailAddress();
            tempSettings = new NotificationSettings(settings);
            if (StringUtils.isBlank((String)toAddress)) continue;
            tempSettings.setTo(toAddress);
            HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
            substitutionMap.put("USERNAME", origUser.getUserName());
            substitutionMap.put("RECEIVER", tempSettings.getTo());
            substitutionMap.put("NOTIFY", Arrays.toString(changedFlags));
            if (userMakingRequest != null) {
                substitutionMap.put("CURRENT_USER_MESSAGE", " by " + userMakingRequest.getUserName());
            }
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("com.pingidentity.notification.config.destination.address", tempSettings.getTo());
            config.put("com.pingidentity.notification.config.template.name", "message-template-notifications.html");
            notificationDispatcher.dispatchNotification(notificationSender, eventType.toString(), substitutionMap, config);
        }
        for (Map.Entry<String, AdministrativeUser> entry : newUsers.entrySet()) {
            String updatedUserKey = entry.getKey();
            boolean newUser = false;
            AdministrativeUser oldUser = oldUsers.get(updatedUserKey);
            if (oldUser == null) {
                newUser = true;
            }
            AdministrativeUser updatedUser = newUsers.get(updatedUserKey);
            String toAddress = updatedUser.getEmailAddress();
            tempSettings = new NotificationSettings(settings);
            if (StringUtils.isBlank((String)toAddress) || !newUser && !this.isUserEmailChanged(oldUser, updatedUser)) continue;
            tempSettings.setTo(toAddress);
            HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
            substitutionMap.put("USERNAME", updatedUser.getUserName());
            substitutionMap.put("RECEIVER", tempSettings.getTo());
            substitutionMap.put("NOTIFY", Arrays.toString(changedFlags));
            if (userMakingRequest != null) {
                substitutionMap.put("CURRENT_USER_MESSAGE", " by " + userMakingRequest.getUserName());
            }
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("com.pingidentity.notification.config.destination.address", tempSettings.getTo());
            config.put("com.pingidentity.notification.config.template.name", "message-template-notifications.html");
            notificationDispatcher.dispatchNotification(notificationSender, NotificationEventType.ADMIN_EMAIL_CHANGED.toString(), substitutionMap, config);
        }
    }

    public void sendPasswordResetCode(String sendTo, String username, String code, String adapterId, String pcvId, Locale locale, String notificationPublisherId, String emailTemplateName, Map<String, Object> templateData) {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("CODE", code);
        substitutionMap.put("ADAPTER_ID", adapterId);
        substitutionMap.put("PCV_ID", pcvId);
        substitutionMap.putAll(templateData);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", StringUtils.isNotBlank((String)emailTemplateName) ? emailTemplateName : "message-template-forgot-password-code.html");
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        notificationDispatcher.dispatchNotification(notificationPublisherId, NotificationEventType.PASSWORD_RESET_ONE_TIME_CODE.toString(), substitutionMap, config);
    }

    public void sendAccountDisabled(String sendTo, String username, String adapterId, String pcvId, Locale locale, String notificationPublisherId, String emailTemplateName) {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("ADAPTER_ID", adapterId);
        substitutionMap.put("PCV_ID", pcvId);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", StringUtils.isNotBlank((String)emailTemplateName) ? emailTemplateName : "message-template-account-disabled.html");
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        notificationDispatcher.dispatchNotification(notificationPublisherId, NotificationEventType.ACCOUNT_DISABLED.toString(), substitutionMap, config);
    }

    public void sendPasswordResetComplete(String sendTo, String username, String status, String adapterId, String pcvId, Locale locale, String notificationPublisherId, String emailTemplateName, Map<String, Object> templateData) {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("STATUS", status);
        substitutionMap.put("ADAPTER_ID", adapterId);
        substitutionMap.put("PCV_ID", pcvId);
        substitutionMap.putAll(templateData);
        this.sendPwdResetComplete(sendTo, substitutionMap, locale, notificationPublisherId, emailTemplateName);
    }

    public void sendAccountUnlockComplete(String sendTo, String username, String adapterId, String pcvId, Locale locale, String notificationPublisherId, String emailTemplateName, Map<String, Object> templateData) {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("ADAPTER_ID", adapterId);
        substitutionMap.put("PCV_ID", pcvId);
        substitutionMap.putAll(templateData);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", StringUtils.isNotBlank((String)emailTemplateName) ? emailTemplateName : "message-template-account-unlock-complete.html");
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        notificationDispatcher.dispatchNotification(notificationPublisherId, NotificationEventType.ACCOUNT_UNLOCKED.toString(), substitutionMap, config);
    }

    public void sendPasswordResetOneTimeLink(String sendTo, String username, String referenceId, String linkResumeUrl, String adapterId, String pcvId, Locale locale, String notificationPublisherId, String emailTemplateName, Map<String, Object> templateData) {
        String baseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl();
        baseUrl = BaseUrlUtil.getCurrentBaseUrl(baseUrl);
        String url = baseUrl + linkResumeUrl + "?a=" + URLEncoder.encode(referenceId, StandardCharsets.UTF_8);
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("CODE", url);
        substitutionMap.put("ADAPTER_ID", adapterId);
        substitutionMap.put("PCV_ID", pcvId);
        substitutionMap.putAll(templateData);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", StringUtils.isNotBlank((String)emailTemplateName) ? emailTemplateName : "message-template-forgot-password-link.html");
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        notificationDispatcher.dispatchNotification(notificationPublisherId, NotificationEventType.PASSWORD_RESET_ONE_TIME_LINK.toString(), substitutionMap, config);
    }

    public void sendEmailOwnershipVerificationOneTimeLink(String sendTo, String username, String referenceId, String linkResumeUrl, Locale locale, String emailTemplate, LocalIdentityProfile lip, Map<String, Object> templateData) {
        String baseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl();
        baseUrl = BaseUrlUtil.getCurrentBaseUrl(baseUrl);
        String url = baseUrl + linkResumeUrl + "?localidentity.a=" + URLEncoder.encode(referenceId, StandardCharsets.UTF_8);
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("CODE", url);
        substitutionMap.putAll(templateData);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", emailTemplate);
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        String pluginId = lip.getEmailOwnershipVerificationConfig().getNotificationPublisherId();
        notificationDispatcher.dispatchNotification(pluginId, NotificationEventType.OWNERSHIP_VERIFICATION_ONE_TIME_LINK.toString(), substitutionMap, config);
    }

    public void sendEmailOwnershipVerificationOneTimePasscode(String sendTo, String username, String otp, Locale locale, String emailTemplate, LocalIdentityProfile lip, Map<String, Object> templateData) {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("CODE", otp);
        substitutionMap.put("IS_OTP", "true");
        substitutionMap.putAll(templateData);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", emailTemplate);
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        String pluginId = lip.getEmailOwnershipVerificationConfig().getNotificationPublisherId();
        notificationDispatcher.dispatchNotification(pluginId, NotificationEventType.OWNERSHIP_VERIFICATION_ONE_TIME_PASSCODE.toString(), substitutionMap, config);
    }

    private void sendPwdResetComplete(String sendTo, Map<String, Object> subParams, Locale locale, String notificationPublisherId, String emailTemplateName) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", StringUtils.isNotBlank((String)emailTemplateName) ? emailTemplateName : "message-template-forgot-password-complete.html");
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        notificationDispatcher.dispatchNotification(notificationPublisherId, NotificationEventType.PASSWORD_RESET.toString(), subParams, config);
    }

    public void sendUsernameRecoveryEmail(String sendTo, String displayName, List<String> usernames, String adapterId, String pcvId, Locale locale, String templateName, String notificationPublisherId, Map<String, Object> templateData) {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAMES", StringUtils.join(usernames, (String)", "));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("DISPLAY_NAME", displayName);
        substitutionMap.put("greetUser", "greetUser");
        substitutionMap.put("successMessage", "successMessage");
        substitutionMap.put("ADAPTER_ID", adapterId);
        substitutionMap.put("PCV_ID", pcvId);
        substitutionMap.putAll(templateData);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", templateName);
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        notificationDispatcher.dispatchNotification(notificationPublisherId, NotificationEventType.USERNAME_RECOVERY.toString(), substitutionMap, config);
    }

    public static void auditLogAdminAccountsNotificationPublisher(boolean origNotifyAccountChanges, NotificationSenderPluginInstance origAdminAccChgNotificationPublisher) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            NotificationSupportHelper.auditLogAdminAccountsNotificationPublisher(origNotifyAccountChanges, origAdminAccChgNotificationPublisher, auditLoggerScope);
        }
    }

    public static void auditLogAdminAccountsNotificationPublisher(boolean origNotifyAccountChanges, NotificationSenderPluginInstance origAdminAccChgNotificationPublisher, AuditLoggerScope auditLoggerScope) {
        NotificationSettings notificationSettings = NOTIFICATION_MGR.getNotificationSettings();
        String newAccChgNotificationPublisherId = notificationSettings.getNotificationPublisherAccountChanges();
        NotificationSenderPluginInstance newAdminAccChgNotificationPublisher = NotificationSupportHelper.getNotificationPublisherForAuditLogDiff(newAccChgNotificationPublisherId);
        NotificationSupportHelper.auditLogAdminAccountsNotificationPublisherHelper(origNotifyAccountChanges, notificationSettings.isEnableAccountChangesNotification(), origAdminAccChgNotificationPublisher, newAdminAccChgNotificationPublisher, auditLoggerScope);
    }

    private static void auditLogAdminAccountsNotificationPublisherHelper(boolean originalEnableAccountChangesNotification, boolean newEnableAccountChangesNotification, NotificationSenderPluginInstance origNotificationPublisher, NotificationSenderPluginInstance newNotificationPublisher, AuditLoggerScope auditLoggerScope) {
        if (!originalEnableAccountChangesNotification || !newEnableAccountChangesNotification) {
            return;
        }
        if (origNotificationPublisher != null && newNotificationPublisher == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"There was originally a notification publisher, but it is now deleted.");
            }
            auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.DELETE, "Notification Publisher for notifying of administrative account changes has been deleted.");
        } else if (newNotificationPublisher != null && origNotificationPublisher == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"There was originally no notification publisher, but there is one now.");
            }
            auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.CREATE, "Notification Publisher for notifying of administrative account changes has been created.");
        } else if (newNotificationPublisher != null && origNotificationPublisher != null) {
            if (origNotificationPublisher.getId() != null && origNotificationPublisher.getId().equals(newNotificationPublisher.getId())) {
                NotificationSupportHelper.auditLogConfigurationChanges(origNotificationPublisher, newNotificationPublisher, auditLoggerScope);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("The notification publisher used has changed from '%s' to '%s'.", origNotificationPublisher.getId(), newNotificationPublisher.getId()));
                }
                auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.MODIFY, String.format("Notification Publisher used for notifying of administrative account changes has changed from '%s' to '%s'.", origNotificationPublisher.getId(), newNotificationPublisher.getId()));
                if (origNotificationPublisher.getName() != null && origNotificationPublisher.getName().equals(newNotificationPublisher.getName()) && (DEFAULT_ID.equals(origNotificationPublisher.getId()) || DEFAULT_ID.equals(newNotificationPublisher.getId()))) {
                    NotificationSupportHelper.auditLogConfigurationChanges(origNotificationPublisher, newNotificationPublisher, auditLoggerScope);
                }
            }
        }
    }

    private static void auditLogConfigurationChanges(NotificationSenderPluginInstance origNotificationPublisher, NotificationSenderPluginInstance newNotificationPublisher, AuditLoggerScope auditLoggerScope) {
        Configuration originalConfig = origNotificationPublisher.getConfiguration();
        PluginDescriptor originalPluginDescriptor = origNotificationPublisher.getDescriptor();
        Configuration newConfig = newNotificationPublisher.getConfiguration();
        PluginDescriptor newPluginDescriptor = newNotificationPublisher.getDescriptor();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Checking for configuration differences between publishers '%s' and '%s'.", origNotificationPublisher.getId(), newNotificationPublisher.getId()));
        }
        if (originalConfig == null || newConfig == null) {
            logger.error((Object)"Cannot detect if notification publisher for administrative account changes was modified because configuration data is missing.");
            return;
        }
        if (originalPluginDescriptor == null || newPluginDescriptor == null) {
            logger.error((Object)"Cannot detect if notification publisher for administrative account changes was modified because the publisher plugin descriptor is missing.");
            return;
        }
        if (originalPluginDescriptor.getType().equals(newPluginDescriptor.getType())) {
            GuiConfigDescriptor guiConfigDescriptor = originalPluginDescriptor.getGuiConfigDescriptorBuilder().buildNewGuiDescriptor();
            NotificationSupportHelper.findFieldChanges(originalConfig, newConfig, guiConfigDescriptor, auditLoggerScope);
            NotificationSupportHelper.findAdvancedFieldChanges(originalConfig, newConfig, guiConfigDescriptor, auditLoggerScope);
            NotificationSupportHelper.findTableFieldChanges(originalConfig, newConfig, guiConfigDescriptor, auditLoggerScope);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("The notification publisher type has changed from '%s' to '%s'", originalPluginDescriptor.getType(), newPluginDescriptor.getType()));
            }
            auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.MODIFY, String.format("Notification Publisher type used for notifying of administrative account changes has changed from '%s' to '%s'.", originalPluginDescriptor.getType(), newPluginDescriptor.getType()));
        }
    }

    static void findFieldChanges(Configuration originalConfig, Configuration newConfig, GuiConfigDescriptor originalGuiConfigDescriptor, AuditLoggerScope auditLoggerScope) {
        for (FieldDescriptor fieldDescriptor : originalGuiConfigDescriptor.getFields()) {
            String newConfigFieldVal;
            String fieldName = fieldDescriptor.getName();
            String origConfigFieldVal = Optional.of(originalConfig).map(configuration -> configuration.getField(fieldName)).map(Field::getValue).orElse(null);
            if (StringUtils.equals((String)origConfigFieldVal, (String)(newConfigFieldVal = (String)Optional.of(newConfig).map(configuration -> configuration.getField(fieldName)).map(Field::getValue).orElse(null)))) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Field '%s' has changed.", fieldName));
            }
            auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.MODIFY, "Notification Publisher for notifying of administrative account changes has been changed: " + fieldName);
        }
    }

    static void findAdvancedFieldChanges(Configuration originalConfig, Configuration newConfig, GuiConfigDescriptor guiConfigDescriptor, AuditLoggerScope auditLoggerScope) {
        for (FieldDescriptor fieldDescriptor : guiConfigDescriptor.getAdvancedFields()) {
            String newConfigFieldVal;
            String fieldName = fieldDescriptor.getName();
            String origConfigFieldVal = Optional.of(originalConfig).map(Configuration::getAdvancedFields).map(fieldList -> fieldList.getField(fieldName)).map(Field::getValue).orElse(null);
            if (StringUtils.equals((String)origConfigFieldVal, (String)(newConfigFieldVal = (String)Optional.of(newConfig).map(Configuration::getAdvancedFields).map(fieldList -> fieldList.getField(fieldName)).map(Field::getValue).orElse(null)))) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Advanced field '%s' has changed.", fieldName));
            }
            auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.MODIFY, "Notification Publisher for notifying of administrative account changes has been changed: " + fieldName);
        }
    }

    static void findTableFieldChanges(Configuration originalConfig, Configuration newConfig, GuiConfigDescriptor guiConfigDescriptor, AuditLoggerScope auditLoggerScope) {
        for (TableDescriptor tableDescriptor : guiConfigDescriptor.getTables()) {
            String tableName = tableDescriptor.getName();
            List origConfigTableRows = Optional.of(originalConfig).map(configuration -> configuration.getTable(tableName)).map(Table::getRows).orElse(new ArrayList());
            List newConfigTableRows = Optional.of(newConfig).map(configuration -> configuration.getTable(tableName)).map(Table::getRows).orElse(new ArrayList());
            if (origConfigTableRows.size() != newConfigTableRows.size()) {
                String addedOrDeletedStr;
                String string = addedOrDeletedStr = origConfigTableRows.size() > newConfigTableRows.size() ? "deleted" : "added";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Table '%s' had rows %s. Original: %d | New: %d.", tableName, addedOrDeletedStr, origConfigTableRows.size(), newConfigTableRows.size()));
                }
                auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.MODIFY, String.format("Notification Publisher for notifying of administrative account changes has rows %s for configuration table: %s.", addedOrDeletedStr, tableName));
                continue;
            }
            for (int rowIndex = 0; rowIndex < origConfigTableRows.size(); ++rowIndex) {
                for (FieldDescriptor rowFieldsDescriptor : tableDescriptor.getRowFields()) {
                    String newTableRowVal;
                    String rowFieldName = rowFieldsDescriptor.getName();
                    String origTableRowVal = Optional.of((Row)origConfigTableRows.get(rowIndex)).map(row -> row.getField(rowFieldName)).map(Field::getValue).orElse(null);
                    if (StringUtils.equals((String)origTableRowVal, (String)(newTableRowVal = (String)Optional.of((Row)newConfigTableRows.get(rowIndex)).map(row -> row.getField(rowFieldName)).map(Field::getValue).orElse(null)))) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Table '%s' row %d field '%s' has changed", tableName, rowIndex, rowFieldName));
                    }
                    auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.MODIFY, String.format("Notification Publisher for notifying of administrative account changes has been modified for configuration table '%s' row %d field: %s", tableName, rowIndex, rowFieldName));
                }
            }
        }
    }

    public void sendPasswordResetFailed(String sendTo, String username, String adapterId, String pcvId, Locale locale, String notificationPublisherId, String emailTemplateName, Map<String, Object> templateData) {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("USERNAME", HTMLEncoder.encode(username));
        substitutionMap.put("RECEIVER", sendTo);
        substitutionMap.put("ADAPTER_ID", adapterId);
        substitutionMap.put("PCV_ID", pcvId);
        substitutionMap.putAll(templateData);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", sendTo);
        config.put("com.pingidentity.notification.config.template.name", StringUtils.isNotBlank((String)emailTemplateName) ? emailTemplateName : "message-template-forgot-password-failed.html");
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        notificationDispatcher.dispatchNotification(notificationPublisherId, NotificationEventType.PASSWORD_RESET_FAILED.toString(), substitutionMap, config);
    }

    public void publishNotification(String notificationPublisher, String emailTemplateFile, String to, Map<String, Object> params, String eventType) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", to);
        config.put("com.pingidentity.notification.config.template.name", emailTemplateFile);
        notificationDispatcher.dispatchNotification(notificationPublisher, eventType, params, config);
    }

    public static NotificationSenderPluginInstance getNotificationPublisherForAuditLogDiff(String notificationPublisherId) {
        NotificationPublisherPluginManager notificationPublisherPluginMgr = NOTIFICATION_PUBLISHER_PLUGIN_MGR;
        if (notificationPublisherId == null) {
            return null;
        }
        NotificationSenderPluginInstance matchingPluginInstance = (NotificationSenderPluginInstance)notificationPublisherPluginMgr.getInstance(notificationPublisherId);
        if (matchingPluginInstance == null) {
            matchingPluginInstance = (NotificationSenderPluginInstance)notificationPublisherPluginMgr.getDefaultInstance();
            if (matchingPluginInstance != null) {
                matchingPluginInstance = NotificationSenderPluginInstance.createCopyForAuditLogging(matchingPluginInstance);
                matchingPluginInstance.setId(DEFAULT_ID);
            } else {
                return null;
            }
        }
        return matchingPluginInstance;
    }

    public static boolean isAdapterUsingPublisher(IdpAuthnAdapterInstance adapter, String notificationPublisherId) {
        Configuration configuration = adapter.getConfiguration();
        if (configuration != null) {
            String adapterPublisherId = configuration.getFieldValue("Notification Publisher");
            if (StringUtils.isNotBlank((String)adapterPublisherId) && adapterPublisherId.equals(notificationPublisherId)) {
                return true;
            }
            boolean enableUsernameRecovery = configuration.getBooleanFieldValue("Enable Username Recovery");
            boolean enablePasswordChangeEmailNotification = configuration.getBooleanFieldValue("Change Password Email Notification");
            String resetType = HtmlFormAdapterConfig.getConfigurationValue(configuration, "Password Reset Type", "NONE");
            if (enableUsernameRecovery || enablePasswordChangeEmailNotification || StringUtils.isNotBlank((String)resetType) && (resetType.equals("OTL") || resetType.equals("OTP"))) {
                return NotificationSupportHelper.isPluginUsingNotificationPublisher(adapterPublisherId, notificationPublisherId);
            }
        }
        return false;
    }

    public static boolean isLipUsingPublisher(LocalIdentityProfile lip, String notificationPublisherId) {
        EmailVerificationConfig emailVerificationConfig = lip.getEmailOwnershipVerificationConfig();
        if (emailVerificationConfig != null) {
            String lipNotificationPublisherId = emailVerificationConfig.getNotificationPublisherId();
            return emailVerificationConfig.isEmailVerificationEnabled() && NotificationSupportHelper.isPluginUsingNotificationPublisher(lipNotificationPublisherId, notificationPublisherId);
        }
        return false;
    }

    public static boolean isPluginUsingNotificationPublisher(String pluginPublisherId, String notificationPublisherId) {
        return NOTIFICATION_PUBLISHER_PLUGIN_MGR.isPluginUsingNotificationPublisher(pluginPublisherId, notificationPublisherId);
    }
}

