/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hivemind;

import com.pingidentity.hivemind.AutoReloadableServiceFactory;
import com.pingidentity.hivemind.AutoReloadableServiceProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.impl.ConstructableServicePoint;
import org.apache.hivemind.impl.servicemodel.AbstractServiceModelImpl;

public class AutoReloadableServiceModel
extends AbstractServiceModelImpl
implements AutoReloadableServiceFactory {
    private static final Log log = LogFactory.getLog(AutoReloadableServiceModel.class);
    private Object dynamicProxy;

    public AutoReloadableServiceModel(ConstructableServicePoint servicePoint) {
        super(servicePoint);
    }

    @Override
    public String getServiceId() {
        return this.getServicePoint().getExtensionPointId();
    }

    @Override
    public synchronized Object createServiceImplementation() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating impl for " + this.getServiceInterface().getSimpleName()));
        }
        Object result = this.constructServiceImplementation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished creating impl for " + this.getServiceInterface().getSimpleName()));
        }
        return result;
    }

    @Override
    public Class<?> getServiceInterface() {
        return this.getServicePoint().getServiceInterface();
    }

    public synchronized Object getService() {
        if (this.dynamicProxy == null) {
            AutoReloadableServiceProxy serviceProxy = new AutoReloadableServiceProxy(this);
            this.dynamicProxy = serviceProxy.createDynamicProxy();
        }
        return this.dynamicProxy;
    }

    public synchronized void instantiateService() {
    }
}

