/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hivemind;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.hivemind.AutoReloadableServiceFactory;
import com.pingidentity.hivemind.ServiceSetManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;

public class AutoReloadableServiceProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(AutoReloadableServiceProxy.class);
    private final AutoReloadableServiceFactory serviceFactory;
    private volatile Object singletonTarget;
    private final Reloadable serviceSetReloadable = () -> this.serviceSetReload();

    public AutoReloadableServiceProxy(AutoReloadableServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
        ServiceSetManager.getDefault().registerForReloadEvents(this.serviceSetReloadable);
    }

    public static <T> T makeProxy(final Class<T> anInterface, final Supplier<AutoReloadable> constructor) {
        final String id = IDGenerator.rndAlphaNumeric(25);
        AutoReloadableServiceFactory factory = new AutoReloadableServiceFactory(){

            @Override
            public String getServiceId() {
                return id;
            }

            @Override
            public Object createServiceImplementation() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating impl for " + this.getServiceInterface().getSimpleName() + "(" + id + ")"));
                }
                Object result = constructor.get();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Finished creating impl for " + this.getServiceInterface().getSimpleName() + "(" + id + ")"));
                }
                return result;
            }

            @Override
            public Class<?> getServiceInterface() {
                return anInterface;
            }
        };
        AutoReloadableServiceProxy proxy = new AutoReloadableServiceProxy(factory);
        return (T)proxy.createDynamicProxy();
    }

    public Object createDynamicProxy() {
        return Proxy.newProxyInstance(this.serviceFactory.getServiceInterface().getClassLoader(), new Class[]{this.serviceFactory.getServiceInterface()}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object target = this.getTarget();
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void serviceSetReload() {
        this.getTarget();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serviceFactory.getServiceId() + "]";
    }

    private Object getTarget() {
        if (this.singletonTarget != null) {
            return this.singletonTarget;
        }
        return ServiceSetManager.getDefault().getThreadServiceSet().getService(this.serviceFactory.getServiceId(), () -> this.makeServiceInstance());
    }

    private Object makeServiceInstance() {
        Object target = this.serviceFactory.createServiceImplementation();
        if (!(target instanceof AutoReloadable)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Service " + this.serviceFactory.getServiceId() + " tagged as autoreloadable in hivemodule but does not implement the AutoReloadable marker interface. A new instance will not be created during configuration reload."));
            }
            this.singletonTarget = target;
        }
        return target;
    }
}

