/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hivemind;

import com.pingidentity.configservice.AutoReloadable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.sourceid.config.ConfigurationException;

public class ServiceSet {
    private ConcurrentHashMap<String, ServiceReference> servicesById = new ConcurrentHashMap();

    public Object getService(String id, Supplier<Object> creationFunction) {
        ServiceReference serviceRef = this.servicesById.computeIfAbsent(id, key -> new ServiceReference(id));
        return serviceRef.get(creationFunction);
    }

    private static class ServiceReference {
        private volatile Object service;
        private boolean creating = false;
        private final String id;

        public ServiceReference(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"DC_PARTIALLY_CONSTRUCTED"}, justification="We deliberately expose the service reference before finishInit() is called, to prevent circular init dependencies")
        public Object get(Supplier<Object> creationFunction) {
            Object localRef = this.service;
            if (localRef == null) {
                ServiceReference serviceReference = this;
                synchronized (serviceReference) {
                    localRef = this.service;
                    if (localRef == null) {
                        if (this.creating) {
                            throw new ConfigurationException("Circular initialization dependency for service with id " + this.id);
                        }
                        this.creating = true;
                        try {
                            this.service = creationFunction.get();
                        }
                        finally {
                            this.creating = false;
                        }
                        localRef = this.service;
                        if (localRef instanceof AutoReloadable) {
                            ((AutoReloadable)localRef).finishInit();
                        }
                    }
                }
            }
            return localRef;
        }
    }
}

