/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hsm;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.BcFipsConcatKeyDerivationFunctionWithSha256;
import com.pingidentity.hsm.HSMStarter;
import com.pingidentity.pingcommons.bcfips.HybridSecureRandom;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class BCFIPSStarter
extends HSMStarter {
    private Mode mode = Mode.SERVER;
    private static final String BCFIPS_PROVIDER_NAME = "BCFIPS";
    private static final String BCFIPS_JSSE_PROVIDER_NAME = "BCJSSE";
    private static final String[] DEFAULT_ALLOWED_PROVIDER_CLASS_NAMES = new String[]{"org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider", "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", "com.sun.net.ssl.internal.ssl.Provider", "sun.security.provider.Sun", "sun.security.jgss.SunProvider", "com.sun.security.sasl.Provider", "sun.security.provider.certpath.ldap.JdkLDAP", "com.sun.security.sasl.gsskerb.JdkSASL", "sun.security.pkcs11.SunPKCS11", "sun.security.rsa.SunRsaSign"};
    private static Logger bouncyCastleProviderLogger;

    public BCFIPSStarter(Log log) {
        super(log);
    }

    public static BCFIPSStarter forCommandLineUtility() {
        BCFIPSStarter bcfipsStarter = new BCFIPSStarter(LogFactory.getLog(BCFIPSStarter.class));
        bcfipsStarter.mode = Mode.COMMAND_LINE_UTILITY;
        return bcfipsStarter;
    }

    public static BCFIPSStarter forUpgradeUtility() {
        BCFIPSStarter bcfipsStarter = new BCFIPSStarter(LogFactory.getLog(BCFIPSStarter.class));
        bcfipsStarter.mode = Mode.UPGRADE_UTILITY;
        return bcfipsStarter;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void start() {
        System.setProperty("org.jose4j.jwe.kdf.ConcatenationKeyDerivationFunctionWithSha256", BcFipsConcatKeyDerivationFunctionWithSha256.class.getName());
        System.setProperty("org.bouncycastle.rsa.allow_multi_use", "true");
        if (!PropertyInfo.isFipsAllowUnapprovedAlgorithms()) {
            System.setProperty("org.bouncycastle.fips.approved_only", "true");
        }
        Security.setProperty("ssl.KeyManagerFactory.algorithm", "PKIX");
        Security.setProperty("ssl.TrustManagerFactory.algorithm", "PKIX");
        System.setProperty("jsse.enableSNIExtension", "true");
        System.setProperty("pf.fips.mode", "true");
        bouncyCastleProviderLogger = Logger.getLogger("org.bouncycastle.jsse");
        bouncyCastleProviderLogger.setLevel(Level.SEVERE);
        this.updateProviderList();
    }

    private void updateProviderList() {
        if (PropertyInfo.isFipsRemoveNonessentialProviders()) {
            Provider[] providers = Security.getProviders();
            ArrayList<Provider> providersToRemove = new ArrayList<Provider>();
            List<String> allowedProviderClassNames = this.getAllowedProviderClassNames();
            for (Provider provider : providers) {
                if (allowedProviderClassNames.contains(provider.getClass().getName())) continue;
                providersToRemove.add(provider);
            }
            for (Provider provider : providersToRemove) {
                Security.removeProvider(provider.getName());
            }
        }
        HybridSecureRandom.install((SecureRandom)new HybridSecureRandom.Builder().reseedInterval(PropertyInfo.getFipsSecureRandomReseedInterval()).build());
        BouncyCastleFipsProvider bcfipsProvider = new BouncyCastleFipsProvider();
        Security.removeProvider(BCFIPS_PROVIDER_NAME);
        Security.insertProviderAt((Provider)bcfipsProvider, 1);
        String bcJsseConfig = PropertyInfo.isFipsAllowUnapprovedAlgorithms() ? BCFIPS_PROVIDER_NAME : "fips:BCFIPS";
        BouncyCastleJsseProvider bcJsseProvider = new BouncyCastleJsseProvider(bcJsseConfig);
        Security.removeProvider(BCFIPS_JSSE_PROVIDER_NAME);
        Security.insertProviderAt((Provider)bcJsseProvider, 2);
        if (this.mode == Mode.SERVER) {
            this.log.info((Object)"=========================================================================");
        }
        String message = String.format("BCFIPS mode enabled. Provider version: %s%nBCTLS-TLS Provider version: %s", bcfipsProvider.getVersionStr(), bcJsseProvider.getVersionStr());
        if (this.mode == Mode.SERVER || this.mode == Mode.COMMAND_LINE_UTILITY) {
            this.log.info((Object)message);
        }
        if (this.mode == Mode.COMMAND_LINE_UTILITY) {
            System.out.println(message);
        }
        if (this.mode == Mode.SERVER) {
            Provider[] providers;
            this.log.info((Object)"");
            this.log.info((Object)"Updated provider list:");
            this.log.info((Object)"");
            for (Provider provider : providers = Security.getProviders()) {
                this.log.info((Object)(provider.getName() + " (" + provider.getClass().getName() + ")"));
            }
            this.log.info((Object)"=========================================================================");
        }
    }

    private List<String> getAllowedProviderClassNames() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(DEFAULT_ALLOWED_PROVIDER_CLASS_NAMES));
        result.addAll(this.getAdditionalAllowedProviders());
        return result;
    }

    private List<String> getAdditionalAllowedProviders() {
        String[] providerClassNames;
        String additionalAllowedProvidersProp = PropertyInfo.getFipsAdditionalAllowedProviders();
        if (additionalAllowedProvidersProp == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String providerClassName : providerClassNames = additionalAllowedProvidersProp.split(",")) {
            String trimmed = providerClassName.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }

    private static enum Mode {
        SERVER,
        COMMAND_LINE_UTILITY,
        UPGRADE_UTILITY;

    }
}

