/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hsm;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.hsm.BCFIPSStarter;
import com.pingidentity.hsm.CloudHSMStarter;
import com.pingidentity.hsm.LunaStarter;
import com.pingidentity.hsm.NCipherStarter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.pingidentity.utils.EnvironmentVariableUtil;
import org.sourceid.saml20.util.SystemUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class HSMStarter {
    private static final String SUN_JCE_MANAGER = "com.pingidentity.crypto.SunJCEManager";
    private static final String CERTIFICATE_SERVICE_IMPL = "com.pingidentity.crypto.CertificateServiceImpl";
    protected Log log;
    private boolean tls13Disabled = false;
    protected static final String BORDER = "=========================================================================";

    public HSMStarter(Log log) {
        this.log = log;
    }

    public abstract void start() throws Exception;

    public void testConfiguration() throws Exception {
        String hivemoduleXmlPath = System.getProperty("pf.home") + "/server/default/conf/META-INF/hivemodule.xml";
        File hivemoduleXmlFile = new File(hivemoduleXmlPath);
        if (hivemoduleXmlFile.exists()) {
            this.testHivemoduelXmlConfiguration(hivemoduleXmlFile);
        } else {
            this.testServicePointsConfConfiguration();
        }
    }

    private void testHivemoduelXmlConfiguration(File hivemoduleXmlFile) throws Exception {
        DocumentBuilder builder = XmlBeansUtil.getDocumentBuilder();
        try (FileInputStream file = new FileInputStream(hivemoduleXmlFile);){
            Document xmlDocument = builder.parse(file);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String sunJCEExpr = "/module/service-point[@id='JCEManager']/invoke-factory/construct[@class='com.pingidentity.crypto.SunJCEManager']";
            String certServiceExpr = "/module/service-point[@id='CertificateService']/invoke-factory/construct[@class='com.pingidentity.crypto.CertificateServiceImpl']";
            Node sunJCENode = (Node)xPath.compile(sunJCEExpr).evaluate(xmlDocument, XPathConstants.NODE);
            Node certServiceNode = (Node)xPath.compile(certServiceExpr).evaluate(xmlDocument, XPathConstants.NODE);
            if (sunJCENode != null || certServiceNode != null) {
                SystemUtil.hardShutdown("PF is running in HSM mode.  Please ensure that the service points \"JCEManager\" and \"CertificateService\" is configured properly in " + hivemoduleXmlFile.getAbsolutePath());
            }
        }
    }

    private void testServicePointsConfConfiguration() throws Exception {
        String servicePointsConfPath = System.getProperty("pf.home") + "/server/default/conf/service-points.conf";
        File servicePointsConfFile = new File(servicePointsConfPath);
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(servicePointsConfFile.toPath(), new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            EnvironmentVariableUtil.loadPropertyWithEnvVar((Properties)properties, (Reader)reader, (String)"service-points.conf");
        }
        String jceManagerServicePoint = "jce.manager";
        String certificateServiceServicePoint = "certificate.service";
        if (SUN_JCE_MANAGER.equals(properties.getProperty(jceManagerServicePoint)) || CERTIFICATE_SERVICE_IMPL.equals(properties.getProperty(certificateServiceServicePoint))) {
            SystemUtil.hardShutdown("PF is running in HSM mode.  Please ensure that the service points \"" + jceManagerServicePoint + "\" and \"" + certificateServiceServicePoint + "\" is configured properly in " + servicePointsConfPath);
        }
    }

    public static HSMStarter getInstance(PropertyInfo.HSM_MODE key, Log log) throws Exception {
        switch (key) {
            case AWSCLOUDHSM: {
                return new CloudHSMStarter(log);
            }
            case LUNA: {
                return new LunaStarter(log);
            }
            case NCIPHER: {
                return new NCipherStarter(log);
            }
            case BCFIPS: {
                return new BCFIPSStarter(log);
            }
            case OFF: {
                return null;
            }
        }
        throw new Exception("Unrecognized HSM Mode");
    }

    public boolean isTls13Disabled() {
        return this.tls13Disabled;
    }

    protected void checkDisableTLS13AndRSASSAPSS() {
        this.checkDisableTLS13AndRSASSAPSS(false);
    }

    protected void checkDisableTLS13AndRSASSAPSS(boolean disableByDefault) {
        if (!PropertyInfo.isHSMEnableTLSv1_3((!disableByDefault ? 1 : 0) != 0)) {
            String disabledAlgorithms = Security.getProperty("jdk.tls.disabledAlgorithms") + ", RSASSA-PSS, TLSv1.3";
            Security.setProperty("jdk.tls.disabledAlgorithms", disabledAlgorithms);
            this.tls13Disabled = true;
        }
    }

    protected void updateProviderList(Provider securityProvider) {
        Provider[] providers;
        int sunJcePosition = -1;
        Provider[] initialProviders = Security.getProviders();
        for (int i = 0; i < initialProviders.length; ++i) {
            if (!"SunJCE".equals(initialProviders[i].getName())) continue;
            sunJcePosition = i + 1;
            break;
        }
        if (sunJcePosition < 0) {
            SystemUtil.hardShutdown("The SunJCE security provider could not be found.");
        }
        Security.insertProviderAt(securityProvider, sunJcePosition + 1);
        this.log.info((Object)"");
        this.log.info((Object)"Updated provider list:");
        this.log.info((Object)"");
        for (Provider provider : providers = Security.getProviders()) {
            this.log.info((Object)(provider.getName() + " (" + provider.getClass().getName() + ")"));
        }
        this.log.info((Object)BORDER);
    }
}

