/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hsm;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.PasswordFile;
import com.pingidentity.crypto.luna.AbstractLunaFactory;
import com.pingidentity.crypto.luna.LunaFactory;
import com.pingidentity.crypto.luna.type.LunaManagerType;
import com.pingidentity.hsm.HSMStarter;
import java.io.File;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.sourceid.saml20.util.SystemUtil;

public class LunaStarter
extends HSMStarter {
    public LunaStarter(Log log) {
        super(log);
    }

    @Override
    public void start() {
        Provider provider = Security.getProvider("LunaProvider");
        if (provider == null) {
            if (PropertyInfo.isHSMUpdateProviderList()) {
                try {
                    Class<?> providerClass = Class.forName("com.safenetinc.luna.provider.LunaProvider");
                    provider = (Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.updateProviderList(provider);
                }
                catch (Exception e) {
                    SystemUtil.hardShutdown("Could not get LunaProvider from the JVM to update provider list.", e);
                }
            } else {
                SystemUtil.hardShutdown("Could not get LunaProvider from the JVM.");
            }
        }
        if (provider != null) {
            this.log.info((Object)String.format("Luna mode detected. LunaProvider version %s.", provider.getVersionStr()));
        }
        this.checkDisableTLS13AndRSASSAPSS();
        String hsmDataDirPath = PropertyInfo.getHsmDataDirPath();
        File dataDir = new File(hsmDataDirPath);
        if (dataDir.exists()) {
            if (LunaFactory.isLuna()) {
                this.log.info((Object)"Running Luna");
            }
            AbstractLunaFactory lunaFactory = LunaFactory.getInstance();
            LunaManagerType lunaMgr = null;
            if (lunaFactory != null) {
                this.log.info((Object)"Getting Luna Slot Manager.");
                lunaMgr = lunaFactory.createLunaSlotManager();
            }
            if (lunaMgr != null) {
                this.log.info((Object)"Logging into Luna");
                try {
                    lunaMgr.login(PasswordFile.getAndDeobfuscateHSMPassword(hsmDataDirPath));
                    this.log.info((Object)"Successfully logged into Luna.");
                }
                catch (ProviderException ex) {
                    SystemUtil.hardShutdown("Could not log into the Luna partition: " + ex.getMessage());
                }
                catch (Exception ex) {
                    SystemUtil.hardShutdown(ex.getMessage(), ex);
                }
                lunaMgr.setSecretKeysExtractable(true);
            } else {
                SystemUtil.hardShutdown("LunaTokenManager not available");
            }
        } else {
            this.log.info((Object)("directory doesn't exist " + hsmDataDirPath));
        }
    }
}

