/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jdbc;

import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.ConnectionListener;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.LocalSettingsListener;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.service.session.data.SessionStorageManager;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.license.LicenseManager;

public final class WarningsForHsqlDb
implements ConnectionListener,
LocalSettingsListener {
    private static final Log log = LogFactory.getLog(WarningsForHsqlDb.class);
    private static final String OAUTH_CLIENTS = "OAuth clients";
    private static final String OAUTH_PERSISTENT_ACCESS_GRANTS = "OAuth persistent access grants";
    private static final String PERSISTENT_AUTHENTICATION_SESSIONS = "persistent authentication sessions";
    private static final String ACCOUNT_LINKING = "account linking";
    private static final String OUTBOUND_PROVISIONING = "outbound provisioning";
    private static final String WARNING_MSG = "Use the built-in HSQLDB only in trial or training environments. Always use secured external storage in testing and production environments for: ";
    private static final WarningsForHsqlDb INSTANCE;
    private final boolean isStandalone;
    private final boolean isConsole;
    private final Set<String> idpConnectionAccountLinkingIds = ConcurrentHashMap.newKeySet();
    private final Set<String> spConnectionOutboundProvisioningIds = ConcurrentHashMap.newKeySet();

    private WarningsForHsqlDb(boolean isConsole, boolean isStandalone) {
        this.isConsole = isConsole;
        this.isStandalone = isStandalone;
    }

    public static WarningsForHsqlDb getInstance() {
        return INSTANCE;
    }

    public List<String> getWarningAreas() {
        if (this.isStandalone) {
            return Collections.emptyList();
        }
        LinkedList<String> warnings = new LinkedList<String>();
        if (this.isConsole && this.hasAccountLinkingWarning()) {
            warnings.add(ACCOUNT_LINKING);
        }
        if (LicenseManager.getLicense().isFeatureEnabled("OAuth")) {
            if (this.hasOauthClientsWarning()) {
                warnings.add(OAUTH_CLIENTS);
            }
            if (this.hasOauthPersistentAccessGrantsWarning()) {
                warnings.add(OAUTH_PERSISTENT_ACCESS_GRANTS);
            }
        }
        if (this.isConsole && LicenseManager.getLicense().isFeatureEnabled("SaasProvisioning") && this.hasOutboundProvisioningWarning()) {
            warnings.add(OUTBOUND_PROVISIONING);
        }
        if (this.hasPersistentAuthnSessionsWarning()) {
            warnings.add(PERSISTENT_AUTHENTICATION_SESSIONS);
        }
        return warnings;
    }

    public void logWarningsForHsqlDbUse() {
        List<String> warnings = this.getWarningAreas();
        if (!warnings.isEmpty()) {
            log.warn((Object)(WARNING_MSG + String.join((CharSequence)", ", warnings)));
        }
    }

    void updateConnectionUsageInfo(ConnectionBase connection, boolean isDeleted) {
        if (!this.isConsole || this.isStandalone) {
            return;
        }
        if (connection.getRoleType() == Role.IDP) {
            if (isDeleted || !((IdpConnection)connection).doAccountLinking()) {
                this.idpConnectionAccountLinkingIds.remove(connection.getId());
            } else {
                this.idpConnectionAccountLinkingIds.add(connection.getId());
            }
        } else if (connection.getRoleType() == Role.SP) {
            if (isDeleted || !connection.hasModuleConfiguration("SaasProvisioner")) {
                this.spConnectionOutboundProvisioningIds.remove(connection.getId());
            } else {
                this.spConnectionOutboundProvisioningIds.add(connection.getId());
            }
        }
    }

    public void reloadConnectionUsageInfo() {
        if (!this.isConsole || this.isStandalone) {
            return;
        }
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        this.idpConnectionAccountLinkingIds.clear();
        this.idpConnectionAccountLinkingIds.addAll(connectionManager.getAllIdpConnections().stream().filter(IdpConnection::doAccountLinking).map(ConfigAbstract::getId).collect(Collectors.toSet()));
        this.spConnectionOutboundProvisioningIds.clear();
        this.spConnectionOutboundProvisioningIds.addAll(connectionManager.getAllSpConnections().stream().filter(sp -> sp.hasModuleConfiguration("SaasProvisioner")).map(ConfigAbstract::getId).collect(Collectors.toSet()));
    }

    boolean hasOauthClientsWarning() {
        ClientManager clientManager = MgmtFactory.getClientManager();
        return clientManager.isDataSourceInUse("PFDefaultDS");
    }

    boolean hasOauthPersistentAccessGrantsWarning() {
        AccessGrantManager accessGrantManager = MgmtFactory.getAccessGrantManager();
        if (accessGrantManager.isDataSourceInUse("PFDefaultDS")) {
            ClientManager clientManager = MgmtFactory.getClientManager();
            return clientManager.isBackendDatabase() || clientManager.getClientCount() > 0;
        }
        return false;
    }

    boolean hasPersistentAuthnSessionsWarning() {
        SessionStorageManager sessionStorageManager = StateMgmtFactory.getSessionStorageManager();
        if (sessionStorageManager.isDataSourceInUse("PFDefaultDS")) {
            AuthnSessionPolicyManager authnSessionPolicyManager = MgmtFactory.getAuthnSessionPolicyManager();
            return authnSessionPolicyManager.isAnyStoredSessionEnabled();
        }
        return false;
    }

    boolean hasAccountLinkingWarning() {
        AccountLinkingService accountLinkingService = MgmtFactory.getAccountLinkingService();
        return accountLinkingService.isDataSourceInUse("PFDefaultDS") && !this.idpConnectionAccountLinkingIds.isEmpty();
    }

    boolean hasOutboundProvisioningWarning() {
        ConnectionModuleGlobalConfiguration outboundProvisioning = MetadataLocalHelper.getOutboundProvisioning();
        return outboundProvisioning != null && "ProvisionerDS".equals(outboundProvisioning.getInternalDataSourceId()) && !this.spConnectionOutboundProvisioningIds.isEmpty();
    }

    private void registerListeners() {
        if (!this.isConsole || this.isStandalone) {
            return;
        }
        MgmtFactory.getLocalSettingsManager().addSettingsListener(this);
        MgmtFactory.getConnectionManager().addConnectionListener(this);
    }

    @Override
    public void onConnectionSaved(ConnectionBase connection, boolean newConnection) {
        this.updateConnectionUsageInfo(connection, false);
        this.logWarningsForHsqlDbUse();
    }

    @Override
    public void onConnectionDeleted(ConnectionBase connection) {
        this.updateConnectionUsageInfo(connection, true);
        this.logWarningsForHsqlDbUse();
    }

    @Override
    public void onLocalSettingsSaved(LocalSettings settings) {
        this.logWarningsForHsqlDbUse();
    }

    static {
        Mediator mediator = MgmtFactory.getMediator();
        INSTANCE = new WarningsForHsqlDb(mediator.isConsole(), mediator.isStandalone());
        INSTANCE.reloadConnectionUsageInfo();
        INSTANCE.registerListeners();
    }
}

