/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups;

import com.pingidentity.jgroups.JGUtil;
import com.pingidentity.jgroups.MapRpcTargetInterface;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.ReplicatedHashMap;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.IpAddress;
import org.sourceid.saml20.state.StateAccepter;

public class DistributedMap<K, V>
extends ReplicatedHashMap<K, V>
implements MapRpcTargetInterface<K, V>,
StateAccepter {
    DistributedMap(JChannel channel) {
        super(channel);
        this.disp = null;
        super.setBlockingUpdates(true);
    }

    void setRpcDispatcher(RpcDispatcher dispatcher) {
        this.disp = dispatcher;
        final HashMap<Short, Method> methods = new HashMap<Short, Method>(8);
        try {
            Class<MapRpcTargetInterface> targetInterface = MapRpcTargetInterface.class;
            methods.put((short)1, targetInterface.getMethod("_put", Object.class, Object.class));
            methods.put((short)3, targetInterface.getMethod("_putAll", Map.class));
            methods.put((short)4, targetInterface.getMethod("_remove", Object.class));
            methods.put((short)8, targetInterface.getMethod("_clear", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return (Method)methods.get(id);
            }
        });
    }

    public void addNotificationListener(ReplicatedHashMap.Notification n) {
        this.log.debug("Adding Notification callback: " + n);
        super.addNotifier(n);
    }

    public void removeNotificationListener(ReplicatedHashMap.Notification n) {
        super.removeNotifier(n);
    }

    public String getLocalIpAddressString() {
        IpAddress localAddr = (IpAddress)super.getLocalAddress();
        InetAddress inetAddr = localAddr.getIpAddress();
        return inetAddr.getHostAddress();
    }

    public boolean isLeadDog() {
        return JGUtil.isLead(this.getChannel());
    }

    public void setState(DistributedMap other) {
        super._putAll((Map)((Object)other));
    }

    @Override
    public synchronized void _putAll(Map map) {
        super._putAll(map);
    }

    public synchronized void putAll(Map m) {
        super.putAll(m);
    }

    public synchronized V put(K key, V value) {
        return (V)super.put(key, value);
    }

    @Override
    public synchronized V _put(K key, V value) {
        return (V)super._put(key, value);
    }

    public synchronized boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public synchronized int size() {
        return super.size();
    }

    public synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    public synchronized V remove(Object key) {
        return (V)super.remove(key);
    }

    @Override
    public synchronized V _remove(K key) {
        return (V)super._remove(key);
    }

    public synchronized V get(Object key) {
        return (V)super.get(key);
    }

    public synchronized void clear() {
        super.clear();
    }

    @Override
    public void _clear() {
        super._clear();
    }

    @Override
    public void setState(StateAccepter other) {
        this.setState((DistributedMap)other);
    }
}

