/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public class JGUtil {
    private static final Log log = LogFactory.getLog(JGUtil.class);

    public static boolean isLead(JChannel c) {
        View view = c.getView();
        List members = null;
        if (view != null) {
            members = view.getMembers();
        } else {
            log.info((Object)("Channel " + c + " returned empty view."));
        }
        Address localAddress = c.getAddress();
        return members != null && !members.isEmpty() && ((Address)members.get(0)).equals(localAddress);
    }

    public static int getViewSize(JChannel c) {
        View view = c.getView();
        return view == null ? 0 : view.size();
    }

    public static boolean isTcpBasedStack(JChannel c) {
        JChannel jChannel = c;
        ProtocolStack protocolStack = jChannel.getProtocolStack();
        List protocols = protocolStack.getProtocols();
        Protocol transportProtocol = (Protocol)protocols.get(protocols.size() - 1);
        return transportProtocol instanceof BasicTCP;
    }
}

