/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups;

import com.pingidentity.aws.AWSPermissionsError;
import com.pingidentity.crypto.jwk.GroupRpcJsonWebKeysAdder;
import com.pingidentity.crypto.jwk.JwkState;
import com.pingidentity.jgroups.ChannelFactory;
import com.pingidentity.jgroups.DistributedMap;
import com.pingidentity.jgroups.DistributedMapLogNotifListener;
import com.pingidentity.jgroups.MapRpcTargetInterface;
import com.pingidentity.jgroups.ProxyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.StateListener;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTracker;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTrackerMemoryImpl;
import org.sourceid.saml20.domain.mgmt.impl.CollectSupportDataManagerImpl;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.IdpSessionRegistry;
import org.sourceid.saml20.service.SpSessionRegistry;
import org.sourceid.saml20.service.impl.cookie.KeyTrackerGroupRpcImpl;
import org.sourceid.saml20.service.impl.cookie.KeyTrackerState;
import org.sourceid.saml20.service.impl.grouprpc.AccountLockingServiceRpcHandler;
import org.sourceid.saml20.service.impl.grouprpc.AdminNodeRoleServiceGroupRpcImpl;
import org.sourceid.saml20.service.impl.grouprpc.ArtifactPersistenceSvcGroupRpcEncodedNodeIdxImpl;
import org.sourceid.saml20.service.impl.grouprpc.ConfigReplicationServiceGroupRpcImpl;
import org.sourceid.saml20.service.impl.grouprpc.ConfigSynchronizationServiceGroupRpcImpl;
import org.sourceid.saml20.service.impl.grouprpc.InterRequestStateMgmtGroupRpcImpl;
import org.sourceid.saml20.service.impl.grouprpc.LockingServiceRpcTarget;
import org.sourceid.saml20.service.impl.grouprpc.NodeIndexRegistryGroupRpcImpl;
import org.sourceid.saml20.service.impl.grouprpc.SessionRevocationServiceGroupRpcImpl;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.DistributedStateCoordinatorImpl;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockClient;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockClientRpcs;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockServer;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockServerRpcs;
import org.sourceid.saml20.service.impl.localmemory.AssertionReplayPreventionSvcInMemoryImpl;
import org.sourceid.saml20.service.impl.localmemory.IdpSessionRegistryMapImpl;
import org.sourceid.saml20.service.impl.localmemory.InterReqStateMgmtMapImpl;
import org.sourceid.saml20.service.impl.localmemory.SessionRevocationServiceMapImpl;
import org.sourceid.saml20.service.impl.localmemory.SpSessionRegistryMapImpl;
import org.sourceid.saml20.state.StateAccepter;
import org.sourceid.saml20.util.SystemUtil;

public class MuxRpcDispatcherMgr
implements MembershipListener,
StateListener,
ChannelListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private final RpcDispatcher rpcDispatcher;
    private HashMap<Class, Object> targets = new HashMap();
    private DistributedMap distributedMap;
    private static final MuxRpcDispatcherMgr muxRpcDispatcherMgr = new MuxRpcDispatcherMgr();
    private volatile Boolean setStateResult = null;
    private Collection<MembershipListener> membershipListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private Collection<ChannelListener> channelListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    private MuxRpcDispatcherMgr() {
        ChannelFactory cf = ChannelFactory.getDefaultFactory();
        JChannel channel = cf.getChannel();
        channel.addChannelListener((ChannelListener)this);
        this.targets.put(GroupRpcJsonWebKeysAdder.JwksRpcTarget.class, new JwkState());
        this.targets.put(KeyTrackerGroupRpcImpl.RpcTarget.class, new KeyTrackerState());
        this.targets.put(NodeIndexRegistryGroupRpcImpl.RpcTarget.class, new NodeIndexRegistryGroupRpcImpl.Registry());
        InterReqStateMgmtMapImpl interReqStateMgmtMapImpl = new InterReqStateMgmtMapImpl();
        this.targets.put(InterRequestStateMgmtGroupRpcImpl.RpcTarget.class, interReqStateMgmtMapImpl);
        IdpSessionRegistryMapImpl idpSessionRegistryMapImpl = new IdpSessionRegistryMapImpl();
        this.targets.put(IdpSessionRegistry.class, idpSessionRegistryMapImpl);
        SpSessionRegistryMapImpl spSessionRegistryMapImpl = new SpSessionRegistryMapImpl();
        this.targets.put(SpSessionRegistry.class, spSessionRegistryMapImpl);
        this.targets.put(AssertionReplayPreventionService.class, new AssertionReplayPreventionSvcInMemoryImpl(2000L, true));
        this.targets.put(ArtifactPersistenceService.class, new ArtifactPersistenceSvcGroupRpcEncodedNodeIdxImpl.LoggingMapImpl());
        this.targets.put(ReferenceBearerAccessTokenTracker.class, new ReferenceBearerAccessTokenTrackerMemoryImpl());
        this.targets.put(SessionRevocationServiceGroupRpcImpl.RpcTarget.class, new SessionRevocationServiceMapImpl());
        this.targets.put(ConfigReplicationServiceGroupRpcImpl.RpcTarget.class, new ConfigReplicationServiceGroupRpcImpl.ReplicationRequestHandler());
        this.targets.put(ConfigSynchronizationServiceGroupRpcImpl.RpcTarget.class, new ConfigSynchronizationServiceGroupRpcImpl.SynchronizationRequestHandler());
        this.targets.put(AdminNodeRoleServiceGroupRpcImpl.RpcTarget.class, new AdminNodeRoleServiceGroupRpcImpl.AdminNodeRoleRequestHandler());
        this.targets.put(LockingServiceRpcTarget.class, new AccountLockingServiceRpcHandler());
        this.targets.put(DistributedStateCoordinatorImpl.RpcTarget.class, new DistributedStateCoordinatorImpl.DistributedStateCoordinatorRpcTarget(interReqStateMgmtMapImpl, idpSessionRegistryMapImpl, spSessionRegistryMapImpl));
        this.targets.put(CollectSupportDataManagerImpl.RpcTarget.class, new CollectSupportDataManagerImpl.CsdRequestHandler());
        ClusterLockClient lockClient = new ClusterLockClient();
        this.targets.put(ClusterLockClientRpcs.class, lockClient);
        ClusterLockServer lockServer = new ClusterLockServer();
        this.targets.put(ClusterLockServerRpcs.class, lockServer);
        this.distributedMap = new DistributedMap(channel);
        DistributedMapLogNotifListener notif = new DistributedMapLogNotifListener();
        this.distributedMap.addNotificationListener(notif);
        this.targets.put(MapRpcTargetInterface.class, this.distributedMap);
        Object targetsMuxProxy = ProxyFactory.createProxy(this.targets);
        this.rpcDispatcher = new RpcDispatcher(channel, targetsMuxProxy);
        this.rpcDispatcher.setMembershipListener((MembershipListener)this);
        this.rpcDispatcher.setStateListener((StateListener)this);
        this.distributedMap.setRpcDispatcher(this.rpcDispatcher);
        lockClient.initializeClustering(this, this.rpcDispatcher);
        lockServer.initializeClustering(this, this.rpcDispatcher);
        this.addMembershipListener((MembershipListener)this.distributedMap);
        try {
            cf.connect(channel);
        }
        catch (AWSPermissionsError e) {
            SystemUtil.hardShutdown("Unable to connect to cluster channel!", null);
        }
        catch (Exception e) {
            SystemUtil.hardShutdown("Unable to connect to cluster channel!", e);
        }
    }

    public static MuxRpcDispatcherMgr getMgr() {
        return muxRpcDispatcherMgr;
    }

    public Object getRpcInvocationTarget(Class interfaceClass) {
        return this.targets.get(interfaceClass);
    }

    public RpcDispatcher getRpcDispatcher() {
        return this.rpcDispatcher;
    }

    public DistributedMap getDistributedMap() {
        return this.distributedMap;
    }

    public boolean retrieveState() {
        int timeout = 20000;
        this.setStateResult = null;
        this.log.debug((Object)"about to attempt to retrieve state by calling getState on the cluster channel");
        JChannel channel = this.rpcDispatcher.getChannel();
        boolean retrievedState = false;
        try {
            if (channel.isConnected()) {
                List members = channel.getView().getMembers();
                if (members == null || !members.isEmpty() && ((Address)members.get(0)).equals(channel.getAddress())) {
                    this.log.info((Object)"state was not retrieved (likely the first member)");
                } else {
                    channel.getState(null, (long)timeout);
                    if (this.setStateResult == null) {
                        this.log.error((Object)"channel.getState() returned but setState() never got called");
                    } else {
                        retrievedState = this.setStateResult;
                        this.log.info((Object)("setState() was called, result=" + retrievedState));
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to retrieve initial state from the cluster", (Throwable)e);
        }
        return retrievedState;
    }

    public void addMembershipListener(MembershipListener listener) {
        this.membershipListeners.add(listener);
    }

    public void viewAccepted(View new_view) {
        this.log.info((Object)("viewAccepted:" + new_view));
        for (MembershipListener listener : this.membershipListeners) {
            listener.viewAccepted(new_view);
        }
    }

    public void suspect(Address suspected_mbr) {
        this.log.info((Object)("suspect:" + suspected_mbr));
        for (MembershipListener listener : this.membershipListeners) {
            listener.suspect(suspected_mbr);
        }
    }

    public void block() {
        this.log.info((Object)"block");
        for (MembershipListener listener : this.membershipListeners) {
            listener.block();
        }
    }

    public void unblock() {
        this.log.info((Object)"unblock");
        for (MembershipListener listener : this.membershipListeners) {
            listener.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream arg0) throws Exception {
        this.log.debug((Object)"getState() was called");
        try {
            ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream(8192);
            ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutStream);
            this.write(oos, this.targets.get(KeyTrackerGroupRpcImpl.RpcTarget.class));
            this.write(oos, this.targets.get(NodeIndexRegistryGroupRpcImpl.RpcTarget.class));
            this.write(oos, this.targets.get(GroupRpcJsonWebKeysAdder.JwksRpcTarget.class));
            HashMap copyOfDistMap = new HashMap();
            DistributedMap distributedMap = this.distributedMap;
            synchronized (distributedMap) {
                copyOfDistMap.putAll(this.distributedMap);
            }
            this.write(oos, copyOfDistMap);
            byte[] bytes = byteArrayOutStream.toByteArray();
            this.log.debug((Object)("getState() returning " + this.safeLengthToString(bytes) + " bytes"));
            arg0.write(bytes);
        }
        catch (Exception e) {
            this.log.error((Object)"exception marshalling state.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(ObjectOutputStream oos, Object obj) throws IOException {
        Object object = obj;
        synchronized (object) {
            this.log.debug((Object)("getState() serializing " + obj));
            oos.writeObject(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream state) throws Exception {
        try {
            if (state == null) {
                this.log.warn((Object)"state was null");
                return;
            }
            this.log.debug((Object)"setState() called");
            ObjectInputStream ois = new ObjectInputStream(state);
            this.readAndSet(ois, KeyTrackerGroupRpcImpl.RpcTarget.class);
            this.readAndSet(ois, NodeIndexRegistryGroupRpcImpl.RpcTarget.class);
            this.readAndSet(ois, GroupRpcJsonWebKeysAdder.JwksRpcTarget.class);
            Map copy = (Map)ois.readObject();
            this.log.debug((Object)("setState() deserializing state: shared map " + copy));
            DistributedMap distributedMap = this.distributedMap;
            synchronized (distributedMap) {
                this.distributedMap._putAll(copy);
            }
            this.setStateResult = true;
        }
        catch (Exception e) {
            this.setStateResult = false;
            this.log.error((Object)"exception unmarshalling state.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readAndSet(ObjectInputStream ois, Class targetInterface) throws IOException, ClassNotFoundException {
        StateAccepter stateAccepter;
        Object o = ois.readObject();
        this.log.debug((Object)("setState() deserializing state: " + o));
        StateAccepter stateAccepter2 = stateAccepter = (StateAccepter)this.targets.get(targetInterface);
        synchronized (stateAccepter2) {
            stateAccepter.setState((StateAccepter)o);
        }
    }

    private String safeLengthToString(byte[] bytes) {
        return bytes == null ? "null" : String.valueOf(bytes.length);
    }

    public void addChannelListener(ChannelListener listener) {
        this.channelListeners.add(listener);
    }

    public void channelConnected(JChannel channel) {
        this.log.info((Object)("Channel Connected! My local address: " + channel.getAddress() + " channel view: " + channel.getView()));
        for (ChannelListener listener : this.channelListeners) {
            listener.channelConnected(channel);
        }
    }

    public void channelDisconnected(JChannel channel) {
        this.log.info((Object)"Channel Disconnected!");
        for (ChannelListener listener : this.channelListeners) {
            listener.channelDisconnected(channel);
        }
    }

    public void channelClosed(JChannel channel) {
        this.log.info((Object)"Channel Closed!");
        for (ChannelListener listener : this.channelListeners) {
            listener.channelClosed(channel);
        }
    }
}

