/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups.org.jgroups;

import com.pingidentity.common.util.Substituter;
import com.pingidentity.jgroups.org.jgroups.XmlTagGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pingidentity.utils.EnvironmentVariableUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DiscoveryProtocol {
    private static final Log log = LogFactory.getLog(DiscoveryProtocol.class);
    private static final String JGROUPS_PROPERTY_FILENAME = "jgroups.properties";
    private static final String CLUSTER_PREFIX = "pf.cluster.";
    private static final String DISCOVERY_PREFIX = "pf.cluster.discovery.";
    public static final String DISCOVERY_PROTOCOL = "pf.cluster.discovery.protocol";
    public static final String DISCOVERY_CLASS = "pf.cluster.discovery.class";
    private static final Map<String, String> CONFIG_TO_FQCN = new HashMap<String, String>();
    private Properties properties = null;

    public DiscoveryProtocol() throws IOException {
        String binDir = MgmtFactory.getSysDirInfo().getBinDirectory();
        File jgroupsPropertiesFile = new File(binDir, JGROUPS_PROPERTY_FILENAME);
        if (!jgroupsPropertiesFile.exists()) {
            log.warn((Object)String.format("Property file [%s] is not found", jgroupsPropertiesFile.getAbsolutePath()));
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(jgroupsPropertiesFile);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
            EnvironmentVariableUtil.loadPropertyWithEnvVar((Properties)properties, (Reader)reader, (String)JGROUPS_PROPERTY_FILENAME);
        }
        this.properties = properties;
    }

    public String getDiscoveryProtocolTag(Properties substitutionValuesMap) throws Substituter.UnknownKeyException {
        String discoveryTag = "";
        if (this.properties == null) {
            return discoveryTag;
        }
        String discoveryProtocol = this.properties.getProperty(DISCOVERY_PROTOCOL, "");
        if (StringUtils.isNotBlank((String)discoveryProtocol)) {
            String discoveryClass = CONFIG_TO_FQCN.getOrDefault(discoveryProtocol, discoveryProtocol);
            String declaredDiscoveryClass = this.properties.getProperty(DISCOVERY_CLASS);
            if (StringUtils.isNotBlank((String)declaredDiscoveryClass)) {
                discoveryClass = declaredDiscoveryClass;
            }
            XmlTagGenerator.Builder xmlBuilder = new XmlTagGenerator.Builder(discoveryClass);
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String value;
                String key = (String)entry.getKey();
                int discoveryProtocolIndex = key.indexOf(CLUSTER_PREFIX + discoveryProtocol);
                if (discoveryProtocolIndex == -1 || !StringUtils.isNotBlank((String)(value = (String)entry.getValue()))) continue;
                xmlBuilder.setAttributeKeyValue(this.getKey(key, discoveryProtocolIndex, discoveryProtocol), Substituter.substituteValues(value, substitutionValuesMap));
            }
            XmlTagGenerator discoveryTagGenerator = xmlBuilder.build();
            discoveryTag = discoveryTagGenerator.getXmlTag();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("discovery protocol tag: " + discoveryTag));
        }
        return discoveryTag;
    }

    private String getKey(String key, int discoveryProtocolIndex, String discoveryProtocol) {
        return key.substring(discoveryProtocolIndex + CLUSTER_PREFIX.length() + discoveryProtocol.length() + 1);
    }

    static {
        CONFIG_TO_FQCN.put("NATIVE_S3_PING", "org.jgroups.aws.s3.NATIVE_S3_PING");
        CONFIG_TO_FQCN.put("DNS_PING", "dns.DNS_PING");
        CONFIG_TO_FQCN.put("AWS_PING", "com.pingidentity.aws.AWS_PING");
    }
}

