/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups.org.jgroups;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.MacAlgorithm;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.jgroups.org.jgroups.XmlTagGenerator;
import com.pingidentity.pingcommons.util.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;

public class ENCRYPT {
    private static final Log log = LogFactory.getLog(ENCRYPT.class);
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.jgroups.org.jgroups.ENCRYPT");
    static final String STORE_NAME = "keystore_name";
    private static final String KEYSTORE_FILENAME = ".cluster.keystore";
    static final String STORE_PASSWORD = "store_password";
    private static final String STORE_PASSWORD_VALUE = IDGenerator.rndAlphaNumeric(22);
    static final String STORE_TYPE = "keystore_type";
    static final String SYM_ALGORITHM = "sym_algorithm";
    private static final String SYM_ALGORITHM_VALUE = "AES/CBC/PKCS5Padding";
    static final String SYM_IV_LENGTH = "sym_iv_length";
    private static final String SYM_IV_LENGTH_VALUE = "16";
    static final String HMAC_LENGTH = "hmac_length";
    private static final String HMAC_LENGTH_VALUE = "16";
    static final String ALIAS_KEY = "alias";
    static final String ALIAS_VALUE_ENCRYPTION = "encryptionKey";
    static final String ALIAS_VALUE_SIGNING = "signingKey";
    static final String PROVIDER_KEY = "provider";
    static final String PROVIDER_VALUE = configStore.getStringValue("CryptoProvider", SecurityProviderUtil.getSunJCEProviderOrEquivalent());

    static File getKeyStoreFile() {
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        String configDir = sysDirInfo.getConfigDirectory();
        return new File(configDir, KEYSTORE_FILENAME);
    }

    public static void generateKeyStore(String keyPassword) {
        ENCRYPT.deleteKeyStoreFile();
        FileOutputStream fileOutputStream = null;
        try {
            ClusterKeys clusterKeys = ENCRYPT.generateKeys(keyPassword);
            File file = ENCRYPT.getKeyStoreFile();
            fileOutputStream = new FileOutputStream(file);
            KeyStore ks = KeyStore.getInstance(SecurityProviderUtil.getJceksOrEquivalent());
            ks.load(null, null);
            ks.setKeyEntry(ALIAS_VALUE_ENCRYPTION, clusterKeys.getEncryptionKey(), STORE_PASSWORD_VALUE.toCharArray(), null);
            ks.setKeyEntry(ALIAS_VALUE_SIGNING, clusterKeys.getSigningKey(), STORE_PASSWORD_VALUE.toCharArray(), null);
            ks.store(fileOutputStream, STORE_PASSWORD_VALUE.toCharArray());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to init INTEGRITY/SYM_ENCRYPT/SERIALIZE protocols", e);
            }
            catch (Throwable throwable) {
                Closer.close(fileOutputStream);
                throw throwable;
            }
        }
        Closer.close((Closeable)fileOutputStream);
    }

    static void deleteKeyStoreFile() {
        File file = ENCRYPT.getKeyStoreFile();
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static String getTags() {
        StringBuilder encryptTags = new StringBuilder();
        XmlTagGenerator integrityGenerator = new XmlTagGenerator.Builder("com.pingidentity.jgroups.protocols.INTEGRITY").setAttributeKeyValue(STORE_NAME, KEYSTORE_FILENAME).setAttributeKeyValue(STORE_PASSWORD, STORE_PASSWORD_VALUE).setAttributeKeyValue(STORE_TYPE, SecurityProviderUtil.getJceksOrEquivalent()).setAttributeKeyValue(ALIAS_KEY, ALIAS_VALUE_SIGNING).setAttributeKeyValue(HMAC_LENGTH, "16").setAttributeKeyValue(PROVIDER_KEY, PROVIDER_VALUE).build();
        encryptTags.append(integrityGenerator.getXmlTag());
        XmlTagGenerator systemEncryptGenerator = new XmlTagGenerator.Builder("SYM_ENCRYPT").setAttributeKeyValue(STORE_NAME, KEYSTORE_FILENAME).setAttributeKeyValue(STORE_PASSWORD, STORE_PASSWORD_VALUE).setAttributeKeyValue(STORE_TYPE, SecurityProviderUtil.getJceksOrEquivalent()).setAttributeKeyValue(ALIAS_KEY, ALIAS_VALUE_ENCRYPTION).setAttributeKeyValue(SYM_ALGORITHM, SYM_ALGORITHM_VALUE).setAttributeKeyValue(SYM_IV_LENGTH, "16").setAttributeKeyValue(PROVIDER_KEY, PROVIDER_VALUE).build();
        encryptTags.append(systemEncryptGenerator.getXmlTag());
        encryptTags.append("<SERIALIZE/>");
        return encryptTags.toString();
    }

    static ClusterKeys generateKeys(String pwd) throws NoSuchAlgorithmException, InvalidKeySpecException {
        int encryptionKeySizeBits = Integer.parseInt(PropertyInfo.getJgroupsKeySize());
        if (!Arrays.asList(128, 192, 256).contains(encryptionKeySizeBits)) {
            throw new ConfigurationException("Invalid cluster encryption key size: " + encryptionKeySizeBits);
        }
        int encryptionKeySize = encryptionKeySizeBits / 8;
        int signingKeySize = 32;
        int signingKeySizeBits = signingKeySize * 8;
        log.debug((Object)("Setting keysize for generated encryption key to " + encryptionKeySize + " bytes"));
        long startTime = System.currentTimeMillis();
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec keySpec = new PBEKeySpec(pwd.toCharArray(), new byte[16], configStore.getIntValue("KdfIterations", 60000), signingKeySizeBits);
        SecretKey initialKey = keyFactory.generateSecret(keySpec);
        keySpec = new PBEKeySpec(B64.encode((byte[])initialKey.getEncoded()).toCharArray(), new byte[16], 1, encryptionKeySizeBits + signingKeySizeBits);
        SecretKey finalKey = keyFactory.generateSecret(keySpec);
        long endTime = System.currentTimeMillis();
        log.debug((Object)("Cluster keys derived in " + (endTime - startTime) + " milliseconds"));
        byte[] finalByteArray = finalKey.getEncoded();
        byte[] encryptionKeyBytes = Arrays.copyOf(finalByteArray, encryptionKeySize);
        byte[] signingKeyBytes = Arrays.copyOfRange(finalByteArray, encryptionKeySize, finalByteArray.length);
        SecretKeySpec encryptionKey = new SecretKeySpec(encryptionKeyBytes, "AES");
        SecretKeySpec signingKey = new SecretKeySpec(signingKeyBytes, MacAlgorithm.HMACSHA256.name());
        return new ClusterKeys(encryptionKey, signingKey);
    }

    static class ClusterKeys {
        private SecretKey encryptionKey;
        private SecretKey signingKey;

        public ClusterKeys(SecretKey encryptionKey, SecretKey signingKey) {
            this.encryptionKey = encryptionKey;
            this.signingKey = signingKey;
        }

        public SecretKey getEncryptionKey() {
            return this.encryptionKey;
        }

        public SecretKey getSigningKey() {
            return this.signingKey;
        }
    }
}

