/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups.org.jgroups;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class XmlTagGenerator {
    private static final String LINE_SEPARATOR_PROPERTY = "line.separator";
    private final String xmlTag;

    private XmlTagGenerator(Builder builder) {
        StringBuilder tagBuilder = new StringBuilder("<" + builder.tagName);
        tagBuilder.append(System.getProperty(LINE_SEPARATOR_PROPERTY));
        for (Map.Entry<String, String> entrySet : builder.attributes.entrySet()) {
            tagBuilder.append(entrySet.getKey()).append("=").append("\"").append(entrySet.getValue()).append("\"").append(System.getProperty(LINE_SEPARATOR_PROPERTY));
        }
        tagBuilder.append("/>").append(System.getProperty(LINE_SEPARATOR_PROPERTY));
        this.xmlTag = tagBuilder.toString();
    }

    public String getXmlTag() {
        return this.xmlTag;
    }

    public static class Builder {
        private final String tagName;
        private final HashMap<String, String> attributes = new LinkedHashMap<String, String>();

        public Builder(String tagName) {
            this.tagName = tagName;
        }

        public Builder setAttributeKeyValue(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public XmlTagGenerator build() {
            return new XmlTagGenerator(this);
        }
    }
}

