/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.localidentity.authsource.LocalAccountAuthSource;
import java.io.Serializable;

public class ConnectedIdentity
implements Serializable {
    private static final long serialVersionUID = 19293L;
    private final String authSourceId;
    private final String userId;

    public ConnectedIdentity(String connectedIdentityString) {
        String[] parts = ConnectedIdentity.extractData(connectedIdentityString);
        this.authSourceId = parts[0];
        this.userId = parts[1];
    }

    static String[] extractData(String connectedIdentityString) {
        if (connectedIdentityString == null) {
            throw new IllegalArgumentException("connectedIdentityString cannot be null");
        }
        int dividerIndex = connectedIdentityString.indexOf(":");
        if (dividerIndex < 0) {
            throw new IllegalArgumentException(connectedIdentityString + " is not valid");
        }
        String authSourcePart = connectedIdentityString.substring(0, dividerIndex);
        String userIdPart = connectedIdentityString.substring(dividerIndex + 1);
        if (!authSourcePart.startsWith("auth-source=") || !userIdPart.startsWith("user-id=")) {
            throw new IllegalArgumentException(connectedIdentityString + " is not valid");
        }
        String authSourceId = authSourcePart.replaceFirst("auth-source=", "");
        String userId = userIdPart.replaceFirst("user-id=", "");
        return new String[]{authSourceId, userId};
    }

    public String getAuthSourceId() {
        return this.authSourceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isLocalIdentity() {
        return this.authSourceId.equals(LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE.getId());
    }
}

