/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.access.CaptchaProviderAccessor;
import com.pingidentity.auth.login.WebAuthNUtil;
import com.pingidentity.captcha.util.CaptchaProviderUtil;
import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.locale.StandardTemplateMessage;
import com.pingidentity.locale.TemplateBannerMessage;
import com.pingidentity.locale.TemplateMessageHolder;
import com.pingidentity.localidentity.LocalIdentityAuditLogger;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityException;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.RegistrationFailedException;
import com.pingidentity.localidentity.UserToCreate;
import com.pingidentity.localidentity.attrupdates.AuthSourceAttributeUpdateProcessor;
import com.pingidentity.localidentity.attrupdates.AuthSourceAttributes;
import com.pingidentity.localidentity.authsource.LocalAccountAuthSource;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.pingidentity.localidentity.errors.LocalIdentityError;
import com.pingidentity.localidentity.errors.LocalIdentityGeneralError;
import com.pingidentity.localidentity.fieldtypes.CheckboxField;
import com.pingidentity.localidentity.fieldtypes.HiddenField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.RequiredFieldValidator;
import com.pingidentity.localidentity.type.LocalIdentityValidationResult;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PostRegistrationSessionAwareAdapter;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.action.AuthenticationSourceSelection;
import com.pingidentity.sdk.api.authn.model.action.CheckOtp;
import com.pingidentity.sdk.api.authn.model.action.RegisterUser;
import com.pingidentity.sdk.api.authn.model.state.AccountLinkingFailed;
import com.pingidentity.sdk.api.authn.model.state.AlternativeAuthenticationSource;
import com.pingidentity.sdk.api.authn.model.state.EmailVerificationRequired;
import com.pingidentity.sdk.api.authn.model.state.Field;
import com.pingidentity.sdk.api.authn.model.state.RegistrationRequired;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import com.pingidentity.templates.mgmt.TemplateRenderer;
import com.pingidentity.util.LocaleUtilWrapper;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.localidentity.SendEmailVerification;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.localidentity.data.StringFieldData;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.state.ApplicationSessionStateSupport;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.IdpAdapter;
import org.sourceid.saml20.domain.LocalIdentityManagementResult;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.log.AttributeMap;

public class LocalIdentityAdapter
implements IdpAuthenticationAdapterV2,
IdpAdapter,
AuthnApiPlugin {
    public static final String QUERY_PARAM_ACTION = "pf.query.param.action";
    private static final Log log = LogFactory.getLog(LocalIdentityAdapter.class);
    private static final ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();
    public static final String GENERIC_ERROR_MESSAGE = "Authentication Failed.";
    public static final String CANCEL_ACTION = "Cancel";
    public static final String REGISTRATION_FRAGMENT_ACTION = "Registration Fragment";
    public static final String THIRD_PARTY_SSO_ATTRIBUTE = "pf.thirdPartySSO";
    static final String MESSAGES_PARAM = "messages";
    private static final String PASS = "pf.pass";
    public static final String OK = "pf.ok";
    public static final String CANCEL = "pf.cancel";
    static final String SIGN_ON = "pf.signon";
    static final String RESTART = "pf.restart";
    static final String ALTERNATE_THIRD_PARTY_REGISTER = "pf.thirdpartyregister";
    static final String IS_LOCAL_REGISTRATION_PARAM = "isLocalRegistration";
    public static final String RESUME_REGISTRATION = "local.identity.resume.registration";
    private static final String MY_DEVICE = "pf.myDevice";
    private static final String VERIFY_EMAIL_FORM = "isRequireVerifiedEmailForm";
    private static final String VERIFY_EMAIL_CONTINUE = "pf.verify.email.continue";
    private static final String VERIFY_EMAIL_RESEND = "pf.verify.email.send";
    private static final String VERIFY_EMAIL_CANCEL = "pf.verify.email.cancel";
    private static final String VERIFY_EMAIL_PROFILE_MANAGEMENT = "pf.verify.email.profileManagement";
    public static final String OTP_EMAIL_FORM = "isOtpEmailVerificationForm";
    public static final String OTP_EMAIL_VERIFY_OTP = "pf.otp.email.verify.otp";
    public static final String OTP_EMAIL_SKIP_OTP = "pf.otp.email.skip.otp";
    public static final String OTP_EMAIL_RESEND_OTP = "pf.otp.email.send";
    public static final String OTP_EMAIL_PROFILE_MANAGEMENT = "pf.otp.email.profileManagement";
    public static final String USER_TO_CREATE = "USER_TO_CREATE";
    public static final String REGISTRATION_FRAGMENT_DONE = "registrationFragmentDone";
    public static final String UPDATE_USER_AFTER_LIP_FRAGMENT = "executePostLipFragment";
    private static final String REGISTRATION_SHARED_MACHINE = "registrationSharedMachine";
    public static final String THIRD_PARTY_UNIQUE_ID_ATTRIBUTE = "pf.local.identity.unique.id";
    public static final String LOCAL_IDENTITY_REGISTRATION_GENERIC_FAILURE = "local.identity.registration.generic.failure";
    public static final String LIP_REG_ADAPTER_ATTRS = "pf.local.identity.reg.adapter.attrs";
    public static final String LIP_SESSION_ADAPTERS = "pf.local.identity.session.adapters";
    public static final String LIP_SESSION_INFO = "pf.local.identity.session.info";
    public static final String REGISTRATION_PENDING_EMAIL_VERIFY = "pf.local.identity.reg.pending.email.verify";
    public static final String EMAIL_VERIFICATION_REQUEST = "pf.local.identity.email.verification.request";
    public static final String PROFILE_MANAGEMENT_REQUEST = "pf.local.identity.profile.management.request";
    private static final ParamMapping<AuthenticationSourceSelection, String> ALTERNATE_AUTHN_SOURCE_MAPPING = new ParamMapping("pf.thirdpartyregister", AuthenticationSourceSelection.class, AuthenticationSourceSelection::getAuthenticationSource, Function.identity());
    private static final ParamMapping<RegisterUser, String> PASSWORD_MAPPING = new ParamMapping("pf.pass", RegisterUser.class, RegisterUser::getPassword, Function.identity());
    private static final String ADAPTER_API_STATE_PARAM_KEY = "LOCAL_IDENTITY_ADAPTER_API_STATE";
    private static final String ADAPTER_API_ERROR_STATE_PARAM_KEY = "LOCAL_IDENTITY_ADAPTER_ERROR_API_STATE";
    private LocalIdentityProfile localIdentityProfile;
    private ApplicationSessionStateSupport sessionStateSupport;
    private TransactionalStateSupport transactionalStateSupport;
    private TemplateRenderer templateRenderer;
    private LocaleUtilWrapper localeUtil;

    public LocalIdentityAdapter() {
    }

    public LocalIdentityAdapter(LocalIdentityProfile profile) {
        this.localIdentityProfile = profile;
        this.sessionStateSupport = new ApplicationSessionStateSupport(this.localIdentityProfile.getId(), this.localIdentityProfile::clearSession);
        this.templateRenderer = new TemplateRenderer();
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        return this.lookupAuthN(req, resp, inParameters, true);
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws AuthnAdapterException, IOException {
        this.checkRequestedAction(inParameters);
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            if (!allowInteraction) {
                return this.failureResponse();
            }
            if (!AuthnApiSupport.getDefault().isValidAuthnApiPostRequest(req, resp, this.getActionIdToModelMapping(req, resp, inParameters))) {
                AuthnAdapterResponse response = new AuthnAdapterResponse();
                response.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return response;
            }
        }
        AuthnAdapterResponse response = !this.localIdentityProfile.isProfileEnabled() && !this.localIdentityProfile.isRegistrationEnabled() ? this.doAltAuthLogin(req, resp, inParameters, allowInteraction) : this.doLocalIdentityFlow(req, resp, inParameters, allowInteraction);
        if (!allowInteraction && response != null && response.getAuthnStatus() != AuthnAdapterResponse.AUTHN_STATUS.FAILURE && log.isDebugEnabled()) {
            log.debug((Object)("No browser interaction required, returning status " + response.getAuthnStatus()));
        }
        return response;
    }

    private Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParams) {
        HashMap actionModelMapping = new HashMap();
        if (this.isRegistrationError(req)) {
            AdapterApiState state = LocalIdentityAdapter.getAdapterApiState(req);
            CommonStateSpec.ACCOUNT_LINKING_FAILED.getActions().forEach(action -> actionModelMapping.put(action.getId(), action.getModelClass()));
            if (state == AdapterApiState.LOGIN) {
                actionModelMapping.remove(CommonActionSpec.RESTART.getId());
            } else if (state == AdapterApiState.REGISTER) {
                actionModelMapping.remove(CommonActionSpec.CONTINUE.getId());
            }
        } else if (LocalIdentityAdapter.isRequireVerifiedEmailPosted(req)) {
            if (LocalIdentityUtils.isOtpEmailVerificationType(this.localIdentityProfile)) {
                CommonStateSpec.EMAIL_VERIFICATION_OTP_REQUIRED.getActions().forEach(action -> {
                    if (!this.requireVerifiedEmail() || !action.getId().equals("skipOtp")) {
                        actionModelMapping.put(action.getId(), action.getModelClass());
                    }
                });
            } else {
                CommonStateSpec.EMAIL_VERIFICATION_REQUIRED.getActions().forEach(action -> actionModelMapping.put(action.getId(), action.getModelClass()));
            }
        } else {
            CommonStateSpec.REGISTRATION_REQUIRED_AUTHN_STATE_SPEC.getActions().forEach(action -> actionModelMapping.put(action.getId(), action.getModelClass()));
            if (this.isRegistration(req, resp, inParams) && !this.isLocalRegistration(inParams)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing " + CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId() + " since an alternate authentication source has already been used for this request."));
                }
                actionModelMapping.remove(CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId());
            }
            if (this.localIdentityProfile.getAuthSourceStrings().isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing " + CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId() + ". No alternate auth sources are defined for this identity profile."));
                }
                actionModelMapping.remove(CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId());
            }
        }
        return actionModelMapping;
    }

    private void doAuthnApi(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException {
        List authSources = this.filterWebAuthNSource(req, this.localIdentityProfile.getAuthSourceStrings()).stream().map(authSource -> {
            AlternativeAuthenticationSource apiAuthSource = new AlternativeAuthenticationSource();
            apiAuthSource.setName(authSource);
            return apiAuthSource;
        }).collect(Collectors.toList());
        AttributeMap inboundAttrs = this.getInboundAttributes(inParameters);
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(this.buildFieldList(req, this.localIdentityProfile.getFieldConfig().getFilteredRegistrationFields(), inboundAttrs));
        fields.addAll(this.buildFieldList(req, this.localIdentityProfile.getFieldConfig().getListOfHiddenRegistrationFields(), inboundAttrs));
        RegistrationRequired model = new RegistrationRequired();
        if (!authSources.isEmpty()) {
            model.setAlternativeAuthenticationSources(authSources);
        }
        model.setFields(fields);
        if (!this.isLocalRegistration(inParameters)) {
            model.setAuthenticationSource(this.getPolicyAction(inParameters));
        }
        boolean isCaptchaEnabled = this.localIdentityProfile.getRegistrationConfig().isCaptchaEnabled();
        model.setShowCaptcha(isCaptchaEnabled);
        if (isCaptchaEnabled) {
            CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)this.localIdentityProfile.getRegistrationConfig().getCaptchaProviderId());
            CaptchaContext captchaContext = new CaptchaContext.Builder().setAction("registration").setResponse(resp).setRequest(req).setInParameters(CaptchaProviderUtil.filterInParameters(inParameters)).build();
            Map captchaAttributes = captchaProvider.getCaptchaAttributes(captchaContext);
            model.setCaptchaProviderType(captchaProvider.getPluginDescriptor().getType());
            model.setCaptchaAttributes(captchaAttributes);
            if ("reCAPTCHA v2 Invisible".equals(captchaProvider.getPluginDescriptor().getType())) {
                model.setCaptchaSiteKey((String)captchaAttributes.get("siteKey"));
            }
        }
        model.setShowThisIsMyDevice(this.isShowMyDevice(inParameters));
        AuthnState authnState = CommonStateSpec.REGISTRATION_REQUIRED_AUTHN_STATE_SPEC.makeInstance(req, (Object)model);
        if (!this.isLocalRegistration(inParameters)) {
            authnState.removeAction(CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId());
        }
        if (authSources.isEmpty()) {
            authnState.removeAction(CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId());
        }
        if (this.isDirectLink(req, resp)) {
            authnState.removeAction(CommonActionSpec.CANCEL.getId());
        }
        AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, authnState);
    }

    private boolean isDirectLink(HttpServletRequest req, HttpServletResponse resp) {
        Object directLinkObj = this.transactionalStateSupport.removeAttribute(QUERY_PARAM_ACTION, req, resp);
        return directLinkObj != null ? (Boolean)directLinkObj : false;
    }

    private boolean isShowMyDevice(Map<String, Object> inParameters) {
        if (this.localIdentityProfile.getRegistrationConfig().isThisIsMyDeviceEnabled()) {
            String deviceSharingType = (String)inParameters.get("com.pingidentity.adapter.input.parameter.device.sharing.type");
            return DeviceSharingType.UNSPECIFIED.name().equals(deviceSharingType);
        }
        return false;
    }

    private List<Field> buildFieldList(HttpServletRequest req, List<LocalIdentityField<?>> fieldsToBuild, AttributeMap inboundAttrs) {
        LanguagePackMessages messages = LocaleUtil.getLanguagePackMessagesForHtmlTemplates(LocaleUtil.getUserLocale(req));
        return fieldsToBuild.stream().map(lipField -> {
            Field.FieldBuilder builder = new Field.FieldBuilder().setId(lipField.getData().getId()).setLabel(messages.getMessageWithDefault("local.identity.registration.", lipField.getData().getId(), lipField.getData().getLabel())).setOptions(lipField.getData().getOptions()).setType(lipField.getName()).setInitialValue(this.getInboundValueFor((LocalIdentityField<?>)lipField, inboundAttrs));
            if (lipField.getConfig().isShowDefaultValueField() && !lipField.isReadOnly()) {
                builder.setDefaultValue(lipField.getData().getDefaultValue());
            }
            if (lipField.canBe("Read-Only")) {
                builder.setReadonly(lipField.isReadOnly());
            }
            if (!lipField.getName().equals("Hidden")) {
                builder.setRequired(lipField.isRequired());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    private void checkRequestedAction(Map<String, Object> inParameters) throws AuthnAdapterException {
        String requestedAction = this.getPolicyAction(inParameters);
        if (StringUtils.isNotBlank((String)requestedAction)) {
            ArrayList<String> validRequestedActions = new ArrayList<String>(this.localIdentityProfile.getAuthSourceStrings());
            validRequestedActions.add("identity.registration");
            validRequestedActions.add(REGISTRATION_FRAGMENT_ACTION);
            if (!validRequestedActions.contains(requestedAction)) {
                log.error((Object)("The requested policy action is not configured for this Local Identity Profile. Valid sources are: " + StringUtils.join(validRequestedActions, (String)", ") + ". Please check your configuration."));
                throw new AuthnAdapterException("The requested policy action does not match any configured options.");
            }
        }
    }

    private AuthnAdapterResponse doLocalIdentityFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws IOException, AuthnAdapterException {
        if (this.isRegistrationError(req)) {
            if (!allowInteraction) {
                return this.failureResponse();
            }
            return this.checkErrorPage(req, resp, inParameters, allowInteraction);
        }
        if (LocalIdentityAdapter.isRequireVerifiedEmailPosted(req)) {
            if (!allowInteraction) {
                return this.failureResponse();
            }
            return this.doEmailVerificationFlow(req, resp, inParameters, allowInteraction);
        }
        if (this.isRegistration(req, resp, inParameters)) {
            if (!allowInteraction) {
                return this.failureResponse();
            }
            return this.doRegistrationFlow(req, resp, inParameters, allowInteraction);
        }
        this.setAdapterApiState(req, AdapterApiState.LOGIN);
        return this.doSSO(req, resp, inParameters, allowInteraction);
    }

    private AuthnAdapterResponse failureResponse() {
        AuthnAdapterResponse response = new AuthnAdapterResponse();
        response.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        return response;
    }

    private AuthnAdapterResponse checkErrorPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws AuthnAdapterException, IOException {
        String ok = req.getParameter(OK);
        String restart = req.getParameter(RESTART);
        if (StringUtils.isNotBlank((String)ok) && ok.equals("clicked") || CommonActionSpec.CONTINUE.isRequested(req)) {
            LocalIdentityStorageManager<DN> manager = this.localIdentityProfile.getStorageManager();
            DN dn = this.getDNFromSession(req, resp);
            try {
                LocalIdentityDTO<DN> localIdentityDTO = manager.getIdentityByDn(this.localIdentityProfile, dn);
                this.saveDNtoSession(localIdentityDTO.getIdentifier(), req, resp, inParameters);
                String previousPolicyAction = this.getPreviousPolicyAction(req, resp);
                return this.successAndSSO(previousPolicyAction, localIdentityDTO.getAttributesForMapping(), req, resp, inParameters, allowInteraction);
            }
            catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                log.error((Object)("Could not find user with DN " + dn + ". Unable to sign the user into the target resource."));
                throw new AuthnAdapterException("Unable to continue.");
            }
        }
        if (StringUtils.isNotBlank((String)restart) && restart.equals("clicked") || CommonActionSpec.RESTART.isRequested(req)) {
            log.debug((Object)"Canceling registration and redirecting the user.");
            this.removePolicyAction(req, resp);
            return this.restartTree();
        }
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            this.setAdapterApiErrorState(req, false);
            return this.doLocalIdentityFlow(req, resp, inParameters, allowInteraction);
        }
        log.error((Object)"The error template was submitted incorrectly ('pf.ok' param was not set to the correct value).");
        throw new AuthnAdapterException(GENERIC_ERROR_MESSAGE);
    }

    private AuthnAdapterResponse doSSO(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws IOException, AuthnAdapterException {
        return this.doSSO(req, resp, inParameters, allowInteraction, null, null);
    }

    private AuthnAdapterResponse doSSO(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction, TemplateBannerMessage bannerMessage, AuthnError authnError) throws IOException, AuthnAdapterException {
        String policyAction = this.getPolicyAction(inParameters);
        DN dn = null;
        boolean isAccountLinking = inParameters.get("AccountLinking") == null ? false : Boolean.valueOf(inParameters.get("AccountLinking").toString());
        try {
            LocalIdentityDTO<DN> localIdentityDTO;
            dn = this.getDNFromSession(req, resp);
            if (LocalIdentityAdapter.isRequireVerifiedEmailPosted(req)) {
                LocalIdentityStorageManager<DN> manager = this.localIdentityProfile.getStorageManager();
                localIdentityDTO = manager.getIdentityByDn(this.localIdentityProfile, dn);
            } else {
                localIdentityDTO = this.lookupUserByLink(policyAction, inParameters, req);
            }
            if (dn != null && !dn.equals((Object)localIdentityDTO.getIdentifier())) {
                if (isAccountLinking) {
                    if (!allowInteraction) {
                        return this.failureResponse();
                    }
                    this.renderErrorTemplate(req, resp, inParameters, new StandardTemplateMessage("local.identity.connection.error.account.already.linked", new String[]{policyAction}), OK);
                    AuthnAdapterResponse response = new AuthnAdapterResponse();
                    response.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                    return response;
                }
                this.logout(req, resp);
            }
            this.saveDNtoSession(localIdentityDTO.getIdentifier(), req, resp, inParameters);
            LocalIdentityAuthSource authSource = this.localIdentityProfile.getAuthSource(policyAction);
            if (authSource != null && authSource.getUpdatePolicy().isUpdateAttributes()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking to see if third-party attributes need updating from '" + authSource.getSource() + "' for user '" + localIdentityDTO.getIdentifier() + "'"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Update interval for '" + authSource.getSource() + "' is set to " + authSource.getUpdatePolicy().getUpdateIntervalInSeconds() + " seconds"));
                }
                AuthSourceAttributeUpdateProcessor updateProcessor = new AuthSourceAttributeUpdateProcessor(authSource, inParameters);
                AuthSourceAttributes updatedAttributes = updateProcessor.mergeAttributes(localIdentityDTO.getConnectedIdentityAttributes().get(authSource.getId()));
                if (updateProcessor.needsUpdate()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Attribute updates were found. Updating user record now.");
                    }
                    LocalIdentityStorageManager<DN> storageManager = this.localIdentityProfile.getStorageManager();
                    localIdentityDTO = storageManager.updateAuthSourceAttributes(this.localIdentityProfile, localIdentityDTO.getIdentifier(), localIdentityDTO, updatedAttributes);
                } else if (log.isTraceEnabled()) {
                    log.trace((Object)("No attribute updates were required for " + localIdentityDTO.getIdentifier()));
                }
            }
            return this.successAndSSO(policyAction, localIdentityDTO.getAttributesForMapping(), req, resp, inParameters, allowInteraction, bannerMessage, authnError);
        }
        catch (LocalIdentityStorageManager.IdentityNotFoundException e) {
            if (!allowInteraction) {
                return this.failureResponse();
            }
            if (isAccountLinking && dn != null) {
                return this.doAccountLinking(dn, policyAction, req, resp, inParameters, allowInteraction);
            }
            if (!isAccountLinking && this.localIdentityProfile.isRegistrationEnabled() && StringUtils.isNotBlank((String)policyAction)) {
                log.debug((Object)("No user was found for auth source '" + policyAction + "'. Sending the user to the registration page to create an account."));
                TemplateMessageHolder messages = new TemplateMessageHolder();
                TemplateBannerMessage alertMessage = new TemplateBannerMessage("local.identity.registration.no.third.party.account", new String[]{policyAction}, TemplateBannerMessage.TemplateMessageType.FEATURE);
                messages.addMessage(alertMessage);
                return this.displayRegistrationPage(req, resp, inParameters, messages);
            }
            throw new AuthnAdapterException(GENERIC_ERROR_MESSAGE, (Throwable)e);
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            throw new AuthnAdapterException(GENERIC_ERROR_MESSAGE, (Throwable)e);
        }
    }

    private AuthnAdapterResponse doAccountLinking(DN dn, String policyAction, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws AuthnAdapterException, IOException {
        log.debug((Object)("Attempting to perform account linking for DN: " + dn));
        LocalIdentityStorageManager<DN> manager = this.localIdentityProfile.getStorageManager();
        try {
            LocalIdentityAuthSource authSource = this.localIdentityProfile.getAuthSourceByName(policyAction);
            if (authSource == null) {
                log.error((Object)("Could not find an auth source with name '" + policyAction + "' in the profile '" + this.localIdentityProfile.getId()));
                throw new AuthnAdapterException("Account Linking Failed");
            }
            LocalIdentityDTO<DN> localIdentityDTO = manager.getIdentityByDn(this.localIdentityProfile, dn);
            if (localIdentityDTO == null) {
                log.debug((Object)"Unable to link accounts since the account associated with this session no longer exists.");
                log.info((Object)("User " + dn + " was not found in the data store. Clearing the users sessions and restarting the tree."));
                this.logout(req, resp);
                return this.restartTree();
            }
            LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.AUTHN_SOURCE_CONNECT, localIdentityDTO, this.localIdentityProfile, authSource.getId(), req, resp);
            try {
                LocalIdentityAuditLogger.setUserName(this.getUniqueId(inParameters, req));
            }
            catch (LocalIdentityException.UniqueIdNotFound uniqueIdNotFound) {
                log.warn((Object)"No unique ID was provided during account linking.");
            }
            if (localIdentityDTO.isAlreadyConnectedTo(authSource.getId())) {
                this.renderErrorTemplate(req, resp, inParameters, new StandardTemplateMessage("local.identity.connection.error.source.already.linked", new String[]{policyAction}), OK);
                AuthnAdapterResponse response = new AuthnAdapterResponse();
                response.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return response;
            }
            AuthnAdapterResponse authnResponse = this.addLinkToLocalAccount(dn, authSource, req, resp, inParameters, allowInteraction);
            if (authnResponse.getAuthnStatus().equals((Object)AuthnAdapterResponse.AUTHN_STATUS.SUCCESS)) {
                LocalIdentityAuditLogger.log();
            }
            return authnResponse;
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e1) {
            throw new AuthnAdapterException("Account Linking Failed");
        }
    }

    private AuthnAdapterResponse addLinkToLocalAccount(DN dn, LocalIdentityAuthSource authSource, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws AuthnAdapterException, TemplateRendererUtilException {
        LocalIdentityStorageManager<DN> storageManager = this.localIdentityProfile.getStorageManager();
        String uniqueId = null;
        try {
            uniqueId = this.getUniqueId(inParameters, req);
        }
        catch (LocalIdentityException.UniqueIdNotFound e) {
            log.error((Object)"No unique ID was available from the 3rd party source to connect with with. Please check your configuration.");
            throw new AuthnAdapterException("There was an error while connecting your identities.", (Throwable)e);
        }
        try {
            AuthSourceAttributeUpdateProcessor attributeProcessor = new AuthSourceAttributeUpdateProcessor(authSource, inParameters);
            LocalIdentityDTO<DN> localIdentityDTO = storageManager.addConnectedIdentity(this.localIdentityProfile, dn, authSource.getId(), uniqueId, attributeProcessor.getJsonString());
            this.saveDNtoSession(dn, req, resp, inParameters);
            String previousPolicyAction = this.getPreviousPolicyAction(req, resp);
            return this.successAndSSO(previousPolicyAction, localIdentityDTO.getAttributesForMapping(), req, resp, inParameters, allowInteraction);
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)("Unable to connect these identities due to " + e.getMessage()));
            throw new AuthnAdapterException("There was an error while connecting your identities.", (Throwable)e);
        }
    }

    private AuthnAdapterResponse doRegistrationFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws IOException, AuthnAdapterException {
        this.removePolicyAction(req, resp);
        this.removeResumeRegistration(req, resp, inParameters);
        try {
            if (this.isRegistrationCancelled(req)) {
                log.debug((Object)"Canceling registration and redirecting the user.");
                this.removePolicyAction(req, resp);
                this.getTransactionalStateSupportForResumeUrl(inParameters).removeAttribute(UPDATE_USER_AFTER_LIP_FRAGMENT, req, resp);
                return this.restartTree();
            }
            if (this.isThirdPartyRegister(req)) {
                String selectedThirdPartyToRegister = (String)ALTERNATE_AUTHN_SOURCE_MAPPING.getValue(req);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registering with alternate authn system. Redirecting to auth source '" + selectedThirdPartyToRegister + "'"));
                }
                if (this.localIdentityProfile.getAuthSource(selectedThirdPartyToRegister) == null) {
                    log.error((Object)(selectedThirdPartyToRegister + " is not a valid configured authentication source. The configured authentication source(s) are " + StringUtils.join(this.localIdentityProfile.getAuthSourceStrings(), (String)", ")));
                    throw new RegistrationFailedException(selectedThirdPartyToRegister + " is not a configured authentication source.", "local.identity.auth.source.invalid");
                }
                this.savePolicyAction(selectedThirdPartyToRegister, req, resp);
                TransactionalStateSupport txStateSupport = this.getTransactionalStateSupportForResumeUrl(inParameters);
                txStateSupport.setAttribute(RESUME_REGISTRATION, (Object)Boolean.TRUE, req, resp);
                return this.restartTree();
            }
            if (this.isRegisterOrUpdateUser(req, resp, inParameters)) {
                log.debug((Object)"Registering user.");
                List<LocalIdentityField<?>> requiredFields = this.localIdentityProfile.getFieldConfig().getFilteredRegistrationFields().stream().filter(LocalIdentityField::isRequired).collect(Collectors.toList());
                RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator(req, requiredFields, this.getLocaleUtil());
                requiredFieldValidator.validate();
                if (!this.isRegistrationFragmentDone(req, resp, inParameters) && !requiredFieldValidator.isValid()) {
                    log.debug((Object)"Required fields were missing. Re-rendering registration page with errors.");
                    return this.displayErrorsOnRegistrationPage(req, resp, inParameters, requiredFieldValidator.getErrors());
                }
                TransactionalStateSupport txStateSupport = this.getTransactionalStateSupportForResumeUrl(inParameters);
                txStateSupport.setAttribute(RESUME_REGISTRATION, (Object)Boolean.TRUE, req, resp);
                if (this.isRegistrationFragmentDone(req, resp, inParameters) && this.localIdentityProfile.getRegistrationConfig().isExecuteWorkflowAfterAccountCreation()) {
                    return this.doUpdateUser(req, resp, inParameters, allowInteraction);
                }
                return this.doSignUp(req, resp, inParameters, allowInteraction);
            }
            log.debug((Object)"Rendering the registration page.");
            if (!this.isLocalRegistration(inParameters)) {
                try {
                    String uniqueId = this.getUniqueId(inParameters, req);
                    String policyAction = this.getPolicyAction(inParameters);
                    String authSourceId = this.localIdentityProfile.getAuthSourceId(policyAction);
                    LocalIdentityStorageManager<DN> localIdentityStorageManager = this.localIdentityProfile.getStorageManager();
                    if (localIdentityStorageManager.identityExists(this.localIdentityProfile, authSourceId, uniqueId)) {
                        String messageKey = "local.identity.connection.error.registration.source.already.linked";
                        StandardTemplateMessage messageWrapper = new StandardTemplateMessage(messageKey, new String[]{policyAction});
                        this.renderErrorTemplate(req, resp, inParameters, messageWrapper, RESTART);
                        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                        return authnAdapterResponse;
                    }
                }
                catch (LocalIdentityException.UniqueIdNotFound uniqueId) {
                }
                catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                    log.error((Object)("Datastore communication failed: " + e.getMessage()));
                    throw new AuthnAdapterException("Datastore communication failed.", (Throwable)e);
                }
            }
            return this.displayRegistrationPage(req, resp, inParameters);
        }
        catch (RegistrationFailedException e) {
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                AuthnApiSupport.getDefault().writeErrorResponse(req, resp, e.getAuthnApiError());
                AuthnAdapterResponse response = new AuthnAdapterResponse();
                response.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return response;
            }
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    private boolean isRegisterOrUpdateUser(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        return "clicked".equals(req.getParameter(OK)) || CommonActionSpec.REGISTER_USER.isRequested(req) || this.isRegistrationFragmentDone(req, resp, inParameters);
    }

    private boolean isRegistrationFragmentDone(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        return "true".equals(req.getAttribute(REGISTRATION_FRAGMENT_DONE)) || this.isUpdateUserPostLipFragment(req, resp, inParameters);
    }

    private boolean isUpdateUserPostLipFragment(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        if (req == null || resp == null || inParameters == null) {
            return false;
        }
        TransactionalStateSupport transactionalStateSupport = this.getTransactionalStateSupportForResumeUrl(inParameters);
        Object attribute = transactionalStateSupport.getAttribute(UPDATE_USER_AFTER_LIP_FRAGMENT, req, resp);
        return Optional.ofNullable(attribute).filter(o -> o instanceof Boolean).map(o -> (Boolean)o).orElse(false);
    }

    private boolean isRegistrationCancelled(HttpServletRequest req) {
        return "clicked".equals(req.getParameter(CANCEL)) || "clicked".equals(req.getParameter(SIGN_ON)) || CommonActionSpec.CANCEL.isRequested(req);
    }

    private boolean isThirdPartyRegister(HttpServletRequest req) {
        String selectedThirdPartyToRegister = req.getParameter(ALTERNATE_THIRD_PARTY_REGISTER);
        return StringUtils.isNotBlank((String)selectedThirdPartyToRegister) || CommonActionSpec.ALTERNATIVE_AUTHENTICATION.isRequested(req);
    }

    private AuthnAdapterResponse doAltAuthLogin(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws TemplateRendererUtilException {
        Map<String, Object> userAttributes = Collections.singletonMap(THIRD_PARTY_SSO_ATTRIBUTE, Boolean.TRUE.toString());
        return this.successAndSSO(this.getPolicyAction(inParameters), userAttributes, req, resp, inParameters, allowInteraction);
    }

    private LocalIdentityDTO<DN> lookupUserByLink(String policyAction, Map<String, Object> inParameters, HttpServletRequest req) throws AuthnAdapterException, LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        log.debug((Object)"Attempting to lookup the local account.");
        String uniqueId = null;
        try {
            uniqueId = this.getUniqueId(inParameters, req);
        }
        catch (LocalIdentityException.UniqueIdNotFound e) {
            log.error((Object)"There was no unique ID provided for this request.");
            throw new AuthnAdapterException(GENERIC_ERROR_MESSAGE, (Throwable)e);
        }
        LocalIdentityStorageManager<DN> localIdentityStorageManager = this.localIdentityProfile.getStorageManager();
        try {
            String policyActionId = this.localIdentityProfile.getAuthSourceId(policyAction);
            return localIdentityStorageManager.getIdentityByLink(this.localIdentityProfile, policyActionId, uniqueId);
        }
        catch (LocalIdentityStorageManager.IdentityNotFoundException e) {
            if (StringUtils.isBlank((String)policyAction)) {
                log.error((Object)("No local account was found for unique id '" + uniqueId + "'."));
            } else {
                log.error((Object)("No user was found for auth source '" + policyAction + "' and unique ID '" + uniqueId + "'."));
            }
            throw e;
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)("Unable to lookup user due to " + e.getMessage()));
            throw e;
        }
    }

    private String getUniqueId(Map<String, Object> inParameters, HttpServletRequest req) throws LocalIdentityException.UniqueIdNotFound {
        return this.getUniqueId(inParameters, req, false);
    }

    private String getUniqueId(Map<String, Object> inParameters, HttpServletRequest req, boolean returnNullIfNotFound) throws LocalIdentityException.UniqueIdNotFound {
        AttributeMap inboundAttrs = this.getInboundAttributes(inParameters);
        String uniqueId = "";
        if (req != null && this.isLocalRegistration(inParameters)) {
            uniqueId = this.getUniqueIdFormValue(inboundAttrs, req);
            if (StringUtils.isBlank((String)uniqueId)) {
                if (returnNullIfNotFound) {
                    return null;
                }
                throw new LocalIdentityException.UniqueIdNotFound("No unique ID value was provided.");
            }
        } else {
            uniqueId = inboundAttrs.getSingleValue(THIRD_PARTY_UNIQUE_ID_ATTRIBUTE);
            if (StringUtils.isBlank((String)uniqueId)) {
                if (returnNullIfNotFound) {
                    return null;
                }
                throw new LocalIdentityException.UniqueIdNotFound("There was no value fulfilled for the attribute pf.local.identity.unique.id");
            }
        }
        return LocalIdentityUtils.getFormattedUniqueId(this.localIdentityProfile, uniqueId);
    }

    private String getUniqueIdFormValue(AttributeMap inboundAttrs, HttpServletRequest req) {
        String uniqueId = null;
        LocalIdentityField<?> field = this.localIdentityProfile.getFieldConfig().getUniqueIdField();
        if (field.isReadOnly() || field instanceof HiddenField) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking inbound attributes for a value for the unique field " + field.getData().getId()));
            }
            uniqueId = inboundAttrs.getSingleValue(field.getData().getId());
        } else {
            ParamMapping fieldMapping;
            Object uniqueIdObj;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking form data for a value for the unique field " + field.getData().getId()));
            }
            if ((uniqueIdObj = (fieldMapping = new ParamMapping(field.getData().getId(), RegisterUser.class, model -> model.getFieldValues().get(field.getData().getId()), model -> model)).getValue(req)) != null) {
                uniqueId = uniqueIdObj.toString();
            }
        }
        return uniqueId;
    }

    private AuthnAdapterResponse restartTree() {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.ACTION);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("policy.action", CANCEL_ACTION);
        authnAdapterResponse.setAttributeMap(attrs);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse doFragment(Map<String, Object> attributes) {
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.ACTION);
        attributes.put("policy.action", REGISTRATION_FRAGMENT_ACTION);
        authnAdapterResponse.setAttributeMap(attributes);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse displayRegistrationPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, TemplateMessageHolder messages) throws IOException {
        this.renderRegistrationPage(req, resp, inParameters, messages);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse displayRegistrationPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException {
        return this.displayRegistrationPage(req, resp, inParameters, null);
    }

    private AuthnAdapterResponse doSignUp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws IOException {
        try {
            Map<String, Object> attributes;
            UserToCreate userToCreate;
            LocalIdentityDTO<DN> dto;
            AttributeMap captchaResponseAttributes = null;
            if (this.shouldValidateCaptcha(req)) {
                CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)this.localIdentityProfile.getRegistrationConfig().getCaptchaProviderId());
                String uniqueId = this.getUniqueId(inParameters, req, true);
                CaptchaContext context = new CaptchaContext.Builder().setRequest(req).setResponse(resp).setAction("registration").setInParameters(CaptchaProviderUtil.filterInParameters(inParameters, uniqueId)).build();
                CaptchaResult captchaResult = captchaProvider.validateCaptcha(context);
                boolean isValid = captchaResult.isValid();
                if (!isValid) {
                    log.debug((Object)"Registration failed: reCAPTCHA validation failure.");
                    AuthnErrorDetail errorDetail = CommonErrorDetailSpec.CAPTCHA_ERROR.makeInstanceBuilder().userMessageKey("local.identity.registration.recaptcha.failure").build();
                    return this.displayErrorOnRegistrationPage(req, resp, inParameters, Collections.singletonList(errorDetail));
                }
                if (captchaResult.getResponseAttributes() != null) {
                    captchaResponseAttributes = captchaResult.getResponseAttributes();
                }
            }
            if ((dto = this.registerUser(req, resp, inParameters, userToCreate = (UserToCreate)this.getTransactionalStateSupportForResumeUrl(inParameters).removeAttribute(USER_TO_CREATE, req, resp), captchaResponseAttributes)) == null && StringUtils.isNotBlank((String)this.localIdentityProfile.getRegistrationConfig().getRegistrationWorkflowFragmentId())) {
                return this.doFragment(null);
            }
            Map<String, Object> map = attributes = dto != null ? dto.getAttributesForMapping() : null;
            if (this.localIdentityProfile.getEmailOwnershipVerificationConfig() != null && this.localIdentityProfile.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled() && !this.isEmailStatusVerified(attributes)) {
                SendEmailVerification sendEmailVerification = new SendEmailVerification();
                sendEmailVerification.sendEmail(req, resp, this.localIdentityProfile, dto, inParameters);
            }
            if (StringUtils.isNotBlank((String)this.localIdentityProfile.getRegistrationConfig().getRegistrationWorkflowFragmentId()) && this.localIdentityProfile.getRegistrationConfig().isExecuteWorkflowAfterAccountCreation()) {
                return this.doFragment(attributes);
            }
            this.getTransactionalStateSupportForResumeUrl(inParameters).removeAttribute(UPDATE_USER_AFTER_LIP_FRAGMENT, req, resp);
            this.updateDeviceSharingType(req, resp, attributes);
            if (this.getPolicyAction(inParameters).equals("identity.registration")) {
                this.createAuthnSessionForLocalAccount(req, inParameters, attributes, userToCreate);
            }
            return this.successAndSSO(this.getPolicyAction(inParameters), attributes, req, resp, inParameters, allowInteraction);
        }
        catch (TemplateRendererUtilException e) {
            throw e;
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)("Registration failed due to: " + e.getMessage()));
            log.debug((Object)"Registration failed.", (Throwable)e);
            LocalIdentityManagementResult result = e.getResult();
            String errorMessageKey = result == null ? LocalIdentityManagementResult.getDefaultResult().getMessageKey() : result.getMessageKey();
            AuthnErrorDetail errorDetail = CommonErrorDetailSpec.REGISTRATION_FAILED.makeInstanceBuilder().userMessageKey(errorMessageKey).build();
            return this.displayErrorOnRegistrationPage(req, resp, inParameters, Collections.singletonList(errorDetail));
        }
        catch (AuthnAdapterException e) {
            log.error((Object)("Registration failed due to: " + e.getMessage()));
            log.debug((Object)"Registration failed.", (Throwable)e);
            String messageKey = LOCAL_IDENTITY_REGISTRATION_GENERIC_FAILURE;
            if (e instanceof AuthnAdapterException.NonUniqueUserException) {
                messageKey = "local.identity.registration.nonuniqueuser.failure";
            } else if (e instanceof AuthnAdapterException.NoUniqueIdException) {
                messageKey = "local.identity.registration.uniqueidnotfound.failure";
            }
            AuthnErrorDetail errorDetail = CommonErrorDetailSpec.REGISTRATION_FAILED.makeInstanceBuilder().userMessageKey(messageKey).build();
            return this.displayErrorOnRegistrationPage(req, resp, inParameters, Collections.singletonList(errorDetail));
        }
        catch (Exception e) {
            log.error((Object)("Registration failed due to: " + e.getMessage()));
            log.debug((Object)"Registration failed.", (Throwable)e);
            AuthnErrorDetail errorDetail = CommonErrorDetailSpec.REGISTRATION_FAILED.makeInstanceBuilder().userMessageKey(LOCAL_IDENTITY_REGISTRATION_GENERIC_FAILURE).build();
            return this.displayErrorOnRegistrationPage(req, resp, inParameters, Collections.singletonList(errorDetail));
        }
    }

    private void updateDeviceSharingType(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> attributes) {
        if (this.localIdentityProfile.getRegistrationConfig().isThisIsMyDeviceEnabled()) {
            DeviceSharingType deviceSharingType = this.isSharedMachine(req, resp, attributes) ? DeviceSharingType.SHARED : DeviceSharingType.PRIVATE;
            attributes.put("org.sourceid.saml20.adapter.idp.authn.deviceSharingType", deviceSharingType.name());
        }
    }

    private boolean shouldValidateCaptcha(HttpServletRequest req) {
        if (!this.localIdentityProfile.getRegistrationConfig().isCaptchaEnabled()) {
            return false;
        }
        if (StringUtils.isNotBlank((String)this.localIdentityProfile.getRegistrationConfig().getRegistrationWorkflowFragmentId())) {
            return !this.isRegistrationFragmentDone(req, null, null);
        }
        return true;
    }

    private AuthnAdapterResponse doUpdateUser(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) {
        try {
            UserToCreate userToCreate = (UserToCreate)this.getTransactionalStateSupportForResumeUrl(inParameters).removeAttribute(USER_TO_CREATE, req, resp);
            LocalIdentityDTO<DN> dto = this.updateUser(userToCreate, req, resp);
            this.getTransactionalStateSupportForResumeUrl(inParameters).removeAttribute(UPDATE_USER_AFTER_LIP_FRAGMENT, req, resp);
            Map<String, Object> attributes = dto.getAttributesForMapping();
            this.updateDeviceSharingType(req, resp, attributes);
            if (this.getPolicyAction(inParameters).equals("identity.registration")) {
                this.createAuthnSessionForLocalAccount(req, inParameters, attributes, userToCreate);
            }
            return this.successAndSSO(this.getPolicyAction(inParameters), attributes, req, resp, inParameters, allowInteraction);
        }
        catch (Exception e) {
            log.error((Object)("Registration update failed due to: " + e.getMessage()));
            log.debug((Object)"Registration update failed.", (Throwable)e);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            authnAdapterResponse.setErrorMessage("Account update failed.");
            return authnAdapterResponse;
        }
    }

    private void createAuthnSessionForLocalAccount(HttpServletRequest req, Map<String, Object> inParameters, Map<String, Object> attributes, UserToCreate userToCreate) {
        block6: {
            if (this.localIdentityProfile.getRegistrationConfig().isCreateSessionAfterRegistration()) {
                List adapterIdsToCreateSessionFor = (List)inParameters.get(LIP_SESSION_ADAPTERS);
                HashMap regAdapterAttrs = new HashMap();
                try {
                    String password = (String)PASSWORD_MAPPING.getValue(req);
                    String username = this.getUsernameValue(inParameters, req, userToCreate);
                    if (StringUtils.isBlank((String)password) && userToCreate != null) {
                        password = userToCreate.getNewPassword();
                    }
                    if (StringUtils.isNotBlank((String)username)) {
                        String finalUsername = username;
                        String finalPassword = password;
                        adapterIdsToCreateSessionFor.forEach(authnSourceKey -> {
                            String adapterId = authnSourceKey.getId();
                            AdapterManager adapterManager = MgmtFactory.getAdapterManager();
                            IdpAuthenticationAdapter adapterToCreateSessionFor = adapterManager.getIdpAuthnAdapter((AuthnSourceKey)authnSourceKey);
                            if (adapterToCreateSessionFor instanceof PostRegistrationSessionAwareAdapter) {
                                log.debug((Object)("Attempting to authenticate this user via the '" + adapterId + "' to create a session."));
                                Map map = ((PostRegistrationSessionAwareAdapter)adapterToCreateSessionFor).authenticateUser(finalUsername, finalPassword, Collections.emptyMap());
                                if (map != null && map.size() > 0) {
                                    regAdapterAttrs.put(authnSourceKey, map);
                                } else {
                                    log.warn((Object)("Unable to authenticate this user against all password credential validators configured in '" + adapterId + "'. Unable to create a session for that adapter."));
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug((Object)(adapterId + " does not implement " + PostRegistrationSessionAwareAdapter.class.getCanonicalName() + ". PingFederate will not create an authn session for it post-registration."));
                            }
                        });
                        attributes.put(LIP_REG_ADAPTER_ATTRS, regAdapterAttrs);
                        break block6;
                    }
                    log.warn((Object)"The username was empty for this user. Unable to create a session.");
                }
                catch (LocalIdentityException.UniqueIdNotFound uniqueIdNotFound) {
                    log.warn((Object)("Unable to create a session. Unable to locate the username value to authenticate with. " + uniqueIdNotFound.getMessage()));
                }
            } else {
                log.debug((Object)"This identity profile is configured not to create a session after registration. Skipping creating a session.");
            }
        }
    }

    private String getUsernameValue(Map<String, Object> inParameters, HttpServletRequest req, UserToCreate userToCreate) throws LocalIdentityException.UniqueIdNotFound {
        String usernameField = this.localIdentityProfile.getRegistrationConfig().getFieldForUsername();
        if (StringUtils.isNotBlank((String)usernameField) && userToCreate != null && userToCreate.getAttributesKeyValueMap().containsKey(usernameField)) {
            String username = userToCreate.getAttributesKeyValueMap().get(usernameField).getFirstValue().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using value for the " + usernameField + " field as the username."));
            }
            return LocalIdentityUtils.getFormattedUniqueId(this.localIdentityProfile, username);
        }
        if (StringUtils.isBlank((String)usernameField) && userToCreate != null) {
            return LocalIdentityUtils.getFormattedUniqueId(this.localIdentityProfile, userToCreate.getIdentityId());
        }
        if (StringUtils.isNotBlank((String)usernameField)) {
            ParamMapping fieldMapping = new ParamMapping(usernameField, RegisterUser.class, model -> model.getFieldValues().get(usernameField).toString(), model -> model);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using value for the " + usernameField + " field as the username."));
            }
            return LocalIdentityUtils.getFormattedUniqueId(this.localIdentityProfile, (String)fieldMapping.getValue(req));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using the unique ID value as the username.");
        }
        return this.getUniqueId(inParameters, req);
    }

    private AuthnAdapterResponse displayErrorOnRegistrationPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, List<AuthnErrorDetail> errorDetails) throws IOException {
        LocalIdentityGeneralError error = new LocalIdentityGeneralError();
        errorDetails.forEach(error::addErrorDetail);
        return this.displayErrorsOnRegistrationPage(req, resp, inParameters, error);
    }

    private AuthnAdapterResponse displayErrorsOnRegistrationPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, LocalIdentityError<?> errors) throws IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        authnAdapterResponse.setErrorMessage("Registration failed.");
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            try {
                AuthnApiSupport.getDefault().writeErrorResponse(req, resp, errors.getApiError());
            }
            catch (IOException e) {
                log.error((Object)("Could not send API error response due to: " + e.getMessage()));
                throw e;
            }
        } else {
            TemplateMessageHolder messages = new TemplateMessageHolder();
            errors.getTemplateMessages().forEach(messages::addMessage);
            this.renderRegistrationPage(req, resp, inParameters, messages);
        }
        return authnAdapterResponse;
    }

    private LocalIdentityDTO<DN> registerUser(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, UserToCreate userToCreate, AttributeMap captchaResponseAttributes) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException, AuthnAdapterException, RegistrationFailedException {
        LocalIdentityStorageManager<DN> localIdentityStorageManager = this.localIdentityProfile.getStorageManager();
        String password = (String)PASSWORD_MAPPING.getValue(req);
        String policyAction = this.getPolicyAction(inParameters);
        try {
            String uniqueId;
            String thirdParty;
            Map<String, FieldData<?>> userAttributes;
            String thirdPartyAttrs = null;
            if (userToCreate != null) {
                userAttributes = userToCreate.getAttributesKeyValueMap();
                thirdParty = userToCreate.getThirdParty();
                uniqueId = userToCreate.getIdentityId();
                thirdPartyAttrs = userToCreate.getThirdPartyAttrs();
                password = userToCreate.getNewPassword();
            } else {
                uniqueId = this.getUniqueId(inParameters, req);
                LocalIdentityAuthSource authSource = this.localIdentityProfile.getAuthSource(policyAction);
                thirdParty = authSource.getId();
                if (authSource.isLocalAccountAuthSource() && password == null) {
                    throw new AuthnAdapterException("No password was supplied in the request.");
                }
                if (localIdentityStorageManager.identityExists(this.localIdentityProfile, authSource.getId(), uniqueId)) {
                    throw new LocalIdentityException.IdentityIsNotUniqueException("Identity is not unique", authSource, uniqueId);
                }
                if (!authSource.isLocalAccountAuthSource()) {
                    LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.AUTHN_SOURCE_CONNECT, null, this.localIdentityProfile, authSource.getId(), req, resp);
                    String uniqueIdFieldValue = this.getUniqueId(inParameters, req);
                    if (StringUtils.isNotBlank((String)uniqueIdFieldValue) && localIdentityStorageManager.identityExists(this.localIdentityProfile, LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE.getId(), uniqueIdFieldValue)) {
                        throw new LocalIdentityException.IdentityIsNotUniqueException("Identity is not unique", LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE, uniqueIdFieldValue);
                    }
                    AuthSourceAttributeUpdateProcessor attributeProcessor = new AuthSourceAttributeUpdateProcessor(authSource, inParameters);
                    thirdPartyAttrs = attributeProcessor.getJsonString();
                    LocalIdentityAuditLogger.setUserName(uniqueIdFieldValue);
                    LocalIdentityAuditLogger.setLocalUserId(this.getUniqueIdFormValue(this.getInboundAttributes(inParameters), req));
                    LocalIdentityAuditLogger.log();
                }
                userAttributes = this.getRegistrationFieldValues(this.localIdentityProfile, req, this.getInboundAttributes(inParameters));
                Map<String, FieldData<?>> hiddenFieldData = this.getHiddenFieldData(this.getInboundAttributes(inParameters));
                this.doUpdateEmailVerifyStatus(userAttributes, this.getInboundAttributes(inParameters), hiddenFieldData);
                userAttributes.putAll(hiddenFieldData);
                if (StringUtils.isNotBlank((String)this.localIdentityProfile.getRegistrationConfig().getRegistrationWorkflowFragmentId())) {
                    userToCreate = new UserToCreate(userAttributes, password, authSource.getId(), uniqueId, thirdPartyAttrs);
                    userToCreate.addTransientAttributeMap(captchaResponseAttributes);
                    this.getTransactionalStateSupportForResumeUrl(inParameters).setAttribute(USER_TO_CREATE, (Object)userToCreate, req, resp);
                    if (!this.localIdentityProfile.getRegistrationConfig().isExecuteWorkflowAfterAccountCreation()) {
                        return null;
                    }
                }
            }
            LocalIdentityDTO<DN> localIdentityDTOCreate = localIdentityStorageManager.addIdentity(this.localIdentityProfile, userAttributes, password, thirdParty, uniqueId, thirdPartyAttrs);
            LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.REGISTER, localIdentityDTOCreate, this.localIdentityProfile, null, req, resp);
            LocalIdentityAuditLogger.setAttributes(this.localIdentityProfile.getFieldConfig().getFilteredRegistrationFields(), userAttributes);
            LocalIdentityAuditLogger.log();
            this.saveDNtoSession(localIdentityDTOCreate.getIdentifier(), req, resp, inParameters);
            return localIdentityDTOCreate;
        }
        catch (LocalIdentityException.UniqueIdNotFound e) {
            log.error((Object)"There was no unique ID provided for this user at registration. Make sure the attribute is fulfilled before getting to the Registration page.");
            throw new AuthnAdapterException.NoUniqueIdException("Registration Failed.", (Throwable)e);
        }
        catch (LocalIdentityException.IdentityIsNotUniqueException e) {
            log.error((Object)"The provided user identifier is not unique.");
            throw new AuthnAdapterException.NonUniqueUserException(e.getValidationMessage(), (Throwable)e);
        }
    }

    LocalIdentityDTO<DN> updateUser(UserToCreate user, HttpServletRequest req, HttpServletResponse resp) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        if (user != null) {
            Map<String, FieldData<?>> updatedAttributes = user.getAttributesKeyValueMap();
            LocalIdentityStorageManager<DN> localIdentityStorageManager = this.localIdentityProfile.getStorageManager();
            LocalIdentityDTO<DN> dto = localIdentityStorageManager.getIdentityByDn(this.localIdentityProfile, this.getDNFromSession(req, resp));
            return localIdentityStorageManager.updateIdentity(this.localIdentityProfile, dto.getIdentifier(), updatedAttributes);
        }
        throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException("No user found in session state to update.");
    }

    private void doUpdateEmailVerifyStatus(Map<String, FieldData<?>> userAttributes, AttributeMap inboundAttributes, Map<String, FieldData<?>> hiddenFieldData) {
        if (this.localIdentityProfile.getEmailOwnershipVerificationConfig() != null && this.localIdentityProfile.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled()) {
            String statusLipFieldId = this.localIdentityProfile.getEmailOwnershipVerificationConfig().getFieldStoringVerificationStatus();
            String emailFieldId = this.localIdentityProfile.getEmailOwnershipVerificationConfig().getFieldUsedForOwnershipVerification();
            String newEmailValue = userAttributes.get(emailFieldId).getFirstValue().toString();
            String oldEmailValue = inboundAttributes.getSingleValue(emailFieldId);
            if (!StringUtils.equalsIgnoreCase((String)oldEmailValue, (String)newEmailValue)) {
                if (log.isDebugEnabled()) {
                    if (oldEmailValue == null) {
                        log.debug((Object)("Setting " + statusLipFieldId + " to FALSE because the email was not fulfilled on the inbound mapping."));
                    } else {
                        log.debug((Object)("Setting " + statusLipFieldId + " to FALSE because the email was changed on the registration page."));
                    }
                }
                String[] fieldValues = new String[]{"FALSE"};
                hiddenFieldData.put(statusLipFieldId, new StringFieldData(statusLipFieldId, false, fieldValues));
            }
        }
    }

    private Map<String, FieldData<?>> getHiddenFieldData(AttributeMap inboundAttributes) {
        HashMap values = new HashMap();
        this.getHiddenFieldFromInboundAttributes(inboundAttributes).forEach((key, value) -> {
            String[] fieldValues = value instanceof Collection ? ((Collection)value).toArray(new String[0]) : new String[]{(String)value};
            values.put(key.getData().getId(), key.getFieldData(fieldValues));
        });
        return values;
    }

    private Map<String, Object> getHiddenFieldValues(Map<String, Object> inParameters) {
        AttributeMap inboundAttributes = this.getInboundAttributes(inParameters);
        return this.getHiddenFieldFromInboundAttributes(inboundAttributes).entrySet().stream().collect(Collectors.toMap(p -> ((LocalIdentityField)p.getKey()).getData().getId(), Map.Entry::getValue));
    }

    private Map<LocalIdentityField<?>, Object> getHiddenFieldFromInboundAttributes(AttributeMap inboundAttributes) {
        HashMap values = new HashMap();
        for (LocalIdentityField<?> hiddenRegistrationField : this.localIdentityProfile.getFieldConfig().getListOfHiddenRegistrationFields()) {
            AttributeValue attributeValue = (AttributeValue)inboundAttributes.get((Object)hiddenRegistrationField.getData().getId());
            if (attributeValue == null) continue;
            if (attributeValue.isMultiValue()) {
                values.put(hiddenRegistrationField, attributeValue.getValuesAsCollection());
                continue;
            }
            values.put(hiddenRegistrationField, attributeValue.getValue());
        }
        return values;
    }

    private void saveDNtoSession(DN dn, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        this.sessionStateSupport.setAttribute(this.localIdentityProfile.getAdapterDnStateKey(), (Object)dn.toNormalizedString(), req, resp, true);
        this.saveToSessionStateForProfileManagement(dn, req, resp);
    }

    private DN getDNFromSession(HttpServletRequest req, HttpServletResponse resp) {
        Object sessionValue = this.sessionStateSupport.getAttribute(this.localIdentityProfile.getId() + "-userDN", req, resp);
        if (sessionValue != null) {
            try {
                return new DN((String)sessionValue);
            }
            catch (LDAPException e) {
                log.warn((Object)("DN value for saved for this session is not valid. The DN retrieved was '" + sessionValue + "'"));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, FieldData<?>> getRegistrationFieldValues(LocalIdentityProfile localIdentityProfile, HttpServletRequest req, AttributeMap inboundAttrs) throws RegistrationFailedException {
        HashMap attributesKeyValueMap = new HashMap();
        List<LocalIdentityField<?>> registrationFields = localIdentityProfile.getFieldConfig().getFilteredRegistrationFields();
        for (LocalIdentityField<?> field : registrationFields) {
            ParamMapping fieldMapping = new ParamMapping(field.getData().getId(), RegisterUser.class, model -> model.getFieldValues().get(field.getData().getId()), model -> model);
            if (field.isReadOnly()) {
                String id = field.getData().getId();
                String value = inboundAttrs.getSingleValue(id);
                if (value == null) continue;
                attributesKeyValueMap.put(id, field.getFieldData(new String[]{value}));
                continue;
            }
            String[] values = null;
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                Object valueFromRequest = fieldMapping.getValue(req);
                if (valueFromRequest != null) {
                    if (field.isMultiValue()) {
                        ArrayList allValidValues = new ArrayList();
                        if (!(valueFromRequest instanceof Map)) throw new RegistrationFailedException("The value for field '" + field.getData().getId() + "' was expected to be a Map object but instead was '" + valueFromRequest.getClass() + "'. Please send an object of all the options and their values for field type " + field.getName());
                        Map multiValueFields = (Map)valueFromRequest;
                        field.getData().getOptions().forEach(option -> {
                            if (multiValueFields.containsKey(option) && this.isTrue(multiValueFields.get(option))) {
                                allValidValues.add(option);
                            }
                        });
                        values = allValidValues.toArray(new String[0]);
                    } else {
                        values = new String[]{valueFromRequest.toString()};
                    }
                }
            } else {
                values = req.getParameterValues(field.getData().getId());
            }
            if (values == null) continue;
            attributesKeyValueMap.put(field.getData().getId(), field.getFieldData(values));
        }
        return attributesKeyValueMap;
    }

    private boolean isTrue(Object value) {
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            return true;
        }
        return value instanceof String && Boolean.parseBoolean((String)value);
    }

    private void renderRegistrationPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, TemplateMessageHolder messages) throws IOException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            try {
                this.setAdapterApiState(req, AdapterApiState.REGISTER);
                this.doAuthnApi(req, resp, inParameters);
            }
            catch (IOException e) {
                log.error((Object)"Unable to render an Authn API response.", (Throwable)e);
            }
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String resumeUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
            params.put("url", resumeUrl);
            params.put("fields", this.localIdentityProfile.getFieldConfig().getFilteredRegistrationFields());
            params.put(IS_LOCAL_REGISTRATION_PARAM, this.isLocalRegistration(inParameters));
            params.put("altAuthSources", this.filterWebAuthNSource(req, this.localIdentityProfile.getAuthSourceStrings()));
            params.put("pass", PASS);
            params.put("ok", OK);
            params.put("cancel", CANCEL);
            params.put("signOn", SIGN_ON);
            params.put(MESSAGES_PARAM, messages);
            params.put("populateValues", this.getFieldFillInValues(req, inParameters));
            params.put("hiddenFieldValues", this.getHiddenFieldValues(inParameters));
            params.put("alternateThirdPartyRegister", ALTERNATE_THIRD_PARTY_REGISTER);
            params.put("isDirectLink", this.isDirectLink(req, resp));
            if (this.localIdentityProfile.getRegistrationConfig().isThisIsMyDeviceEnabled()) {
                params.put("showMyDeviceCheckbox", true);
                params.put("myDevice", MY_DEVICE);
                params.put("myDeviceChecked", this.isMyDeviceChecked(req) ? "checked" : "");
            } else {
                params.put("showMyDeviceCheckbox", false);
            }
            if (this.localIdentityProfile.isRegistrationEnabled()) {
                params.put("captchaEnabled", this.localIdentityProfile.getRegistrationConfig().isCaptchaEnabled());
                if (this.localIdentityProfile.getRegistrationConfig().isCaptchaEnabled()) {
                    CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)this.localIdentityProfile.getRegistrationConfig().getCaptchaProviderId());
                    CaptchaContext captchaContext = new CaptchaContext.Builder().setAction("registration").setRequest(req).setResponse(resp).setInParameters(CaptchaProviderUtil.filterInParameters(inParameters)).build();
                    params.put("captchaScriptName", captchaProvider.getJavaScriptFileName());
                    Map captchaAttributes = captchaProvider.getCaptchaAttributes(captchaContext);
                    params.put("captchaAttributes", mapper.writeValueAsString((Object)captchaAttributes));
                    if ("reCAPTCHA v2 Invisible".equals(captchaProvider.getPluginDescriptor().getType())) {
                        params.put("siteKey", captchaAttributes.get("siteKey"));
                    }
                }
            }
            this.renderTemplate(req, resp, this.localIdentityProfile.getRegistrationConfig().getTemplateName(), params);
        }
    }

    private boolean isSharedMachine(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        if (this.localIdentityProfile.isRegistrationEnabled() && this.localIdentityProfile.getRegistrationConfig().isThisIsMyDeviceEnabled()) {
            if (this.isRegistrationPosted(req)) {
                return !this.isMyDeviceChecked(req);
            }
            if (LocalIdentityAdapter.isRequireVerifiedEmailPosted(req)) {
                Object isSharedMachineObj = this.getTransactionalStateSupportForResumeUrl(inParameters).getAttribute(REGISTRATION_SHARED_MACHINE, req, resp);
                return isSharedMachineObj != null && (Boolean)isSharedMachineObj != false;
            }
        }
        return false;
    }

    private boolean isRegistrationPosted(HttpServletRequest req) {
        return req.getParameter("isRegisterForm") != null || CommonActionSpec.REGISTER_USER.isRequested(req);
    }

    private boolean isMyDeviceChecked(HttpServletRequest req) {
        if (this.localIdentityProfile.getRegistrationConfig().isThisIsMyDeviceEnabled() && this.isRegistrationPosted(req)) {
            ParamMapping myDeviceMapping = new ParamMapping(MY_DEVICE, RegisterUser.class, model -> Boolean.toString(model.isThisIsMyDevice()), Function.identity());
            String value = (String)myDeviceMapping.getValue(req);
            CheckboxField field = new CheckboxField();
            return field.isCheckedValue(value);
        }
        return false;
    }

    private void renderErrorTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, StandardTemplateMessage error, String continueValue) throws IOException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            this.setAdapterApiErrorState(req, true);
            AccountLinkingFailed model = new AccountLinkingFailed();
            String[] errorMsgParams = (String[])error.getParams();
            String errorMsg = LocaleUtil.getLocalizedString(req, "pingfederate-messages", error.getMessageKey(), errorMsgParams);
            model.setUserMessage(errorMsg);
            AuthnState authnState = CommonStateSpec.ACCOUNT_LINKING_FAILED.makeInstance(req, (Object)model);
            if (StringUtils.equals((String)continueValue, (String)RESTART)) {
                authnState.removeAction(CommonActionSpec.CONTINUE.getId());
            }
            if (StringUtils.equals((String)continueValue, (String)OK)) {
                authnState.removeAction(CommonActionSpec.RESTART.getId());
            }
            AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, authnState);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String resumeUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
            params.put("url", resumeUrl);
            params.put("continue", continueValue);
            params.put("error", error);
            this.renderTemplate(req, resp, "local.identity.connection.error.html", params);
        }
    }

    private boolean isLocalRegistration(Map<String, Object> inParameters) {
        String requestedAction = this.getPolicyAction(inParameters);
        if (requestedAction.equals("identity.registration")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getPolicyAction(Map<String, Object> inParameters) {
        Object requestedAction;
        Object chainedAttrs = inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        if (chainedAttrs != null && (requestedAction = ((Map)chainedAttrs).get("policy.action")) != null) {
            return ((AttributeValue)requestedAction).getValue();
        }
        return "";
    }

    private AttributeMap getInboundAttributes(Map<String, Object> inParameters) {
        Object inboundAttrs = inParameters.get("inboundAttributes");
        if (inboundAttrs != null) {
            return (AttributeMap)inboundAttrs;
        }
        return new AttributeMap();
    }

    private void renderTemplate(HttpServletRequest req, HttpServletResponse resp, String templateName, Map<String, Object> params) throws TemplateRendererUtilException {
        try {
            this.getTemplateRenderer().render(req, resp, templateName, params);
        }
        catch (Exception e) {
            log.error((Object)String.format("Failed to render template for local identity profile '%s'", this.localIdentityProfile.getId()));
            throw e;
        }
    }

    void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    private Map<String, Object> getFieldFillInValues(HttpServletRequest req, Map<String, Object> inParameters) {
        HashMap<String, Object> values = new HashMap<String, Object>(this.localIdentityProfile.getFieldConfig().getFilteredRegistrationFields().size());
        AttributeMap inboundAttrs = this.getInboundAttributes(inParameters);
        this.localIdentityProfile.getFieldConfig().getListOfAllFields().forEach(field -> {
            String inboundValue;
            String fieldId = field.getData().getId();
            Object fillInValue = "";
            if (field.getConfig().isShowDefaultValueField() && StringUtils.isNotBlank((String)field.getData().getDefaultValue())) {
                fillInValue = field.getData().getDefaultValue();
                if (log.isDebugEnabled()) {
                    String[] logValue = fillInValue;
                    if (field.isMasked()) {
                        logValue = "*****";
                    }
                    log.debug((Object)("Found default value '" + logValue + "' for field '" + fieldId + "'."));
                }
            }
            if ((inboundValue = this.getInboundValueFor((LocalIdentityField<?>)field, inboundAttrs)) != null) {
                if (log.isDebugEnabled()) {
                    String[] logValue = fillInValue;
                    if (field.isMasked()) {
                        logValue = "*****";
                    }
                    log.debug((Object)("Found inbound mapped value '" + logValue + "' for field '" + fieldId + "'."));
                }
                fillInValue = inboundValue;
            }
            if (StringUtils.isNotBlank((String)req.getParameter(fieldId)) && !AuthnApiSupport.getDefault().isApiRequest(req)) {
                String[] parameterValues = req.getParameterValues(fieldId);
                if (parameterValues.length > 1 || field.isMultiValue()) {
                    fillInValue = parameterValues;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Values already provided for '" + fieldId + "'."));
                    }
                } else {
                    fillInValue = parameterValues[0];
                    if (log.isDebugEnabled()) {
                        Object logValue = fillInValue;
                        if (field.isMasked()) {
                            logValue = "*****";
                        }
                        log.debug((Object)("'" + logValue + "' is already the value for field '" + fieldId + "'."));
                    }
                }
            }
            values.put(fieldId, fillInValue);
        });
        return values;
    }

    private String getInboundValueFor(LocalIdentityField<?> field, AttributeMap inboundAttrs) {
        if (inboundAttrs != null && StringUtils.isNotBlank((String)inboundAttrs.getSingleValue(field.getData().getId()))) {
            String inboundValue = inboundAttrs.getSingleValue(field.getData().getId());
            if (field.getData().getOptions() != null && field.getData().getOptions().size() > 0) {
                if (!field.getData().getOptions().contains(inboundValue)) {
                    String logValue = inboundValue;
                    if (field.isMasked()) {
                        logValue = "*****";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Inbound value '" + logValue + "' found for field '" + field.getData().getId() + "'. This value doesn't match any options."));
                    }
                    return null;
                }
                return inboundValue;
            }
            return inboundAttrs.getSingleValue(field.getData().getId());
        }
        return null;
    }

    private AuthnAdapterResponse successAndSSO(String policyAction, Map<String, Object> userAttributes, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws TemplateRendererUtilException {
        return this.successAndSSO(policyAction, userAttributes, req, resp, inParameters, allowInteraction, null, null);
    }

    private AuthnAdapterResponse successAndSSO(String policyAction, Map<String, Object> userAttributes, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction, TemplateBannerMessage bannerMessage, AuthnError authnError) throws TemplateRendererUtilException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        authnAdapterResponse.setAttributeMap(userAttributes);
        boolean isSharedMachine = this.isSharedMachine(req, resp, userAttributes);
        if (!isSharedMachine) {
            this.savePolicyAction(policyAction, req, resp);
        }
        if (this.isEmailVerificationRequest(inParameters) || this.isProfileManagementRequest(inParameters)) {
            return authnAdapterResponse;
        }
        if ((this.requireVerifiedEmail() || this.initialRegistrationWithOtpEmailVerificationType(req, resp, inParameters)) && !this.isEmailStatusVerified(userAttributes)) {
            if (!allowInteraction) {
                return this.failureResponse();
            }
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            if (userAttributes.containsKey(LIP_REG_ADAPTER_ATTRS)) {
                userAttributes.put(REGISTRATION_PENDING_EMAIL_VERIFY, true);
            }
            if (this.isRegistrationPosted(req)) {
                this.getTransactionalStateSupportForResumeUrl(inParameters).setAttribute(REGISTRATION_SHARED_MACHINE, (Object)isSharedMachine, req, resp);
            }
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                this.writeAuthnApiResponse(req, resp, userAttributes, authnError);
            } else if (LocalIdentityUtils.isOtpEmailVerificationType(this.localIdentityProfile)) {
                this.renderOtpEmailVerificationTemplate(req, resp, userAttributes, inParameters, bannerMessage);
            } else {
                this.renderRequireVerifiedEmailTemplate(req, resp, userAttributes, inParameters, bannerMessage);
            }
        } else {
            this.getTransactionalStateSupportForResumeUrl(inParameters).removeAttribute(REGISTRATION_SHARED_MACHINE, req, resp);
        }
        return authnAdapterResponse;
    }

    private void savePolicyAction(String requestedAction, HttpServletRequest req, HttpServletResponse resp) {
        if (!requestedAction.equals("identity.registration")) {
            this.sessionStateSupport.setAttribute(this.localIdentityProfile.getPolicyActionStateKey(), (Object)requestedAction, req, resp, false);
        }
    }

    private String getPreviousPolicyAction(HttpServletRequest req, HttpServletResponse resp) {
        Object previousRequestedAction = this.sessionStateSupport.getAttribute(this.localIdentityProfile.getPolicyActionStateKey(), req, resp);
        if (previousRequestedAction != null) {
            return (String)previousRequestedAction;
        }
        return "";
    }

    private void removePolicyAction(HttpServletRequest req, HttpServletResponse resp) {
        this.sessionStateSupport.removeAttribute(this.localIdentityProfile.getPolicyActionStateKey(), req, resp);
    }

    private void removeResumeRegistration(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        TransactionalStateSupport txStateSupport = this.getTransactionalStateSupportForResumeUrl(inParameters);
        txStateSupport.removeAttribute(RESUME_REGISTRATION, req, resp);
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        return new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, "Local Identity Profile", Collections.emptySet(), true, true);
    }

    public void configure(Configuration configuration) {
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String partnerSpEntityId, AuthnPolicy authnPolicy, String resumePath) throws AuthnAdapterException, IOException {
        return null;
    }

    public boolean logout(HttpServletRequest req, HttpServletResponse resp) {
        log.debug((Object)"Clearing user state in the Local Identity Adapter.");
        this.localIdentityProfile.clearSession((SessionStateSupport)this.sessionStateSupport, req, resp);
        return true;
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        return this.logout(req, resp);
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    @Override
    public boolean getMaskOgnlValues() {
        return this.localIdentityProfile.getFieldConfig() != null && this.localIdentityProfile.getFieldConfig().isMaskAllOgnlFields();
    }

    @Override
    public Set<String> getMaskedFields() {
        if (this.localIdentityProfile.getFieldConfig() != null) {
            return this.localIdentityProfile.getFieldConfig().getListOfAllFields().stream().filter(LocalIdentityField::isMasked).map(field -> field.getData().getId()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public AttributeMapping getEffectiveAttributeMap() {
        return null;
    }

    private TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    private boolean isRegistration(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        TransactionalStateSupport txStateSupport;
        Object resumeRegistrationObj;
        boolean isRegistration = false;
        if (LocalIdentityAdapter.getAdapterApiState(req) == AdapterApiState.REGISTER) {
            isRegistration = true;
        }
        if (!isRegistration && this.isRegistrationPosted(req)) {
            isRegistration = true;
        }
        String policyAction = this.getPolicyAction(inParameters);
        if (!isRegistration && policyAction != null && policyAction.equals("identity.registration")) {
            isRegistration = true;
        }
        if (!isRegistration && (resumeRegistrationObj = (txStateSupport = this.getTransactionalStateSupportForResumeUrl(inParameters)).getAttribute(RESUME_REGISTRATION, req, resp)) != null && ((Boolean)resumeRegistrationObj).booleanValue()) {
            isRegistration = true;
        }
        if (isRegistration) {
            this.setAdapterApiState(req, AdapterApiState.REGISTER);
        }
        return isRegistration;
    }

    private TransactionalStateSupport getTransactionalStateSupportForResumeUrl(Map<String, Object> inParameters) {
        if (this.transactionalStateSupport == null) {
            String resumeUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
            this.transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
        }
        return this.transactionalStateSupport;
    }

    private void setAdapterApiState(HttpServletRequest req, AdapterApiState state) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            InternalAuthnApiSupport.getDefault().getStateParams(req).put(ADAPTER_API_STATE_PARAM_KEY, state);
        }
    }

    private static AdapterApiState getAdapterApiState(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            Object state = LocalIdentityAdapter.getFromReqStateParams(req, ADAPTER_API_STATE_PARAM_KEY);
            return state != null ? (AdapterApiState)((Object)state) : null;
        }
        return null;
    }

    private void removeAdapterApiState(HttpServletRequest req) {
        Map stateParams;
        if (AuthnApiSupport.getDefault().isApiRequest(req) && (stateParams = InternalAuthnApiSupport.getDefault().getStateParams(req)) != null) {
            stateParams.remove(ADAPTER_API_STATE_PARAM_KEY);
        }
    }

    private void setAdapterApiErrorState(HttpServletRequest req, boolean state) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            InternalAuthnApiSupport.getDefault().getStateParams(req).put(ADAPTER_API_ERROR_STATE_PARAM_KEY, state);
        }
    }

    private boolean isRegistrationError(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            Object paramVal = LocalIdentityAdapter.getFromReqStateParams(req, ADAPTER_API_ERROR_STATE_PARAM_KEY);
            return paramVal instanceof Boolean && (Boolean)paramVal != false;
        }
        return req.getParameter("isConnectingErrorPage") != null;
    }

    private static Object getFromReqStateParams(HttpServletRequest req, String key) {
        Map stateParams = InternalAuthnApiSupport.getDefault().getStateParams(req);
        if (stateParams != null) {
            return stateParams.get(key);
        }
        return null;
    }

    private void saveToSessionStateForProfileManagement(DN dn, HttpServletRequest req, HttpServletResponse resp) {
        String keyName = this.localIdentityProfile.getDnHandoffStateKey();
        this.sessionStateSupport.setAttribute(keyName, (Object)dn.toNormalizedString(), req, resp, false);
    }

    private boolean isEmailStatusVerified(Map<String, Object> attributes) {
        String statusValue;
        String statusLipFieldId = this.localIdentityProfile.getEmailOwnershipVerificationConfig().getFieldStoringVerificationStatus();
        String string = statusValue = attributes.containsKey(statusLipFieldId) ? ((AttributeValue)attributes.get(statusLipFieldId)).getValue() : null;
        if (StringUtils.isNotBlank(statusValue) && Boolean.parseBoolean(statusValue)) {
            String emailValue = SendEmailVerification.getEmail(this.localIdentityProfile, attributes);
            log.debug((Object)("The email " + emailValue + " has the ownership status field set to true."));
            return true;
        }
        return false;
    }

    private List<String> filterWebAuthNSource(HttpServletRequest req, List<String> authSourceStrings) {
        boolean containsFIDO = authSourceStrings.removeIf(source -> "FIDO".equals(source));
        if (containsFIDO) {
            String sourceName = WebAuthNUtil.getSourceName(req);
            authSourceStrings.add(sourceName);
        }
        return authSourceStrings;
    }

    public PluginApiSpec getApiSpec() {
        List<AuthnStateSpec> states = Arrays.asList(CommonStateSpec.REGISTRATION_REQUIRED_AUTHN_STATE_SPEC, CommonStateSpec.ACCOUNT_LINKING_FAILED, CommonStateSpec.EMAIL_VERIFICATION_REQUIRED, CommonStateSpec.EMAIL_VERIFICATION_OTP_REQUIRED);
        return new PluginApiSpec(states);
    }

    LocaleUtilWrapper getLocaleUtil() {
        if (this.localeUtil == null) {
            this.setLocaleUtil(new LocaleUtilWrapper());
        }
        return this.localeUtil;
    }

    void setLocaleUtil(LocaleUtilWrapper localeUtil) {
        this.localeUtil = localeUtil;
    }

    private boolean requireVerifiedEmail() {
        return this.localIdentityProfile.getEmailOwnershipVerificationConfig() != null && this.localIdentityProfile.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled() && this.localIdentityProfile.getEmailOwnershipVerificationConfig().isRequireVerifiedEmail();
    }

    private boolean isEmailVerificationRequest(Map<String, Object> inParameters) {
        Boolean isEmailVerificationRequest = (Boolean)inParameters.get(EMAIL_VERIFICATION_REQUEST);
        return isEmailVerificationRequest != null && isEmailVerificationRequest != false;
    }

    private boolean isProfileManagementRequest(Map<String, Object> inParameters) {
        Boolean isProfileManagementRequest = (Boolean)inParameters.get(PROFILE_MANAGEMENT_REQUEST);
        return isProfileManagementRequest != null && isProfileManagementRequest != false;
    }

    public static boolean isVerifiedEmailPosted(HttpServletRequest req) {
        return LocalIdentityAdapter.isRequireVerifiedEmailPosted(req) || Boolean.TRUE.equals(req.getAttribute(VERIFY_EMAIL_FORM));
    }

    private static boolean isRequireVerifiedEmailPosted(HttpServletRequest req) {
        return req.getParameter(VERIFY_EMAIL_FORM) != null || LocalIdentityAdapter.isOtpVerifiedEmailPosted(req) || LocalIdentityAdapter.getAdapterApiState(req) == AdapterApiState.REQUIRE_VERIFIED_EMAIL;
    }

    public static boolean isOtpVerifiedEmailPosted(HttpServletRequest req) {
        return req.getParameter(OTP_EMAIL_FORM) != null;
    }

    private AuthnAdapterResponse doEmailVerificationFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction) throws IOException, AuthnAdapterException {
        if (LocalIdentityUtils.isOtpEmailVerificationType(this.localIdentityProfile) && !AuthnApiSupport.getDefault().isApiRequest(req) && CrossSiteRequestForgeryHelper.validateCSRFToken(req, resp) == null) {
            return this.failVerifiedEmailFlow(req, resp, inParameters);
        }
        LocalIdentityDTO<DN> localIdentityDTO = this.getLipDto(req, resp);
        if (localIdentityDTO == null) {
            return this.cancelVerifiedEmailFlow(req, resp, inParameters);
        }
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return this.handleEmailVerificationAuthnApiFlow(req, resp, inParameters, allowInteraction, localIdentityDTO);
        }
        return this.handleEmailVerificationTemplateFlow(req, resp, inParameters, allowInteraction, localIdentityDTO);
    }

    private AuthnAdapterResponse handleEmailVerificationAuthnApiFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction, LocalIdentityDTO<DN> localIdentityDTO) throws IOException, AuthnAdapterException {
        AuthnError authnError = null;
        if (LocalIdentityAdapter.isResendAction(req)) {
            Map<String, Object> userAttributes = localIdentityDTO.getAttributesForMapping();
            if (this.localIdentityProfile.getEmailOwnershipVerificationConfig() != null && this.localIdentityProfile.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled() && !this.isEmailStatusVerified(userAttributes)) {
                SendEmailVerification sendEmailVerification = new SendEmailVerification();
                sendEmailVerification.sendEmail(req, resp, this.localIdentityProfile, localIdentityDTO, inParameters);
            }
        } else if (this.isSkipAction(req)) {
            if (!this.requireVerifiedEmail()) {
                LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.SKIP_OTP, localIdentityDTO, this.localIdentityProfile, null, req, resp);
                LocalIdentityAuditLogger.log();
            }
        } else if (LocalIdentityAdapter.isContinueAction(req)) {
            if (LocalIdentityUtils.isOtpEmailVerificationType(this.localIdentityProfile)) {
                try {
                    ParamMapping otpParamMapping = new ParamMapping("otp", CheckOtp.class, CheckOtp::getOtp, Function.identity());
                    String otpSubmitted = (String)otpParamMapping.getValue(req);
                    LocalIdentityValidationResult localIdentityValidationResult = this.verifyOtp(req, resp, localIdentityDTO, otpSubmitted);
                    if (localIdentityValidationResult.getValidationResultType() == LocalIdentityValidationResult.ValidationResultType.TooManyAttempts) {
                        return this.failVerifiedEmailFlow(req, resp, inParameters);
                    }
                    authnError = this.getAuthnErrorFromLocalIdentityValidationResult(localIdentityValidationResult);
                }
                catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                    authnError = CommonErrorSpec.REQUEST_FAILED.makeInstance();
                }
            }
        } else if (LocalIdentityAdapter.isCancelAction(req)) {
            return this.cancelVerifiedEmailFlow(req, resp, inParameters);
        }
        return this.doSSO(req, resp, inParameters, allowInteraction, null, authnError);
    }

    private AuthnAdapterResponse handleEmailVerificationTemplateFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean allowInteraction, LocalIdentityDTO<DN> localIdentityDTO) throws IOException, AuthnAdapterException {
        String messageKeyPrefix = LocalIdentityAdapter.isOtpVerifiedEmailPosted(req) ? "local.identity.email.verification.otp." : "local.identity.email.verification.required.";
        TemplateBannerMessage bannerMessage = null;
        if (LocalIdentityAdapter.isResendAction(req)) {
            Map<String, Object> userAttributes = localIdentityDTO.getAttributesForMapping();
            if (this.localIdentityProfile.getEmailOwnershipVerificationConfig() != null && this.localIdentityProfile.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled() && !this.isEmailStatusVerified(userAttributes)) {
                SendEmailVerification sendEmailVerification = new SendEmailVerification();
                sendEmailVerification.sendEmail(req, resp, this.localIdentityProfile, localIdentityDTO, inParameters);
                String emailValue = SendEmailVerification.getEmail(this.localIdentityProfile, userAttributes);
                bannerMessage = new TemplateBannerMessage(messageKeyPrefix + "resentNotification", new String[]{emailValue}, TemplateBannerMessage.TemplateMessageType.SUCCESS);
            }
        } else if (this.isSkipAction(req)) {
            if (this.requireVerifiedEmail()) {
                bannerMessage = new TemplateBannerMessage("local.identity.email.verification.otp.skipNotAllowed", null, TemplateBannerMessage.TemplateMessageType.ERROR);
            } else {
                LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.SKIP_OTP, localIdentityDTO, this.localIdentityProfile, null, req, resp);
                LocalIdentityAuditLogger.log();
            }
        } else if (LocalIdentityAdapter.isContinueAction(req)) {
            if (LocalIdentityUtils.isOtpEmailVerificationType(this.localIdentityProfile)) {
                try {
                    String otpSubmitted = req.getParameter("oneTimePasscode");
                    LocalIdentityValidationResult localIdentityValidationResult = this.verifyOtp(req, resp, localIdentityDTO, otpSubmitted);
                    if (localIdentityValidationResult.getValidationResultType() == LocalIdentityValidationResult.ValidationResultType.TooManyAttempts) {
                        return this.failVerifiedEmailFlow(req, resp, inParameters);
                    }
                    bannerMessage = this.getBannerMessageFromLocalIdentityValidationResult(localIdentityValidationResult, messageKeyPrefix);
                }
                catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                    bannerMessage = new TemplateBannerMessage(messageKeyPrefix + "generalError", null, TemplateBannerMessage.TemplateMessageType.ERROR);
                }
            } else {
                bannerMessage = new TemplateBannerMessage(messageKeyPrefix + "continueNotification", null, TemplateBannerMessage.TemplateMessageType.NOTICE);
            }
        } else if (LocalIdentityAdapter.isCancelAction(req)) {
            return this.cancelVerifiedEmailFlow(req, resp, inParameters);
        }
        return this.doSSO(req, resp, inParameters, allowInteraction, bannerMessage, null);
    }

    private AuthnAdapterResponse failVerifiedEmailFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException, AuthnAdapterException {
        this.clearStateAndCleanUp(req, resp, inParameters);
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            req.setAttribute(VERIFY_EMAIL_FORM, (Object)true);
        }
        return this.failureResponse();
    }

    private AuthnAdapterResponse cancelVerifiedEmailFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException, AuthnAdapterException {
        this.clearStateAndCleanUp(req, resp, inParameters);
        return this.restartTree();
    }

    private void clearStateAndCleanUp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException, AuthnAdapterException {
        this.removeAdapterApiState(req);
        this.removePolicyAction(req, resp);
        this.removeResumeRegistration(req, resp, inParameters);
        this.getTransactionalStateSupportForResumeUrl(inParameters).removeAttribute(REGISTRATION_SHARED_MACHINE, req, resp);
        this.logout(req, resp);
        List adapterKeysThatHaveSessions = (List)inParameters.get(LIP_SESSION_ADAPTERS);
        AdapterManager adapterManager = MgmtFactory.getAdapterManager();
        for (AdapterAuthnSourceKey adapterKey : adapterKeysThatHaveSessions) {
            String adapterInstanceId = adapterKey.getId();
            String connectionId = adapterKey.getConnectionId();
            IdpAuthenticationAdapter idpAuthnAdapter = adapterManager.getIdpAuthnAdapterWithConnectionOverride(adapterInstanceId, connectionId);
            idpAuthnAdapter.logoutAuthN(Collections.EMPTY_MAP, req, resp, (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        }
        String localSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        IdpSessionRegistrySupport.checkLogSessionDeleted(req, resp);
        IdpSessionRegistrySupport.setSessionBeansInvalidForSso(Collections.singletonList(localSessionId));
        IdpSessionRegistrySupport.deleteStoredSessions(req, resp, null);
        AuthnSessionInfo info = (AuthnSessionInfo)inParameters.get(LIP_SESSION_INFO);
        if (info != null) {
            info.getBeans().clear();
        }
    }

    private void renderRequireVerifiedEmailTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> userAttributes, Map<String, Object> inParameters, TemplateBannerMessage bannerMessage) throws TemplateRendererUtilException {
        String emailValue = SendEmailVerification.getEmail(this.localIdentityProfile, userAttributes);
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.populateGeneralTemplateParameters(params, userAttributes, bannerMessage);
        params.put("url", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("continue", VERIFY_EMAIL_CONTINUE);
        params.put("continueButtonTitle", "continueButtonTitle");
        params.put("resend", VERIFY_EMAIL_RESEND);
        params.put("cancel", VERIFY_EMAIL_CANCEL);
        params.put("isProfileManagementEnabled", this.localIdentityProfile.isProfileEnabled());
        if (this.localIdentityProfile.isProfileEnabled()) {
            params.put("profileManagement", VERIFY_EMAIL_PROFILE_MANAGEMENT);
            params.put("profileManagementPath", AdapterPathSupport.convertPath(req, resp, LocalIdentityUtils.getProfileManagementPathWithLipId(this.localIdentityProfile.getId())));
        }
        StandardTemplateMessage message = new StandardTemplateMessage("local.identity.email.verification.required.description.2", new String[]{emailValue});
        params.put("descriptionMessage", message);
        this.renderTemplate(req, resp, this.localIdentityProfile.getEmailOwnershipVerificationConfig().getRequireVerifiedEmailTemplateName(), params);
    }

    private void renderOtpEmailVerificationTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> userAttributes, Map<String, Object> inParameters, TemplateBannerMessage bannerMessage) throws TemplateRendererUtilException {
        String emailValue = SendEmailVerification.getEmail(this.localIdentityProfile, userAttributes);
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.populateGeneralTemplateParameters(params, userAttributes, bannerMessage);
        params.put("cSRFToken", CrossSiteRequestForgeryHelper.getCSRFToken(req, resp));
        if (StringUtils.isNotBlank((String)emailValue)) {
            params.put("emailSentTo", emailValue);
        }
        params.put("url", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("isSkipAvailable", !this.requireVerifiedEmail());
        params.put("skipOtpVerification", OTP_EMAIL_SKIP_OTP);
        params.put("otpVerification", OTP_EMAIL_VERIFY_OTP);
        params.put("sendEmailVerification", OTP_EMAIL_RESEND_OTP);
        params.put("cancel", CANCEL);
        params.put("isProfileManagementEnabled", this.localIdentityProfile.isProfileEnabled());
        if (this.localIdentityProfile.isProfileEnabled()) {
            params.put("profileManagement", VERIFY_EMAIL_PROFILE_MANAGEMENT);
            params.put("profileManagementPath", AdapterPathSupport.convertPath(req, resp, LocalIdentityUtils.getProfileManagementPathWithLipId(this.localIdentityProfile.getId())));
        }
        this.renderTemplate(req, resp, this.localIdentityProfile.getEmailOwnershipVerificationConfig().getEmailVerificationOtpTemplateName(), params);
    }

    private void writeAuthnApiResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> userAttributes, AuthnError authnError) {
        String emailValue = SendEmailVerification.getEmail(this.localIdentityProfile, userAttributes);
        this.setAdapterApiState(req, AdapterApiState.REQUIRE_VERIFIED_EMAIL);
        try {
            if (authnError != null) {
                AuthnApiSupport.getDefault().writeErrorResponse(req, resp, authnError);
            } else {
                AuthnState authnState;
                EmailVerificationRequired model = new EmailVerificationRequired();
                model.setEmail(emailValue);
                if (this.localIdentityProfile.isProfileEnabled()) {
                    model.setProfileManagementUrl(BaseUrlAccessor.getCurrentBaseUrl() + LocalIdentityUtils.getProfileManagementPathWithLipId(this.localIdentityProfile.getId()));
                }
                if (LocalIdentityUtils.isOtpEmailVerificationType(this.localIdentityProfile)) {
                    authnState = CommonStateSpec.EMAIL_VERIFICATION_OTP_REQUIRED.makeInstance(req, (Object)model);
                    if (this.requireVerifiedEmail()) {
                        authnState.removeAction("skipOtp");
                    }
                } else {
                    authnState = CommonStateSpec.EMAIL_VERIFICATION_REQUIRED.makeInstance(req, (Object)model);
                }
                AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, authnState);
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to render an Authn API response.", (Throwable)e);
        }
    }

    private void populateGeneralTemplateParameters(Map<String, Object> params, Map<String, Object> userAttributes, TemplateBannerMessage bannerMessage) {
        if (userAttributes != null && !userAttributes.isEmpty()) {
            params.put(AdapterDefaultTemplateParams.USER_ATTRIBUTES.getParamName(), userAttributes);
        }
        if (bannerMessage != null) {
            TemplateMessageHolder bannerMessages = new TemplateMessageHolder();
            bannerMessages.addMessage(bannerMessage);
            params.put("bannerMessages", bannerMessages);
        }
    }

    private LocalIdentityDTO<DN> getLipDto(HttpServletRequest req, HttpServletResponse resp) throws AuthnAdapterException {
        LocalIdentityDTO<DN> localIdentityDTO;
        DN dn = this.getDNFromSession(req, resp);
        if (dn == null) {
            log.debug((Object)"Could not find user DN from session.");
            return null;
        }
        try {
            LocalIdentityStorageManager<DN> manager = this.localIdentityProfile.getStorageManager();
            localIdentityDTO = manager.getIdentityByDn(this.localIdentityProfile, dn);
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)("Could not find user with DN " + dn + " due to: " + e.toString()));
            log.debug((Object)("Could not find user with DN " + dn + "."), (Throwable)e);
            throw new AuthnAdapterException("Unable to continue.");
        }
        return localIdentityDTO;
    }

    private void updateEmailVerifiedStatus(LocalIdentityDTO<DN> localIdentityDTO) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        HashMap updatedAttributes = new HashMap();
        String statusLipFieldId = this.localIdentityProfile.getEmailOwnershipVerificationConfig().getFieldStoringVerificationStatus();
        List<LocalIdentityField<?>> fields = this.localIdentityProfile.getFieldConfig().getListOfAllFields();
        String[] parameterValue = new String[]{"TRUE"};
        for (LocalIdentityField<?> field : fields) {
            if (!field.getData().getId().equals(statusLipFieldId)) continue;
            updatedAttributes.put(statusLipFieldId, field.getFieldData(parameterValue));
            break;
        }
        LocalIdentityStorageManager<DN> localIdentityStorageManager = this.localIdentityProfile.getStorageManager();
        localIdentityStorageManager.updateIdentity(this.localIdentityProfile, localIdentityDTO.getIdentifier(), updatedAttributes);
    }

    private LocalIdentityValidationResult verifyOtp(HttpServletRequest req, HttpServletResponse resp, LocalIdentityDTO<DN> localIdentityDTO, String otpSubmitted) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        LocalIdentityValidationResult otpVerificationResult = LocalIdentityUtils.validateOtp(req, resp, otpSubmitted, this.localIdentityProfile, localIdentityDTO);
        if (LocalIdentityValidationResult.ValidationResultType.Success == otpVerificationResult.getValidationResultType()) {
            this.updateEmailVerifiedStatus(localIdentityDTO);
        }
        return otpVerificationResult;
    }

    private TemplateBannerMessage getBannerMessageFromLocalIdentityValidationResult(LocalIdentityValidationResult localIdentityValidationResult, String messageKeyPrefix) {
        switch (localIdentityValidationResult.getValidationResultType()) {
            case Expired: 
            case Invalid: 
            case Error: {
                return new TemplateBannerMessage(messageKeyPrefix + localIdentityValidationResult.getErrorKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR);
            }
        }
        return null;
    }

    private AuthnError getAuthnErrorFromLocalIdentityValidationResult(LocalIdentityValidationResult localIdentityValidationResult) {
        AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
        switch (localIdentityValidationResult.getValidationResultType()) {
            case Expired: {
                authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.OTP_EXPIRED.makeInstance()));
                break;
            }
            case Invalid: {
                authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_OTP.makeInstance()));
                break;
            }
            default: {
                return null;
            }
        }
        return authnError;
    }

    private boolean initialRegistrationWithOtpEmailVerificationType(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        return this.isRegistration(req, resp, inParameters) && LocalIdentityUtils.isOtpEmailVerificationType(this.localIdentityProfile) && !this.isSkipAction(req);
    }

    private boolean isSkipAction(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return CommonActionSpec.SKIP_OTP.isRequested(req);
        }
        return req.getParameter(OTP_EMAIL_SKIP_OTP) != null && "clicked".equals(req.getParameter(OTP_EMAIL_SKIP_OTP));
    }

    public static boolean isResendAction(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return CommonActionSpec.SEND_EMAIL_VERIFICATION_OTL.isRequested(req) || CommonActionSpec.RESEND_OTP.isRequested(req);
        }
        String resendKey = LocalIdentityAdapter.isOtpVerifiedEmailPosted(req) ? OTP_EMAIL_RESEND_OTP : VERIFY_EMAIL_RESEND;
        return req.getParameter(resendKey) != null && "clicked".equals(req.getParameter(resendKey));
    }

    public static boolean isContinueAction(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return CommonActionSpec.POLL.isRequested(req) || CommonActionSpec.CHECK_OTP.isRequested(req);
        }
        String resendKey = LocalIdentityAdapter.isOtpVerifiedEmailPosted(req) ? OTP_EMAIL_VERIFY_OTP : VERIFY_EMAIL_CONTINUE;
        return req.getParameter(resendKey) != null && "clicked".equals(req.getParameter(resendKey));
    }

    public static boolean isCancelAction(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return CommonActionSpec.CANCEL.isRequested(req);
        }
        String resendKey = LocalIdentityAdapter.isOtpVerifiedEmailPosted(req) ? CANCEL : VERIFY_EMAIL_CANCEL;
        return req.getParameter(resendKey) != null && "clicked".equals(req.getParameter(resendKey));
    }

    private static enum AdapterApiState {
        REGISTER,
        LOGIN,
        REQUIRE_VERIFIED_EMAIL;

    }
}

