/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.localidentity.ConnectedIdentity;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.unboundid.ldap.sdk.DN;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;

public class LocalIdentityAuditLogger
extends AuditLogger {
    private static final Log log = LogFactory.getLog(IdpAuditLogger.class);

    public static void init(LocalIdentityAuditEvent event, LocalIdentityDTO<DN> dto, LocalIdentityProfile profile, String authnSourceId, HttpServletRequest request, HttpServletResponse response) {
        TrackingIdSupport.setTrackingIdInThreadContext(request, response);
        AuditLogger.init();
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)event.getRole());
        AuditLogger.setRequestStartTime(request);
        String username = LocalIdentityAuditLogger.getUsername(dto);
        if (StringUtils.isNotBlank((String)username)) {
            AuditLogger.setUserName(username);
            AuditLogger.setLocalUserId(username);
        }
        AuditLogger.setAdapterInstanceId(LocalIdentityAuditLogger.buildAuthSourceID(profile, authnSourceId));
        AuditLogger.setRemoteAddress(request.getRemoteAddr());
        AuditLogger.setEvent(event.toString());
    }

    private static String getUsername(LocalIdentityDTO<DN> dto) {
        if (dto == null) {
            return null;
        }
        String username = null;
        if (dto.hasLocalIdentity()) {
            Optional<ConnectedIdentity> identity = dto.getConnectedIdentities().stream().filter(ConnectedIdentity::isLocalIdentity).findFirst();
            username = identity.isPresent() ? identity.get().getUserId() : username;
        } else if (dto.getIdentifier() != null && dto.getIdentifier().getRDN().getAttributeValues().length > 0) {
            username = dto.getIdentifier().getRDN().getAttributeValues()[0];
        }
        return username;
    }

    public static void log() {
        ThreadContext.put((String)AuditLogger.MDC_KEY.DESCRIPTION.toString(), (String)"");
        LocalIdentityAuditLogger.updateResponseTime();
        log.info((Object)"");
        TrackingIdSupport.createUserCrossReference();
    }

    public static void logFailure(String description) {
        AuditLogger.setStatus("failure");
        AuditLogger.setDescription(description);
        log.info((Object)"");
    }

    private static String buildAuthSourceID(LocalIdentityProfile profile, String authnSourceId) {
        if (profile == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        sb.append(profile.getName());
        if (StringUtils.isNotBlank((String)authnSourceId)) {
            sb.append(", Auth Source: ");
            sb.append(profile.getAuthSourceById(authnSourceId).getSource());
        }
        sb.append("]");
        return sb.toString();
    }

    public static void setAttributes(List<LocalIdentityField<?>> fieldConfigList, Map<String, FieldData<?>> attributes) {
        AttributeMap attributeMap = new AttributeMap();
        if (attributes != null) {
            for (Map.Entry<String, FieldData<?>> entry : attributes.entrySet()) {
                AttributeValue value;
                if (entry.getValue().isMultiValue()) {
                    List<String> values = entry.getValue().getValues() != null ? Arrays.stream(entry.getValue().getValues()).filter(Objects::nonNull).map(object -> Objects.toString(object, null)).collect(Collectors.toList()) : Collections.singletonList("");
                    value = new AttributeValue(values);
                } else {
                    value = new AttributeValue(entry.getValue().getFirstValue().toString());
                }
                if (fieldConfigList != null && !fieldConfigList.isEmpty()) {
                    Optional<LocalIdentityField> aConfig = fieldConfigList.stream().filter(f -> ((String)entry.getKey()).equals(f.getData().getId())).findFirst();
                    value.setMasked(aConfig.map(LocalIdentityField::isMasked).orElse(false).booleanValue());
                }
                attributeMap.put(entry.getKey(), value);
            }
        }
        AuditLogger.setAttributes(attributeMap.toString());
    }

    public static enum LocalIdentityAuditEvent {
        REGISTER("IdP"),
        PROFILE_ATTRIBUTE_CHANGE("SP"),
        AUTHN_SOURCE_CONNECT("IdP"),
        AUTHN_SOURCE_DISCONNECT("SP"),
        ACCOUNT_DELETE("SP"),
        PWD_CHANGE("SP"),
        PWD_SET("SP"),
        EMAIL_ADDRESS_VERIFICATION_SEND("SP"),
        EMAIL_ADDRESS_VERIFY("SP"),
        VERIFY_OTP("SP"),
        SKIP_OTP("SP"),
        EXCEEDED_ATTEMPTS_FOR_OTP("SP");

        private final String role;

        private LocalIdentityAuditEvent(String aRole) {
            this.role = aRole;
        }

        public String getRole() {
            return this.role;
        }
    }
}

