/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;

public class LocalIdentityException
extends Exception {
    public LocalIdentityException(String message) {
        super(message);
    }

    public static class IdentityIsNotUniqueException
    extends LocalIdentityException {
        private LocalIdentityAuthSource authSource;
        private String uniqueId;

        public IdentityIsNotUniqueException(String message, LocalIdentityAuthSource authSource, String uniqueId) {
            super(message);
            this.authSource = authSource;
            this.uniqueId = uniqueId;
        }

        public String getValidationMessage() {
            if (this.authSource != null && this.authSource.isLocalAccountAuthSource()) {
                return String.format("Account already exists for '%s'", this.uniqueId);
            }
            if (this.authSource != null) {
                return "An account is already linked to this identity. Please sign on.";
            }
            return "Registration failed, invalid authentication source";
        }
    }

    public static class UniqueIdNotFound
    extends LocalIdentityException {
        public UniqueIdNotFound(String message) {
            super(message);
        }
    }
}

