/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.localidentity.LocalIdentityException;
import com.pingidentity.localidentity.errors.LocalIdentityGeneralError;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import org.apache.commons.lang.StringUtils;

public class RegistrationFailedException
extends LocalIdentityException {
    private final String messageKey;

    public RegistrationFailedException(String message) {
        super(message);
        this.messageKey = null;
    }

    public RegistrationFailedException(String message, String localizationMessageKey) {
        super(message);
        this.messageKey = localizationMessageKey;
    }

    public AuthnError getAuthnApiError() {
        LocalIdentityGeneralError error = new LocalIdentityGeneralError();
        error.addErrorDetail(this.getErrorDetail());
        return error.getApiError();
    }

    private AuthnErrorDetail getErrorDetail() {
        AuthnErrorDetail.Builder builder = CommonErrorDetailSpec.REGISTRATION_FAILED.makeInstanceBuilder();
        builder.userMessage(this.getMessage());
        if (StringUtils.isNotBlank((String)this.messageKey)) {
            builder.userMessageKey(this.messageKey);
        }
        return builder.build();
    }
}

