/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.attrupdates;

import com.pingidentity.localidentity.attrupdates.AuthSourceAttributes;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSourceAttributeUpdateProcessor {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthSourceAttributes authSourceAttrs;
    private final LocalIdentityAuthSource authSource;
    private boolean needsUpdate = false;

    public AuthSourceAttributeUpdateProcessor(LocalIdentityAuthSource authSource, Map<String, Object> inParams) {
        this.authSource = authSource;
        Object chainedAttrsObj = inParams.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        Map authSourceAttrs = chainedAttrsObj != null ? (Map)chainedAttrsObj : Collections.emptyMap();
        this.authSourceAttrs = new AuthSourceAttributes(authSource, authSourceAttrs);
    }

    public String getJsonString() {
        if (this.authSource.getUpdatePolicy().isStoreAttributes()) {
            return this.authSourceAttrs.toJsonString();
        }
        return "";
    }

    public AuthSourceAttributes mergeAttributes(AuthSourceAttributes currentAttributes) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Checking attributes for source '" + this.authSource.getSource() + "'."));
        }
        if (currentAttributes == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"No attributes found for auth source. Updating all attributes.");
            }
            this.needsUpdate = true;
            return this.authSourceAttrs;
        }
        Map<String, AuthSourceAttributes.AuthSourceAttribute> currentAttributesMap = currentAttributes.getAttributes();
        for (Map.Entry<String, AuthSourceAttributes.AuthSourceAttribute> newAttribute : this.authSourceAttrs.getAttributes().entrySet()) {
            if (currentAttributesMap.containsKey(newAttribute.getKey())) {
                AuthSourceAttributes.AuthSourceAttribute currentAttribute = currentAttributesMap.get(newAttribute.getKey());
                if (!currentAttribute.needsUpdate(newAttribute.getValue(), this.authSource.getUpdatePolicy().getUpdateIntervalInSeconds())) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Update interval passed. Updating attribute '" + newAttribute.getKey() + "'."));
                }
                currentAttributesMap.put(newAttribute.getKey(), newAttribute.getValue());
                this.needsUpdate = true;
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("New attribute '" + newAttribute.getKey() + "' found, adding attribute."));
            }
            currentAttributesMap.put(newAttribute.getKey(), newAttribute.getValue());
            this.needsUpdate = true;
        }
        return currentAttributes;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }
}

