/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.attrupdates;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class AuthSourceAttributes
implements Serializable {
    private static final long serialVersionUID = 123L;
    private static final Log log = LogFactory.getLog(AuthSourceAttributes.class);
    private final String authSourceId;
    private final Map<String, AuthSourceAttribute> attributes;

    public AuthSourceAttributes(LocalIdentityAuthSource authSource, Map<String, AttributeValue> incomingAttrs) {
        Map<String, AuthSourceAttribute> authSourceAttributes;
        this.authSourceId = authSource.getId();
        if (incomingAttrs != null) {
            authSourceAttributes = new HashMap(incomingAttrs.size());
            for (Map.Entry<String, AttributeValue> attribute : incomingAttrs.entrySet()) {
                Object value = attribute.getValue().isMultiValue() ? attribute.getValue().getValuesAsCollection() : attribute.getValue().getValue();
                authSourceAttributes.put(attribute.getKey(), new AuthSourceAttribute(value));
            }
        } else {
            authSourceAttributes = Collections.emptyMap();
        }
        this.attributes = authSourceAttributes;
    }

    @JsonCreator
    public AuthSourceAttributes(@JsonProperty(value="authSourceId") String authSourceId, @JsonProperty(value="attributes") Map<String, AuthSourceAttribute> attrs) {
        this.authSourceId = authSourceId;
        this.attributes = attrs;
    }

    public String getAuthSourceId() {
        return this.authSourceId;
    }

    public Map<String, AuthSourceAttribute> getAttributes() {
        return this.attributes;
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            log.warn((Object)("Failed to process JSON for " + this.authSourceId + " due to " + e.getMessage()));
            log.debug((Object)"Failed to process JSON.", (Throwable)e);
            return "";
        }
    }

    public static AuthSourceAttributes fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (AuthSourceAttributes)mapper.readValue(json, AuthSourceAttributes.class);
        }
        catch (IOException e) {
            log.warn((Object)("Failed to parse JSON due to " + e.getMessage()));
            log.debug((Object)"Failed to parse JSON.", (Throwable)e);
            throw e;
        }
    }

    public static class AuthSourceAttribute
    implements Serializable {
        private static final long serialVersionUID = 412L;
        private Object value;
        private long lastUpdated;

        public AuthSourceAttribute(Object value) {
            Instant instant = Instant.now();
            this.lastUpdated = instant.getEpochSecond();
            this.value = value;
        }

        @JsonCreator
        public AuthSourceAttribute(@JsonProperty(value="value") Object value, @JsonProperty(value="lastUpdated") long lastUpdated) {
            this.value = value;
            this.lastUpdated = lastUpdated;
        }

        public Object getValue() {
            return this.value;
        }

        public long getLastUpdated() {
            return this.lastUpdated;
        }

        public boolean needsUpdate(AuthSourceAttribute newAttribute, long updateInterval) {
            return this.getLastUpdated() + updateInterval <= newAttribute.getLastUpdated();
        }
    }
}

