/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.errors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.locale.StandardTemplateMessage;
import com.pingidentity.locale.TemplateMessage;
import com.pingidentity.localidentity.errors.LocalIdentityError;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import java.util.ArrayList;
import java.util.List;

public class LocalIdentityFieldsError
implements LocalIdentityError<LocalIdentityFieldError> {
    private List<LocalIdentityFieldError> errorDetails = new ArrayList<LocalIdentityFieldError>();

    @Override
    public AuthnError getApiError() {
        AuthnError.Builder authnErrorBuilder = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder();
        this.errorDetails.forEach(arg_0 -> ((AuthnError.Builder)authnErrorBuilder).detail(arg_0));
        return authnErrorBuilder.build();
    }

    @Override
    public List<TemplateMessage> getTemplateMessages() {
        ArrayList<TemplateMessage> messages = new ArrayList<TemplateMessage>();
        this.errorDetails.forEach(error -> messages.add(new StandardTemplateMessage(error.getUserMessageKey(), new String[]{error.getField().getData().getLabel()})));
        return messages;
    }

    @Override
    public void addErrorDetail(LocalIdentityFieldError error) {
        this.errorDetails.add(error);
    }

    public List<LocalIdentityFieldError> getErrorDetails() {
        return this.errorDetails;
    }

    public static class LocalIdentityFieldError
    extends AuthnErrorDetail {
        private LocalIdentityField<?> field;

        public LocalIdentityFieldError(Builder builder) {
            this.field = builder.field;
            this.setCode(builder.code);
            this.setUserMessage(builder.message);
            this.setUserMessageKey(builder.userMessageKey);
        }

        @JsonIgnore
        public LocalIdentityField<?> getField() {
            return this.field;
        }

        public String getTarget() {
            return this.field.getData().getId();
        }

        public static class Builder {
            private LocalIdentityField<?> field;
            private String code;
            private String message;
            private String userMessageKey;

            public Builder setField(LocalIdentityField<?> field) {
                this.field = field;
                return this;
            }

            public Builder setCode(String code) {
                this.code = code;
                return this;
            }

            public Builder setUserMessage(String message) {
                this.message = message;
                return this;
            }

            public Builder setUserMessageKey(String userMessageKey) {
                this.userMessageKey = userMessageKey;
                return this;
            }

            public LocalIdentityFieldError build() {
                return new LocalIdentityFieldError(this);
            }
        }
    }
}

