/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.errors;

import com.pingidentity.locale.TemplateBannerMessage;
import com.pingidentity.locale.TemplateMessage;
import com.pingidentity.localidentity.errors.LocalIdentityError;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LocalIdentityGeneralError
implements LocalIdentityError<AuthnErrorDetail> {
    private List<AuthnErrorDetail> errorDetails = new ArrayList<AuthnErrorDetail>();

    @Override
    public AuthnError getApiError() {
        AuthnError.Builder authnErrorBuilder = CommonErrorSpec.REGISTRATION_FAILED.makeInstanceBuilder();
        this.errorDetails.forEach(arg_0 -> ((AuthnError.Builder)authnErrorBuilder).detail(arg_0));
        return authnErrorBuilder.build();
    }

    @Override
    public List<TemplateMessage> getTemplateMessages() {
        ArrayList<TemplateMessage> templateMessages = new ArrayList<TemplateMessage>(this.errorDetails.size());
        this.errorDetails.forEach(error -> {
            if (StringUtils.isNotBlank((String)error.getUserMessageKey())) {
                templateMessages.add(new TemplateBannerMessage(error.getUserMessageKey(), new String[0], TemplateBannerMessage.TemplateMessageType.ERROR));
            }
        });
        return templateMessages;
    }

    @Override
    public void addErrorDetail(AuthnErrorDetail error) {
        this.errorDetails.add(error);
    }
}

